/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#ifndef PROLOGIN_HH_
# define PROLOGIN_HH_

# include <functional>

# include <string>

# include <vector>

/// Taille de la mine (longueur et largeur).
# define TAILLE_MINE               31

/// Nombre de tours à jouer avant la fin de la partie.
# define NB_TOURS                  100

/// Nombre de points de déplacement par tour par nain (standard).
# define NB_POINTS_DEPLACEMENT     5

/// Nombre de points d'action par tour par nain (standard).
# define NB_POINTS_ACTION          6

/// Nombre de points de vie d'un nain (standard).
# define VIE_NAIN                  10

/// Nombre de joueurs.
# define NB_JOUEURS                2

/// Nombre de nains (standard) par joueur.
# define NB_NAINS                  6

/// Dégât infligé par un coup de pioche à un nain (standard).
# define DEGAT_PIOCHE              3

/// Valeur cumulée maximale des minerais qu'un nain (standard) peut emporter avec lui.
# define BUTIN_MAX                 25

/// Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case.
# define COUT_DE_DEPLACEMENT          1

/// Nombre de points de déplacement pour qu'un nain (standard) se déplace d'une case lorsqu'il est agrippé.
# define COUT_ESCALADER            2

/// Nombre de points de déplacement pour qu'un nain (standard) se déplace vers une case occupée par une corde lorsqu'il est agrippé.
# define COUT_ESCALADER_CORDE      1

/// Nombre de points d'action pour qu'un nain (standard) mine un bloc.
# define COUT_MINER                6

/// Nombre de points d'action pour qu'un nain (standard) tire sur une corde.
# define COUT_TIRER                1

/// Nombre de points d'action pour qu'un nain (standard) lâche la paroi.
# define COUT_LACHER               0

/// Nombre de points d'action pour qu'un nain (standard) s'agrippe à la paroi.
# define COUT_AGRIPPER             0

/// Types de cases
typedef enum case_type {
  LIBRE, /* <- Case libre, qui peut abriter une corde et des nains (standard) */
  GRANITE, /* <- Granite (standard), qui peut cacher du minerai */
  OBSIDIENNE, /* <- Obsidienne */
  ERREUR_CASE, /* <- Erreur */
} case_type;
// This is needed for old compilers
namespace std
{
  template <> struct hash<case_type> {
    size_t operator()(const case_type& v) const {
      return hash<int>()(static_cast<int>(v));
    }
  };
}

/// Direction
typedef enum direction {
  HAUT, /* <- Direction : haut */
  BAS, /* <- Direction : bas */
  GAUCHE, /* <- Direction : gauche */
  DROITE, /* <- Direction : droite */
  ERREUR_DIRECTION, /* <- Erreur */
} direction;
// This is needed for old compilers
namespace std
{
  template <> struct hash<direction> {
    size_t operator()(const direction& v) const {
      return hash<int>()(static_cast<int>(v));
    }
  };
}

/// Erreurs possibles
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès. */
  PA_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points d'action pour réaliser cette action. */
  PM_INSUFFISANTS, /* <- Votre nain (standard) ne possède pas assez de points de déplacement pour réaliser ce déplacement. */
  HORS_LIMITES, /* <- L'action est en dehors des limites de la mine. */
  DIRECTION_INVALIDE, /* <- La direction spécifiée n'existe pas, ou vous n'êtes pas autorisé à cibler cette direction pour cette action. */
  ID_NAIN_INVALIDE, /* <- Le nain (standard) spécifié n'existe pas. */
  OBSTACLE_MUR, /* <- La position spécifiée est un mur. */
  OBSTACLE_NAIN, /* <- La position spécifiée est un nain (standard) adverse. */
  OBSTACLE_CORDE, /* <- Il y a déjà une corde dans la direction spécifiée. */
  PAS_DE_CIBLE, /* <- Il n'y a pas de nain (standard) ni de granite (standard) sur la position spécifiée. */
  NAIN_MORT, /* <- Le nain (standard) spécifié est mort. */
  PAS_ACCROCHE, /* <- Le nain (standard) n'est pas accroché. */
  DEJA_ACCROCHE, /* <- Le nain (standard) est déjà accroché. */
  PAS_DE_CORDE, /* <- Il n'y a pas de corde dans la direction spécifiée. */
  DRAPEAU_INVALIDE, /* <- Le drapeau spécifié n'existe pas. */
} erreur;
// This is needed for old compilers
namespace std
{
  template <> struct hash<erreur> {
    size_t operator()(const erreur& v) const {
      return hash<int>()(static_cast<int>(v));
    }
  };
}

/// Types d'actions
typedef enum action_type {
  ACTION_DEPLACER, /* <- Action ``deplacer`` */
  ACTION_LACHER, /* <- Action ``lacher`` */
  ACTION_MINER, /* <- Action ``miner`` */
  ACTION_POSER_CORDE, /* <- Action ``poser_corde`` */
  ACTION_TIRER, /* <- Action ``tirer`` */
  ACTION_AGRIPPER, /* <- Action ``agripper`` */
} action_type;
// This is needed for old compilers
namespace std
{
  template <> struct hash<action_type> {
    size_t operator()(const action_type& v) const {
      return hash<int>()(static_cast<int>(v));
    }
  };
}

/// Types de drapeaux de débug
typedef enum debug_drapeau {
  AUCUN_DRAPEAU, /* <- Aucun drapeau, enlève le drapeau présent */
  DRAPEAU_BLEU, /* <- Drapeau bleu */
  DRAPEAU_VERT, /* <- Drapeau vert */
  DRAPEAU_ROUGE, /* <- Drapeau rouge */
} debug_drapeau;
// This is needed for old compilers
namespace std
{
  template <> struct hash<debug_drapeau> {
    size_t operator()(const debug_drapeau& v) const {
      return hash<int>()(static_cast<int>(v));
    }
  };
}

/// Position dans la mine, donnée par deux coordonnées.
typedef struct position {
  int ligne;  /* <- Coordonnée : ligne */
  int colonne;  /* <- Coordonnée : colonne */
} position;


/// Minerai à récolter
typedef struct minerai {
  int resistance;  /* <- Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse */
  int rendement;  /* <- Valeur marchande du bloc de minerai */
} minerai;


/// Nain (standard)
typedef struct nain {
  position pos;  /* <- Position actuelle du nain (standard) */
  int vie;  /* <- Point(s) de vie restant du nain (standard) */
  int pa;  /* <- Point(s) d'action restant du nain (standard) */
  int pm;  /* <- Point(s) de déplacement restant du nain (standard) */
  bool accroche;  /* <- Le nain (standard) est accroché à la paroi ou à une corde */
  int butin;  /* <- Valeur marchande totale que le nain (standard) possède */
} nain;


/// Action de déplacement représentée dans l'historique.
typedef struct action_hist {
  action_type atype;  /* <- Type de l'action */
  int id_nain;  /* <- Numéro du nain (standard) concerné par l'action */
  direction dir;  /* <- Direction visée par le nain (standard) durant le déplacement */
  direction sens;  /* <- Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche. */
} action_hist;


/// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
extern "C" std::vector<direction> api_chemin(position pos1, position pos2);
static inline std::vector<direction> chemin(position pos1, position pos2)
{
  return api_chemin(pos1, pos2);
}


/// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
extern "C" erreur api_deplacer(int id_nain, direction dir);
static inline erreur deplacer(int id_nain, direction dir)
{
  return api_deplacer(id_nain, dir);
}


/// Le nain (standard) ``id_nain`` lâche la paroi.
extern "C" erreur api_lacher(int id_nain);
static inline erreur lacher(int id_nain)
{
  return api_lacher(id_nain);
}


/// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
extern "C" erreur api_agripper(int id_nain);
static inline erreur agripper(int id_nain)
{
  return api_agripper(id_nain);
}


/// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
extern "C" erreur api_miner(int id_nain, direction dir);
static inline erreur miner(int id_nain, direction dir)
{
  return api_miner(id_nain, dir);
}


/// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
extern "C" erreur api_tirer(int id_nain, direction dir_corde, direction sens);
static inline erreur tirer(int id_nain, direction dir_corde, direction sens)
{
  return api_tirer(id_nain, dir_corde, sens);
}


/// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
extern "C" erreur api_poser_corde(int id_nain, direction dir);
static inline erreur poser_corde(int id_nain, direction dir)
{
  return api_poser_corde(id_nain, dir);
}


/// Affiche le drapeau spécifié sur la case indiquée.
extern "C" erreur api_debug_afficher_drapeau(position pos, debug_drapeau drapeau);
static inline erreur debug_afficher_drapeau(position pos, debug_drapeau drapeau)
{
  return api_debug_afficher_drapeau(pos, drapeau);
}


/// Renvoie le type d'une case donnée.
extern "C" case_type api_type_case(position pos);
static inline case_type type_case(position pos)
{
  return api_type_case(pos);
}


/// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
extern "C" std::vector<position> api_liste_cordes();
static inline std::vector<position> liste_cordes()
{
  return api_liste_cordes();
}


/// Indique si une corde se trouve sur une case donnée.
extern "C" bool api_corde_sur_case(position pos);
static inline bool corde_sur_case(position pos)
{
  return api_corde_sur_case(pos);
}


/// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
extern "C" int api_nain_sur_case(position pos);
static inline int nain_sur_case(position pos)
{
  return api_nain_sur_case(pos);
}


/// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
extern "C" nain api_info_nain(int id_joueur, int id_nain);
static inline nain info_nain(int id_joueur, int id_nain)
{
  return api_info_nain(id_joueur, id_nain);
}


/// Renvoie la liste de tous les minerais dans la mine.
extern "C" std::vector<position> api_liste_minerais();
static inline std::vector<position> liste_minerais()
{
  return api_liste_minerais();
}


/// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
extern "C" minerai api_info_minerai(position pos);
static inline minerai info_minerai(position pos)
{
  return api_info_minerai(pos);
}


/// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
extern "C" int api_cout_de_deplacement(int id_nain, direction dir);
static inline int cout_de_deplacement(int id_nain, direction dir)
{
  return api_cout_de_deplacement(id_nain, dir);
}


/// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
extern "C" position api_position_taverne(int id_joueur);
static inline position position_taverne(int id_joueur)
{
  return api_position_taverne(id_joueur);
}


/// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
extern "C" std::vector<action_hist> api_historique();
static inline std::vector<action_hist> historique()
{
  return api_historique();
}


/// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
extern "C" int api_score(int id_joueur);
static inline int score(int id_joueur)
{
  return api_score(id_joueur);
}


/// Renvoie votre numéro de joueur.
extern "C" int api_moi();
static inline int moi()
{
  return api_moi();
}


/// Renvoie le numéro de joueur de votre adversaire.
extern "C" int api_adversaire();
static inline int adversaire()
{
  return api_adversaire();
}


/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
extern "C" bool api_annuler();
static inline bool annuler()
{
  return api_annuler();
}


/// Retourne le numéro du tour actuel.
extern "C" int api_tour_actuel();
static inline int tour_actuel()
{
  return api_tour_actuel();
}


/// Affiche le contenu d'une valeur de type case_type
extern "C" void api_afficher_case_type(case_type v);
static inline void afficher_case_type(case_type v)
{
  api_afficher_case_type(v);
}


/// Affiche le contenu d'une valeur de type direction
extern "C" void api_afficher_direction(direction v);
static inline void afficher_direction(direction v)
{
  api_afficher_direction(v);
}


/// Affiche le contenu d'une valeur de type erreur
extern "C" void api_afficher_erreur(erreur v);
static inline void afficher_erreur(erreur v)
{
  api_afficher_erreur(v);
}


/// Affiche le contenu d'une valeur de type action_type
extern "C" void api_afficher_action_type(action_type v);
static inline void afficher_action_type(action_type v)
{
  api_afficher_action_type(v);
}


/// Affiche le contenu d'une valeur de type debug_drapeau
extern "C" void api_afficher_debug_drapeau(debug_drapeau v);
static inline void afficher_debug_drapeau(debug_drapeau v)
{
  api_afficher_debug_drapeau(v);
}


/// Affiche le contenu d'une valeur de type position
extern "C" void api_afficher_position(position v);
static inline void afficher_position(position v)
{
  api_afficher_position(v);
}


/// Affiche le contenu d'une valeur de type minerai
extern "C" void api_afficher_minerai(minerai v);
static inline void afficher_minerai(minerai v)
{
  api_afficher_minerai(v);
}


/// Affiche le contenu d'une valeur de type nain
extern "C" void api_afficher_nain(nain v);
static inline void afficher_nain(nain v)
{
  api_afficher_nain(v);
}


/// Affiche le contenu d'une valeur de type action_hist
extern "C" void api_afficher_action_hist(action_hist v);
static inline void afficher_action_hist(action_hist v)
{
  api_afficher_action_hist(v);
}


// Les fonctions suivantes définissent les opérations de comparaison, d'égalité
// et de hachage sur les structures du sujet.

namespace std {
  template <typename T>
  struct hash<std::vector<T>>
  {
    std::size_t operator()(const std::vector<T>& v)
    {
      std::size_t res = v.size();
      for (const auto& e : v)
        res ^= std::hash<T>()(e) + 0x9e3779b9 + (res << 6) + (res >> 2);
      return res;
    }
  };
}

inline bool operator==(const position& a, const position& b) {
  if (a.ligne != b.ligne) return false;
  if (a.colonne != b.colonne) return false;
  return true;
}

inline bool operator!=(const position& a, const position& b) {
  if (a.ligne != b.ligne) return true;
  if (a.colonne != b.colonne) return true;
  return false;
}

inline bool operator<(const position& a, const position& b) {
  if (a.ligne < b.ligne) return true;
  if (a.ligne > b.ligne) return false;
  if (a.colonne < b.colonne) return true;
  if (a.colonne > b.colonne) return false;
  return false;
}

inline bool operator>(const position& a, const position& b) {
  if (a.ligne > b.ligne) return true;
  if (a.ligne < b.ligne) return false;
  if (a.colonne > b.colonne) return true;
  if (a.colonne < b.colonne) return false;
  return false;
}

namespace std {
  template <>
  struct hash<position>
  {
    std::size_t operator()(const position& s)
    {
      std::size_t res = 0;
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.ligne);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.colonne);
      return res;
    }
  };
}

inline bool operator==(const minerai& a, const minerai& b) {
  if (a.resistance != b.resistance) return false;
  if (a.rendement != b.rendement) return false;
  return true;
}

inline bool operator!=(const minerai& a, const minerai& b) {
  if (a.resistance != b.resistance) return true;
  if (a.rendement != b.rendement) return true;
  return false;
}

inline bool operator<(const minerai& a, const minerai& b) {
  if (a.resistance < b.resistance) return true;
  if (a.resistance > b.resistance) return false;
  if (a.rendement < b.rendement) return true;
  if (a.rendement > b.rendement) return false;
  return false;
}

inline bool operator>(const minerai& a, const minerai& b) {
  if (a.resistance > b.resistance) return true;
  if (a.resistance < b.resistance) return false;
  if (a.rendement > b.rendement) return true;
  if (a.rendement < b.rendement) return false;
  return false;
}

namespace std {
  template <>
  struct hash<minerai>
  {
    std::size_t operator()(const minerai& s)
    {
      std::size_t res = 0;
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.resistance);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.rendement);
      return res;
    }
  };
}

inline bool operator==(const nain& a, const nain& b) {
  if (a.pos != b.pos) return false;
  if (a.vie != b.vie) return false;
  if (a.pa != b.pa) return false;
  if (a.pm != b.pm) return false;
  if (a.accroche != b.accroche) return false;
  if (a.butin != b.butin) return false;
  return true;
}

inline bool operator!=(const nain& a, const nain& b) {
  if (a.pos != b.pos) return true;
  if (a.vie != b.vie) return true;
  if (a.pa != b.pa) return true;
  if (a.pm != b.pm) return true;
  if (a.accroche != b.accroche) return true;
  if (a.butin != b.butin) return true;
  return false;
}

inline bool operator<(const nain& a, const nain& b) {
  if (a.pos < b.pos) return true;
  if (a.pos > b.pos) return false;
  if (a.vie < b.vie) return true;
  if (a.vie > b.vie) return false;
  if (a.pa < b.pa) return true;
  if (a.pa > b.pa) return false;
  if (a.pm < b.pm) return true;
  if (a.pm > b.pm) return false;
  if (a.accroche < b.accroche) return true;
  if (a.accroche > b.accroche) return false;
  if (a.butin < b.butin) return true;
  if (a.butin > b.butin) return false;
  return false;
}

inline bool operator>(const nain& a, const nain& b) {
  if (a.pos > b.pos) return true;
  if (a.pos < b.pos) return false;
  if (a.vie > b.vie) return true;
  if (a.vie < b.vie) return false;
  if (a.pa > b.pa) return true;
  if (a.pa < b.pa) return false;
  if (a.pm > b.pm) return true;
  if (a.pm < b.pm) return false;
  if (a.accroche > b.accroche) return true;
  if (a.accroche < b.accroche) return false;
  if (a.butin > b.butin) return true;
  if (a.butin < b.butin) return false;
  return false;
}

namespace std {
  template <>
  struct hash<nain>
  {
    std::size_t operator()(const nain& s)
    {
      std::size_t res = 0;
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<position>()(s.pos);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.vie);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.pa);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.pm);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<bool>()(s.accroche);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.butin);
      return res;
    }
  };
}

inline bool operator==(const action_hist& a, const action_hist& b) {
  if (a.atype != b.atype) return false;
  if (a.id_nain != b.id_nain) return false;
  if (a.dir != b.dir) return false;
  if (a.sens != b.sens) return false;
  return true;
}

inline bool operator!=(const action_hist& a, const action_hist& b) {
  if (a.atype != b.atype) return true;
  if (a.id_nain != b.id_nain) return true;
  if (a.dir != b.dir) return true;
  if (a.sens != b.sens) return true;
  return false;
}

inline bool operator<(const action_hist& a, const action_hist& b) {
  if (a.atype < b.atype) return true;
  if (a.atype > b.atype) return false;
  if (a.id_nain < b.id_nain) return true;
  if (a.id_nain > b.id_nain) return false;
  if (a.dir < b.dir) return true;
  if (a.dir > b.dir) return false;
  if (a.sens < b.sens) return true;
  if (a.sens > b.sens) return false;
  return false;
}

inline bool operator>(const action_hist& a, const action_hist& b) {
  if (a.atype > b.atype) return true;
  if (a.atype < b.atype) return false;
  if (a.id_nain > b.id_nain) return true;
  if (a.id_nain < b.id_nain) return false;
  if (a.dir > b.dir) return true;
  if (a.dir < b.dir) return false;
  if (a.sens > b.sens) return true;
  if (a.sens < b.sens) return false;
  return false;
}

namespace std {
  template <>
  struct hash<action_hist>
  {
    std::size_t operator()(const action_hist& s)
    {
      std::size_t res = 0;
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<action_type>()(s.atype);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<int>()(s.id_nain);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<direction>()(s.dir);
      res ^= 0x9e3779b9 + (res << 6) + (res >> 2) + std::hash<direction>()(s.sens);
      return res;
    }
  };
}


extern "C" {

/// Fonction appelée au début de la partie.
void partie_init();

/// Fonction appelée à chaque tour.
void jouer_tour();

/// Fonction appelée à la fin de la partie.
void partie_fin();

}
#endif
