#include "utility.hpp"
#include "gamestate.hpp"
#include "heuristics.hpp"

//array<array<array<int, NB_MOVES>, MAP_SIZE>, MAP_SIZE> glisseSize;

/*
	Dyns
*/

array<array<int, MAP_SIZE>, MAP_SIZE> _mv_last;
array<array<position, MAP_SIZE>, MAP_SIZE> _mv_from;
int _mv_turn = 0;

array<DeyMap, NB_AGENTS> agentPccs;

/// Fonction appelée au début de la partie.
void partie_init() {
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			VirtGameState::baseMap.map[lig][col].type = (type_case({lig, col}) == LIBRE) ? CELL_EMPTY : CELL_WALL;
		}
	}
	init_basic_algos();

	// Compute glisse sizes;
	/*for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			for (int move = 0; move < NB_MOVES; move++) {
				position p = {lig, col};
				glisseSize[lig][col][move] = -1;
				while (isCellOk(p)) {
					glisseSize[lig][col][move];
					p = p + moves[move];
				}
			}
		}
	}*/

	// Init dyns
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			_mv_last[lig][col] = -1;
		}
	}
}

/**
	Main process
**/

/*
void tryMoveAgentTo(position& agentPos, position dest, int agentId) {
	//cerr << "Try move " << agentPos.ligne << " " << agentPos.colonne
	//	<< " to " << dest.ligne << " " << dest.colonne << "\n";
	_mv_turn++;

	priority_queue<DeySit2> sits;
	sits.push(DeySit2(agentPos, 0, position{-1, -1}));
	while (!sits.empty()) {
		DeySit2 s = sits.top(); sits.pop();
		if (_mv_last[s.pos.ligne][s.pos.colonne] != _mv_turn) {
			_mv_last[s.pos.ligne][s.pos.colonne] = _mv_turn;
			_mv_from[s.pos.ligne][s.pos.colonne] = s.from;
			//cerr << "Sit " << s.pos.ligne << " " << s.pos.colonne << "\n";
			if (s.pos == dest) {
				break;
			}
			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				if (isCellOk(s.pos + moves[iMove])) {
					sits.push(DeySit2(s.pos + moves[iMove], s.time + 1, s.pos));
				}
			}
			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				position pos2 = s.pos;
				while (isCellOk(pos2 + moves[iMove])) {
					pos2 = pos2 + moves[iMove];
				}
				sits.push(DeySit2(pos2, s.time + 3, s.pos));
			}
		}
	}
	if (_mv_last[dest.ligne][dest.colonne] != _mv_turn) {
		return ;
	}
	agentPos = dest;
	vector<position> path = {dest};
	while (dest != position{-1, -1}) {
		dest = _mv_from[dest.ligne][dest.colonne];
		path.push_back(dest);
	}
	reverse(path.begin(), path.end());
	for (int iEl = 0; iEl < (int)path.size()-1; iEl++) {
		position action = path[iEl+1] - path[iEl];
		int norme = normeUn(action);
		action = {action.ligne / norme, action.colonne / norme};
		for (int iMove = 0; iMove < NB_MOVES; iMove++) {
			if (moves[iMove] == action) {
				if (norme == 1) {
					deplacer(agentId, movesNames[iMove]);
				} else {
					glisser(agentId, movesNames[iMove]);
				}
			}
		}
	}
}*/

void moveAgentToTarget(GameNewState& newState, int agentId, position dest) {
	auto& agent = newState.state.myAgents[agentId];
	agentPccs[agentId].launch(newState.state, agentId);

	if (not agentPccs[agentId].isViewed(dest)) {
		return ;
	}
	vector<position> path = {dest};
	while (dest != position{-1, -1}) {
		dest = agentPccs[agentId].from[dest.ligne][dest.colonne];
		path.push_back(dest);
	}
	reverse(path.begin(), path.end());

	for (int iEl = 0; iEl < (int)path.size()-1; iEl++) {
		position action = path[iEl+1] - path[iEl];
		int norme = normeUn(action);
		action = {action.ligne / norme, action.colonne / norme};
		for (int iMove = 0; iMove < NB_MOVES; iMove++) {
			if (moves[iMove] == action) {
				if (norme == 1) {
					if (agent.points < COUT_DEPLACEMENT) {
						return;
					}
					agent.points -= COUT_DEPLACEMENT;
					newState.applyAction({ACTION_DEPLACER, agentId, iMove});
				} else {
					if (agent.points < COUT_GLISSADE) {
						return;
					}
					agent.points -= COUT_GLISSADE;
					newState.applyAction({ACTION_GLISSER, agentId, iMove});
				}
			}
		}
	}
}

void moveToTargets(GameNewState& newState, target_array targets) {
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		moveAgentToTarget(newState, iAgent, targets[iAgent].pos);
	}
}


double maxScoreForPlayer(VirtGameState& state, int profond) {
	state.setStateNewTurn();

	if (profond == conf::MIN_MAX_PROFOND) {
		return state.evalState();
	}
	// TODO : differentes actions, appliquer sur copies de state, puis swap players, iTurn++, recursif et invertion
	vector<GameNewState> nextStates(1, GameNewState(state));
	moveToTargets(nextStates[0], MoveHeuristic_2(nextStates[0].state).getObjectives());

	if (profond == 0) {
		for (ActionHist& act : nextStates[0].actions) {
			if (act.type == ACTION_DEPLACER) {
				deplacer(act.agentId, movesNames[act.direction]);
			} else if (act.type == ACTION_GLISSER) {
				glisser(act.agentId, movesNames[act.direction]);
			} else {
				pousser(act.agentId, movesNames[act.direction]);
			}
		}
	}
	return nextStates[0].state.evalState();
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	for (auto& act : historique()) {
		if (act.atype == ACTION_POUSSER) {
			stats::nbEnemyAttacks++;
		}
	}

	VirtGameState state;
	state.setFromNow();

	maxScoreForPlayer(state, 0);

	/*array<int, NB_AGENTS> agentDest;
	array<double, NB_AGENTS> agentScore;

	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		double bestScore = -1;
		int bestAlien = -1;
		for (int iAlien = 0; iAlien < state.nbAliens; iAlien++) {
			double score = getScoreAgentToAlien(state.myAgents[iAgent].pos, state.aliens[iAlien], state.turnId);
			for (int i = 0; i < iAgent; i++) {
				if (agentDest[i] == iAlien && agentScore[i] >= score) {
					score = -0.5;
				}
			}
			//cerr << "Alien " << iAlien << " score  " << score << "\n";
			if (score > bestScore) {
				bestScore = score;
				bestAlien = iAlien;
			}
		}
		agentDest[iAgent] = bestAlien;
		agentScore[iAgent] = bestScore;
	}

	invertAgentsCells(state.enemyAgents);
	invertAgentsCells(state.myAgents);
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		position& agentPos = state.myAgents[iAgent].pos;
		invertCell(agentPos);
		if (agentDest[iAgent] != -1) {
			tryMoveAgentTo(agentPos, state.aliens[agentDest[iAgent]].pos, iAgent);
		}
		invertCell(agentPos);
	}

	invertAgentsCells(state.myAgents);
	invertAgentsCells(state.enemyAgents);*/
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {
	
}

