#include "heuristics.hpp"

void GameNewState::applyAction(ActionHist act) {
	this->state.applyAction(act);
	this->actions.push_back(act);
}
GameNewState::GameNewState(VirtGameState& s) {
	this->state = s;
}

MoveChoice::MoveChoice(VirtGameState& s) : state(s){}
target_array MoveChoice::getObjectives(){return target_array();}

position MoveChoice::getAgentSimpleDest(int iAgent) {
	// TODO
	return this->state.myAgents[iAgent].pos;
}

/**
	Heuristic 1
**/

MoveHeuristic_1::MoveHeuristic_1(VirtGameState& s) : MoveChoice(s) {}

double MoveHeuristic_1::getScoreAgentToAlien(int iAgent, alien_info alien) { // Only on aliens without enemies
	position& agentPos = this->state.myAgents[iAgent].pos;
	if (!this->state.map.canMyAgentGoTo(alien.pos, iAgent)) {
		return -INF;
	}
	if (alien.capture_en_cours == NB_TOURS_CAPTURE) {
		return -INF;
	}
	if (this->state.turnId + conf::TOUR_AVANT_IGNORE < alien.tour_invasion) {
		return 0;
	}

	int nbTurnMove = max(
		(getBaseDistTo(agentPos, alien.pos) + NB_POINTS_ACTION-1) / NB_POINTS_ACTION,
		alien.tour_invasion - this->state.turnId
	);
	int nbTurnCapture = nbTurnMove + NB_TOURS_CAPTURE - alien.capture_en_cours;

	if (alien.tour_invasion + alien.duree_invasion < nbTurnCapture) {
		return -INF;
	}
	double score = alien.points_capture * 100;
	score = score * 3. / (double)nbTurnCapture;
	score -= 0.001 * getBaseDistTo(agentPos, alien.pos);
	return score;
}

target_array MoveHeuristic_1::getObjectives() {
	array<int, NB_AGENTS> agentDest;
	array<double, NB_AGENTS> agentScore;

	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		double bestScore = -1;
		int bestAlien = -1;
		for (int iAlien = 0; iAlien < this->state.nbAliens; iAlien++) {
			double score = this->getScoreAgentToAlien(
					iAgent,
					this->state.aliens[iAlien]
				);
			for (int i = 0; i < iAgent; i++) {
				if (agentDest[i] == iAlien && agentScore[i] >= score) {
					score = -0.5;
				}
			}
			//cerr << "Alien " << iAlien << " score  " << score << "\n";
			if (score > bestScore) {
				bestScore = score;
				bestAlien = iAlien;
			}
		}
		agentDest[iAgent] = bestAlien;
		agentScore[iAgent] = bestScore;
	}
	target_array result;
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		if (agentDest[iAgent] == -1) {
			result[iAgent] = {this->getAgentSimpleDest(iAgent), TARGET_POS};
		} else {
			result[iAgent] = {this->state.aliens[agentDest[iAgent]].pos, TARGET_ALIEN};
		}
	}
	return result;
}



/**
	Heuristic 2
**/

MoveHeuristic_2::MoveHeuristic_2(VirtGameState& s) : MoveHeuristic_1(s) {}

struct AgentChoice {
	double score;
	int agentId, alienId;
};
bool operator < (const AgentChoice& a, const AgentChoice& b) {
	return a.score < b.score;
}
bool operator > (const AgentChoice& a, const AgentChoice& b) {
	return a.score > b.score;
}

target_array MoveHeuristic_2::getObjectives() {
	//cerr << "\n===== Make choices\n";
	array<int, NB_AGENTS> agentDest = {-1, -1, -1, -1};
	vector<AgentChoice> choices;

	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		for (int iAlien = 0; iAlien < this->state.nbAliens; iAlien++) {
			double score = this->getScoreAgentToAlien(
				iAgent,
				this->state.aliens[iAlien]
			);
			choices.push_back({score, iAgent, iAlien});
		}
	}
	sort(choices.begin(), choices.end(), greater<AgentChoice>());
	for (AgentChoice& choose : choices) {
		if (agentDest[choose.agentId] == -1) {
			if (find(agentDest.begin(), agentDest.end(), choose.alienId) == agentDest.end()) {
				agentDest[choose.agentId] = choose.alienId;
				/*cerr << "Agent " << this->state.myAgents[choose.agentId].pos.ligne
					<< " " << this->state.myAgents[choose.agentId].pos.colonne
					 << " go to " << this->state.aliens[choose.alienId].pos.ligne
					 << " " << this->state.aliens[choose.alienId].pos.colonne << "\n";*/
			}
		}
	}

	target_array result;
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		if (agentDest[iAgent] == -1) {
			result[iAgent] = {this->getAgentSimpleDest(iAgent), TARGET_POS};
		} else {
			result[iAgent] = {this->state.aliens[agentDest[iAgent]].pos, TARGET_ALIEN};
		}
	}
	return result;
}