#include "prologin.hh"
#include <vector>
#include <array>
#include <queue>
#include <iostream>
#include <algorithm>

/**
	Const and global vars
**/

using namespace std;

const int MAP_SIZE = TAILLE_BANQUISE;
const int INF = 1000*1000*1000;
const int NB_MOVES = 4;
const position moves[NB_MOVES] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
const direction movesNames[NB_MOVES] = {EST, SUD, OUEST, NORD};

const int TOUR_AVANT_IGNORE = 12;

array<array<bool, MAP_SIZE>, MAP_SIZE> isCellEmpty;
array<array<array<int, NB_MOVES>, MAP_SIZE>, MAP_SIZE> glisseSize;
vector<alien_info> gameAliens;
int nbAliens;

/*
	Dyns
*/

array<array<int, MAP_SIZE>, MAP_SIZE> _mv_last;
array<array<position, MAP_SIZE>, MAP_SIZE> _mv_from;
int _mv_turn = 0;

/**
	Structures
**/

struct AgentState {
	position pos;
	int points;
};
using AgentList = array<AgentState, 4>;

position operator + (const position& a, const position& b) {
	return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position operator - (const position& a, const position& b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}
position operator * (const position& a, int m) {
	return {a.ligne * m, a.colonne * m};
}

int normeUn(position pos) {
	return abs(pos.ligne) + abs(pos.colonne);
}

struct GameState_ {
	int turnId;
	AgentList myAgents;
	AgentList enemyAgents;
	vector<alien_info> aliens;

	void setFromNow();
	bool isAlienCaptured(int id);
};

struct DeySit {
	position pos;
	int time;
};
bool operator < (const DeySit& a, const DeySit& b) {
	return a.time > b.time;
}

struct DeySit2 : DeySit {
	position pos;
	int time;
	position from;
	DeySit2(position a, int b, position c) : pos(a), time(b), from(c) {}
};
bool operator < (const DeySit2& a, const DeySit2& b) {
	return a.time > b.time;
}

/**
	Stuct methods
**/

// GameState_

void GameState_::setFromNow() {
	this->turnId = tour_actuel();
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		this->myAgents[iAgent] = {position_agent(moi(), iAgent), NB_POINTS_ACTION};
		this->enemyAgents[iAgent] = {position_agent(adversaire(), iAgent), NB_POINTS_ACTION};
	}
	this->aliens = liste_aliens();
}

bool GameState_::isAlienCaptured(int iAlien) {
	return this->aliens[iAlien].capture_en_cours >= NB_TOURS_CAPTURE;
}

/**
	Utility functions
**/

int dyn_getBaseDistTo[MAP_SIZE][MAP_SIZE][MAP_SIZE][MAP_SIZE];

inline bool isPosValid(position pos) {
	return pos.ligne >= 0 && pos.colonne >= 0 && pos.ligne < MAP_SIZE && pos.colonne < MAP_SIZE;
}
inline bool isCellOk(position pos) {
	return isPosValid(pos) && isCellEmpty[pos.ligne][pos.colonne];
}

int getBaseDistTo(position depart, position arrivee) {
	int& val = dyn_getBaseDistTo[arrivee.ligne][arrivee.colonne][depart.ligne][depart.colonne];
	if (val == -1) {
		//cerr << "-------- getBaseDistTo\n";
		auto& dyn = dyn_getBaseDistTo[arrivee.ligne][arrivee.colonne];
		for (int lig = 0; lig < MAP_SIZE; lig++) {
			for (int col = 0; col < MAP_SIZE; col++) {
				dyn[lig][col] = INF;
			}
		}
		priority_queue<DeySit> sits;
		sits.push({arrivee, 0});
		while (!sits.empty()) {
			DeySit s = sits.top(); sits.pop();
			if (dyn[s.pos.ligne][s.pos.colonne] == INF) {
				//cerr << "Sit " << s.pos.ligne << " " << s.pos.colonne << " at " << s.time << "\n";
				dyn[s.pos.ligne][s.pos.colonne] = s.time;
				for (int move = 0; move < NB_MOVES; move++) {
					int cost = 0;
					position pos = s.pos;
					while (isCellOk(pos)) {
						if (cost == 0) {
							cost = 1;
						} else {
							if (dyn[pos.ligne][pos.colonne] == INF) {
								sits.push({pos, s.time+cost});
							}
							if (cost == 1) {
								position invert = s.pos + moves[(move+2)%4];
								if (isCellOk(invert)) { // pas un mur, donc pas d'arret !
									break;
								}
							}
							cost = 3;
						}
						pos = pos + moves[move];
					}
				}
			}
		}
	}
	return val;
}

/// Fonction appelée au début de la partie.
void partie_init() {
	//cerr << "========= PARTIE INIT\n";
	gameAliens = liste_aliens();
	nbAliens = gameAliens.size();
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			isCellEmpty[lig][col] = type_case({lig, col}) == LIBRE;
			//cerr << (isCellEmpty[lig][col] ? "." : "#");
		}
		//cerr << "\n";
	}
	for (int a = 0; a < MAP_SIZE; a++) {
		for (int b = 0; b < MAP_SIZE; b++) {
			for (int c = 0; c < MAP_SIZE; c++) {
				for (int d = 0; d < MAP_SIZE; d++) {
					dyn_getBaseDistTo[a][b][c][d] = -1;
				}
			}
		}
	}

	// Compute glisse sizes;
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			for (int move = 0; move < NB_MOVES; move++) {
				position p = {lig, col};
				glisseSize[lig][col][move] = -1;
				while (isCellOk(p)) {
					glisseSize[lig][col][move];
					p = p + moves[move];
				}
			}
		}
	}

	// Init dyns
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			_mv_last[lig][col] = -1;
		}
	}
}

/**
	Main process
**/

void invertCell(position pos) {
	isCellEmpty[pos.ligne][pos.colonne] = !isCellEmpty[pos.ligne][pos.colonne];
}

void invertAgentsCells(AgentList agents) {
	for (auto& agent : agents) {
		invertCell(agent.pos);
	}
}

double getScoreAgentToAlien(position agent, alien_info alien, int turnId) {
	if (!isCellOk(alien.pos)) {
		return INF;
	}
	if (turnId + TOUR_AVANT_IGNORE < alien.tour_invasion) {
		return 0;
	}
	//cerr << "getScoreAgentToAlien, dist: " << getBaseDistTo(agent, alien.pos) << "\n";
	int nbTurnMove = max(
		(getBaseDistTo(agent, alien.pos) + NB_POINTS_ACTION-1) / NB_POINTS_ACTION,
		alien.tour_invasion - turnId
	);
	int nbTurnCapture = nbTurnMove + NB_TOURS_CAPTURE - alien.capture_en_cours;
	//cerr << "tours: " << nbTurnCapture << "\n";
	if (alien.tour_invasion + alien.duree_invasion < nbTurnCapture) {
		return -INF;
	}
	double score = alien.points_capture;
	//cerr << alien.points_capture * 3. << " / " << nbTurnCapture << "\n";
	score = score * 3. / (double)nbTurnCapture;
	return score;
}


void tryMoveAgentTo(position& agentPos, position dest, int agentId) {
	//cerr << "Try move " << agentPos.ligne << " " << agentPos.colonne
	//	<< " to " << dest.ligne << " " << dest.colonne << "\n";
	_mv_turn++;

	priority_queue<DeySit2> sits;
	sits.push(DeySit2(agentPos, 0, position{-1, -1}));
	while (!sits.empty()) {
		DeySit2 s = sits.top(); sits.pop();
		if (_mv_last[s.pos.ligne][s.pos.colonne] != _mv_turn) {
			_mv_last[s.pos.ligne][s.pos.colonne] = _mv_turn;
			_mv_from[s.pos.ligne][s.pos.colonne] = s.from;
			//cerr << "Sit " << s.pos.ligne << " " << s.pos.colonne << "\n";
			if (s.pos == dest) {
				break;
			}
			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				if (isCellOk(s.pos + moves[iMove])) {
					sits.push(DeySit2(s.pos + moves[iMove], s.time + 1, s.pos));
				}
			}
			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				position pos2 = s.pos;
				while (isCellOk(pos2 + moves[iMove])) {
					pos2 = pos2 + moves[iMove];
				}
				sits.push(DeySit2(pos2, s.time + 3, s.pos));
			}
		}
	}
	if (_mv_last[dest.ligne][dest.colonne] != _mv_turn) {
		return ;
	}
	agentPos = dest;
	vector<position> path = {dest};
	while (dest != position{-1, -1}) {
		dest = _mv_from[dest.ligne][dest.colonne];
		path.push_back(dest);
	}
	reverse(path.begin(), path.end());
	for (int iEl = 0; iEl < (int)path.size()-1; iEl++) {
		position action = path[iEl+1] - path[iEl];
		int norme = normeUn(action);
		action = {action.ligne / norme, action.colonne / norme};
		for (int iMove = 0; iMove < NB_MOVES; iMove++) {
			if (moves[iMove] == action) {
				if (norme == 1) {
					deplacer(agentId, movesNames[iMove]);
				} else {
					glisser(agentId, movesNames[iMove]);
				}
			}
		}
	}
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	cerr << "++++++++++++++" << endl;
	GameState_ state;
	state.setFromNow();
	array<int, NB_AGENTS> agentDest;
	array<double, NB_AGENTS> agentScore;
	cerr << "test 1 " << endl;

	//cerr << "DIST: " << getBaseDistTo({16, 1}, {11, 5}) << "\n";
	//return ;

	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		/*cerr << "\n============== Agent " << iAgent << " pos "
			<< state.myAgents[iAgent].pos.ligne << " "
			<< state.myAgents[iAgent].pos.colonne << "\n";*/
		double bestScore = -1;
		int bestAlien = -1;
		for (int iAlien = 0; iAlien < nbAliens; iAlien++) {
			double score = getScoreAgentToAlien(state.myAgents[iAgent].pos, state.aliens[iAlien], state.turnId);
			for (int i = 0; i < iAgent; i++) {
				if (agentDest[i] == iAlien && agentScore[i] >= score) {
					score = -0.5;
				}
			}
			//cerr << "Alien " << iAlien << " score  " << score << "\n";
			if (score > bestScore) {
				bestScore = score;
				bestAlien = iAlien;
			}
		}
		agentDest[iAgent] = bestAlien;
		agentScore[iAgent] = bestScore;
	}

	invertAgentsCells(state.enemyAgents);
	invertAgentsCells(state.myAgents);
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		position& agentPos = state.myAgents[iAgent].pos;
		invertCell(agentPos);
		if (agentDest[iAgent] != -1) {
			tryMoveAgentTo(agentPos, gameAliens[agentDest[iAgent]].pos, iAgent);
		}
		invertCell(agentPos);
	}

	invertAgentsCells(state.myAgents);
	invertAgentsCells(state.enemyAgents);
	cerr << "test fin " << endl;
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {
	
}

