#ifndef BASICS_ALGOS_HPP
#define BASICS_ALGOS_HPP

#include "gamestate.hpp"

struct DeyMap {
	array<array<int, MAP_SIZE>, MAP_SIZE> minTime;
	array<array<position, MAP_SIZE>, MAP_SIZE> from;
	array<array<action_type, MAP_SIZE>, MAP_SIZE> actionFrom;

	void reset();
	bool isViewed(position pos);
	void launch(VirtGameState& newState, int agentId);
	int getTimeTo(position pos);

private:
	bool setBetter(position pos, int time, position from, action_type actionFrom);
};

void init_basic_algos();
int getBaseDistTo(position depart, position arrivee);

#endif