import json, copy, pprint, os

valuesBornes = {
	'eval_coeff_positions': (0, 200, float),
	'eval_perte_time': (0, 1, float),
	'base_enemy_agro_coeff': (0, 1, float),
	'malus_action_wait_per_turn': (0, 1, float),
	'coeffHardDefense': (0, 1, float),
	'coeffSoftDefense': (0, 1, float),
	'coeffAttackBonus': (0, 1, float),
}

def printValues(values):
	f = open('champions/tee-tan/consts.hpp', 'w')
	for name in values:
		f.write('double' if valuesBornes[name][2] == float else 'int')
		f.write(' conf::' + name + ' = ' + str(values[name]) + ';\n')

def generateBaseSet():
	keys = list(valuesBornes.keys());
	def generateVals(i):
		if len(keys) == i:
			return [{}]
		else:
			vs = generateVals(i+1)
			r = []
			for v in vs:
				r.append({**v, keys[i]: valuesBornes[keys[i]][0]})
				r.append({**v, keys[i]: valuesBornes[keys[i]][1]})
				r.append({**v, keys[i]: (valuesBornes[keys[i]][0] + valuesBornes[keys[i]][1]) / 2})
			return r
	return generateVals(0)

setValues = generateBaseSet()

def compile(values, name):
	printValues(values)
	os.system('make -C champions/tee-tan')
	os.system('cp champions/tee-tan/champion.so champions/genetic/' + str(name) + '.so')

compile(setValues[0], 1)