#include "utility.hpp"
#include "gamestate.hpp"
#include "heuristics.hpp"

const int FLAG_AGRO = 1;

double maxScoreForPlayer(VirtGameState& state, int profond, int flags);

/*
	Dyns
*/

array<DeyMap, NB_AGENTS> agentPccs;

/// Fonction appelée au début de la partie.
void partie_init() {
	srand(42);
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			VirtGameState::baseMap.map[lig][col].type = (type_case({lig, col}) == LIBRE) ? CELL_EMPTY : CELL_WALL;
		}
	}
	init_basic_algos();
}

/**
	Main process
**/

void moveAgentToTarget(GameNewState& newState, int agentId, position dest) {
	auto& agent = newState.state.myAgents[agentId];
	agentPccs[agentId].launch(newState.state, agentId);

	if (not agentPccs[agentId].isViewed(dest)) {
		return ;
	}
	vector<position> path = {dest};
	while (dest != position{-1, -1}) {
		dest = agentPccs[agentId].from[dest.ligne][dest.colonne];
		path.push_back(dest);
	}
	reverse(path.begin(), path.end());

	for (int iEl = 0; iEl < (int)path.size()-1; iEl++) {
		position action = path[iEl+1] - path[iEl];
		int norme = normeUn(action);
		action = {action.ligne / norme, action.colonne / norme};
		for (int iMove = 0; iMove < NB_MOVES; iMove++) {
			if (moves[iMove] == action) {
				if (norme == 1) {
					if (agent.points < COUT_DEPLACEMENT) {
						return;
					}
					agent.points -= COUT_DEPLACEMENT;
					newState.applyAction({ACTION_DEPLACER, agentId, iMove});
				} else {
					if (agent.points < COUT_GLISSADE) {
						return;
					}
					agent.points -= COUT_GLISSADE;
					newState.applyAction({ACTION_GLISSER, agentId, iMove});
				}
			}
		}
	}
}

void moveToTargets(GameNewState& newState, target_array targets) {
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		moveAgentToTarget(newState, iAgent, targets[iAgent].pos);
	}
}

double getScoreOf(GameNewState& newState, int profond, int flags = 0) {
	newState.state.swapPlayers();
	newState.state.turnId++;
	return -1 * maxScoreForPlayer(newState.state, profond+1, flags);
}

double maxScoreForPlayer(VirtGameState& state, int profond, int flags = 0) {
	state.setStateNewTurn();

	if (profond == conf::MIN_MAX_PROFOND) {
		return state.evalState();
	}

	vector<GameNewState> nextStates(3, GameNewState(state));
	vector<double> nextScores(nextStates.size());

	moveToTargets(nextStates[0], MoveHeuristic_1(nextStates[0].state).getObjectives());
	nextScores[0] = getScoreOf(nextStates[0], profond);

	if (!(flags & FLAG_AGRO)) {
		moveToTargets(nextStates[1], MoveHeuristic_2(nextStates[1].state).getObjectives());
		nextScores[1] = getScoreOf(nextStates[1], profond);

		if (nextScores[1] > nextScores[0]) {
			swap(nextStates[0], nextStates[1]);
		}
	}
	

	if (profond == 0) {
		for (ActionHist& act : nextStates[0].actions) {
			if (act.type == ACTION_DEPLACER) {
				deplacer(act.agentId, movesNames[act.direction]);
			} else if (act.type == ACTION_GLISSER) {
				glisser(act.agentId, movesNames[act.direction]);
			} else {
				pousser(act.agentId, movesNames[act.direction]);
			}
		}
	}
	return nextStates[0].state.evalState();
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	startChrono();
	for (auto& act : historique()) {
		if (act.atype == ACTION_POUSSER) {
			stats::nbEnemyAttacks++;
		}
	}

	VirtGameState state;
	state.setFromNow();

	maxScoreForPlayer(state, 0);

	cerr << "=== TIME: " << getChrono() << " ms \n";
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {
	
}

