#ifndef GAMESTATE_HPP
#define GAMESTATE_HPP

#include "utility.hpp"

const int CELL_WALL = 0;
const int CELL_EMPTY = 1;
const int CELL_AGENT_MINE = 2;
const int CELL_AGENT_ENEMY = 3;

const int MOVE_BASE = 0;
const int MOVE_GLISSE = 1;

struct CellType {
	int type, agentId;
};

struct GameMap {
	array<array<CellType, MAP_SIZE>, MAP_SIZE> map;

	bool isValid(position pos);
	bool isEmpty(position pos);
	bool canMyAgentGoTo(position pos, int agentId);
	int tryGetEnemyAt(position pos);
	CellType& get(position pos);
};

struct Transition {
	int type, iMove, destination;
};

struct ActionHist {
	action_type type;
	int agentId, direction;
};

struct VirtGameState {
	static GameMap baseMap;

	int turnId;
	int myScore, hisScore;
	AgentList myAgents;
	AgentList enemyAgents;
	GameMap map;

	vector<alien_info> aliens;
	int nbAliens;

	void setFromNow();
	void setStateNewTurn();
	bool isAlienCaptured(int id);

	void moveAgentTo(AgentState& agent, position destination);
	void applyAction(ActionHist);

	double evalState();
};

/**
	Usefull functions	
**/

position ApplyMoveTo(position pos, int type, int direction, VirtGameState& state);
bool isCellOk(position pos);

#endif