#include "utility.hpp"

using namespace std;

/**
	Config
**/
int conf::TOUR_AVANT_IGNORE = 12;
int conf::MIN_MAX_PROFOND = 1;

int conf::MAX_ON_ATTACK = 2;

double conf::eval_coeff_points = 100.;
//#include "consts.hpp"

double conf::eval_coeff_positions = 100.;
double conf::eval_perte_time = 0.25;
double conf::base_enemy_agro_coeff = 0.2;
double conf::malus_action_wait_per_turn = 0.1;

double conf::coeffHardDefense = 0;
double conf::coeffSoftDefense = 0.1;
double conf::coeffAttackBonus = 1.05;

double conf::coeffProtect = 0;

int stats::nbEnemyAttacks = 0;
int stats::realTurn = 0;

double stats::getEnemyAgroCoef() {
	if (realTurn < 4) {
		return conf::base_enemy_agro_coeff;
	}
	return (double)nbEnemyAttacks / (double)(stats::realTurn * 4);
}

/**
	Simple functions
**/

int normeUn(position pos) {
	return abs(pos.ligne) + abs(pos.colonne);
}

std::chrono::time_point<std::chrono::system_clock> chrono_start, chrono_end;
void startChrono() {
	chrono_start = std::chrono::system_clock::now();
}
double getChrono() {
	chrono_end = std::chrono::system_clock::now();
	std::chrono::duration<double> d = chrono_end - chrono_start;
	return d.count();
}

/**
	Operators
**/

position operator + (const position& a, const position& b) {
	return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position operator - (const position& a, const position& b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}
position operator * (const position& a, int m) {
	return {a.ligne * m, a.colonne * m};
}

bool operator < (const DeySit& a, const DeySit& b) {
	return a.time > b.time;
}

