#include "utility.hpp"
#include "gamestate.hpp"
#include "heuristics.hpp"

const int FLAG_AGRO = 1;

double maxScoreForPlayer(VirtGameState& state, int profond, int flags);

/*
	Dyns
*/

array<DeyMap, NB_AGENTS> agentPccs;

/// Fonction appelée au début de la partie.
void partie_init() {
	srand(42);
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		for (int col = 0; col < MAP_SIZE; col++) {
			VirtGameState::baseMap.map[lig][col].type = (type_case({lig, col}) == LIBRE) ? CELL_EMPTY : CELL_WALL;
		}
	}
	init_basic_algos();
}

/**
	Main process
**/

void moveAgentToTarget(GameNewState& newState, int agentId, position dest, int move_target) {
	auto& agent = newState.state.myAgents[agentId];
	agentPccs[agentId].launch(newState.state, agentId);

	if (move_target == TARGET_ATTACK) {
		int bestDist = INF; position bestPos = dest;
		for (int iMove = 0; iMove < 4; iMove++) {
			position pos2 = dest + moves[iMove];
			if (newState.state.map.canMyAgentGoTo(pos2, agentId) && agentPccs[agentId].getTimeTo(pos2) < bestDist
				&& newState.state.map.isEmpty(dest - moves[iMove])) {
				bestDist = agentPccs[agentId].getTimeTo(pos2);
				bestPos = pos2;
			}
		}
		if (bestDist == INF) {
			for (int iMove = 0; iMove < 4; iMove++) {
				position pos2 = dest + moves[iMove] + moves[(iMove+1)%4];
				if (newState.state.map.isWall(dest + moves[iMove])
					&& newState.state.map.isWall(dest + moves[(iMove+1)%4])) {
					continue;
				}
				if (newState.state.map.canMyAgentGoTo(pos2, agentId) && agentPccs[agentId].getTimeTo(pos2) < bestDist
					&& (newState.state.map.isEmpty(pos2 - moves[iMove]*2)
						|| newState.state.map.isEmpty(pos2 - moves[(iMove+1)%4]*2))) {
					bestDist = agentPccs[agentId].getTimeTo(pos2);
					bestPos = pos2;
				}
			}
		}
		dest = bestPos;
		//cerr << "TARGET_ATTACK ; move to " << dest.ligne << " " << dest.colonne << "\n";
		if (bestDist == INF) {
			//cerr << "No way to attack\n";
			return;
		}
	}
	if (move_target == TARGET_PROTECT) {
		dest = defendGetPosition(dest, newState.state, agent.pos);
	}

	if (dest.ligne == -1 ||not agentPccs[agentId].isViewed(dest)) {
		return ;
	}
	vector<position> path = {dest};
	position path_pos = dest;
	while (path_pos != position{-1, -1}) {
		path_pos = agentPccs[agentId].from[path_pos.ligne][path_pos.colonne];
		path.push_back(path_pos);
	}
	reverse(path.begin(), path.end());

	for (int iEl = 0; iEl < (int)path.size()-1; iEl++) {
		position action = path[iEl+1] - path[iEl];
		int norme = normeUn(action);
		action = {action.ligne / norme, action.colonne / norme};
		for (int iMove = 0; iMove < NB_MOVES; iMove++) {
			if (moves[iMove] == action) {
				if (norme == 1) {
					if (agent.points < COUT_DEPLACEMENT) {
						return;
					}
					// << "Move from " << path[iEl].ligne << " " << path[iEl].colonne << " direction " << iMove 
					//	<< " to " << path[iEl+1].ligne << " " << path[iEl+1].colonne << "\n";
					agent.points -= COUT_DEPLACEMENT;
					newState.applyAction({ACTION_DEPLACER, agentId, iMove});
				} else {
					if (agent.points < COUT_GLISSADE) {
						return;
					}
					agent.points -= COUT_GLISSADE;
					newState.applyAction({ACTION_GLISSER, agentId, iMove});
				}
			}
		}
	}
	if (agent.points >= COUT_POUSSER) { 
		for (int iMove = 0; iMove < 4; iMove++) {
			if (newState.state.map.isEnemy(dest + moves[iMove]) && alien_sur_case(dest + moves[iMove])) {
				newState.applyAction({ACTION_POUSSER, agentId, iMove});
				return;
			}
		}
		for (int iMove = 0; iMove <  4; iMove++) {
			if (newState.state.map.isEnemy(dest + moves[iMove])) {
				newState.applyAction({ACTION_POUSSER, agentId, iMove});
				return;
			}
		}
	}
}

void moveToTargets(GameNewState& newState, target_array targets) {
	for (int iAgent = 0; iAgent < NB_AGENTS; iAgent++) {
		moveAgentToTarget(newState, iAgent, targets[iAgent].pos, targets[iAgent].type);
	}
}

double getScoreOf(GameNewState& newState, int profond, int flags = 0) {
	newState.state.swapPlayers();
	newState.state.turnId++;
	return -1 * maxScoreForPlayer(newState.state, profond+1, flags);
}

double maxScoreForPlayer(VirtGameState& state, int profond, int flags = 0) {
	state.setStateNewTurn();

	if (profond == conf::MIN_MAX_PROFOND) {
		return state.evalState();
	}

	vector<GameNewState> nextStates(3, GameNewState(state));
	vector<double> nextScores(nextStates.size());

	int bestAct = 0;

	// Heuristique simple

	moveToTargets(nextStates[0], MoveHeuristic_Agro(nextStates[0].state).getObjectives());
	moveToTargets(nextStates[0], MoveHeuristic_Agro(nextStates[0].state).getObjectives());
	nextScores[0] = getScoreOf(nextStates[0], profond);

	// Heuristique semi-random

	/*moveToTargets(nextStates[1], MoveHeuristic_2(nextStates[1].state).getObjectives());
	nextScores[1] = getScoreOf(nextStates[1], profond);

	if (nextScores[1] > nextScores[bestAct]) {
		bestAct = 1;
	}*/

	// Heuristique aggro

	/*moveToTargets(nextStates[2], MoveHeuristic_1(nextStates[2].state).getObjectives());
	nextScores[2] = getScoreOf(nextStates[2], profond);

	if (nextScores[2] > nextScores[bestAct]) {
		if (profond == 0) {
			cerr << "CHOOSE AGRO\n";
		}
		bestAct = 2;
	}*/

	if (profond == 0) {
		for (ActionHist& act : nextStates[bestAct].actions) {
			if (act.type == ACTION_DEPLACER) {
				deplacer(act.agentId, movesNames[act.direction]);
			} else if (act.type == ACTION_GLISSER) {
				glisser(act.agentId, movesNames[act.direction]);
			} else {
				//cerr << state.myAgents[act.agentId].pos.ligne << state.myAgents[act.agentId].pos.colonne
				//	<< " POUSSER " << movesNames[act.direction] << "\n";
				pousser(act.agentId, movesNames[act.direction]);
			}
		}
	}
	return nextStates[0].state.evalState();
}

/// Fonction appelée à chaque tour.
void jouer_tour() {
	startChrono();
	stats::realTurn = tour_actuel();

	for (auto& act : historique()) {
		if (act.atype == ACTION_POUSSER) {
			stats::nbEnemyAttacks++;
		}
	}

	VirtGameState state;
	state.setFromNow();

	maxScoreForPlayer(state, 0);

	cerr << "=== TIME: " << getChrono() << " ms \n";
}

/// Fonction appelée à la fin de la partie.
void partie_fin() {
	
}

