#ifndef UTILITY_HPP
#define UTILITY_HPP

#include "prologin.hh"
#include <vector>
#include <array>
#include <queue>
#include <iostream>
#include <algorithm>
#include <cstdlib>
#include <chrono>

using namespace std;

/**
	Const and global vars
**/

const int MAP_SIZE = TAILLE_BANQUISE;
const int INF = 1000*1000*1000;
const int NB_MOVES = 4;
const position moves[NB_MOVES] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
const direction movesNames[NB_MOVES] = {EST, SUD, OUEST, NORD};

struct conf {
	static int TOUR_AVANT_IGNORE;
	static int MIN_MAX_PROFOND;

	static int MAX_ON_ATTACK;

	static double eval_coeff_points;
	static double eval_coeff_positions;
	static double eval_perte_time;
	static double base_enemy_agro_coeff;

	static double coeffHardDefense;
	static double coeffSoftDefense;
	static double coeffAttackBonus;
};

struct stats {
	static int nbEnemyAttacks;
	static int realTurn;

	double getEnemyAgroCoef();
};

/**
	Structures and types
**/

struct AgentState {
	position pos;
	int points;
};
using AgentList = array<AgentState, 4>;



struct DeySit {
	position pos;
	int time;
};

/**
	Simple functions
**/

int normeUn(position pos);
void startChrono();
double getChrono();

/**
	Operators
**/

position operator + (const position& a, const position& b);
position operator - (const position& a, const position& b);
position operator * (const position& a, int m);

bool operator < (const DeySit& a, const DeySit& b);

#endif