#include "basicAlgos.hpp"

//array<array<int, MAP_SIZE>, MAP_SIZE> minTime;
//array<array<int, MAP_SIZE>, MAP_SIZE> from;
//array<array<int, MAP_SIZE>, MAP_SIZE> actionFrom;

void DeyMap::reset() {
	for (int lig = 0; lig < MAP_SIZE; lig++) {
		fill(minTime[lig].begin(), minTime[lig].end(), INF);
	}
}

bool DeyMap::isViewed(position pos) {
	return this->minTime[pos.ligne][pos.colonne] != INF;
}

bool DeyMap::setBetter(position pos, int time, position fromPos, action_type action) {
	if (this->minTime[pos.ligne][pos.colonne] > time) {
		this->minTime[pos.ligne][pos.colonne] = time;
		this->from[pos.ligne][pos.colonne] = fromPos;
		this->actionFrom[pos.ligne][pos.colonne] = action;
		return true;
	}
	return false;
}

int DeyMap::getTimeTo(position pos) {
	if (VirtGameState::baseMap.isValid(pos)) {
		return this->minTime[pos.ligne][pos.colonne];
	}
	return INF;
}

void DeyMap::launch(VirtGameState& state, int agentId) {
	this->reset();
	auto& agent = state.myAgents[agentId];

	priority_queue<DeySit> sits;
	setBetter(agent.pos, 0, {-1, -1}, ACTION_DEPLACER);
	sits.push({agent.pos, 0});

	while (!sits.empty()) {
		DeySit s = sits.top(); sits.pop();
		if (this->minTime[s.pos.ligne][s.pos.colonne] == s.time) {
			//cerr << "Sit " << s.pos.ligne << " " << s.pos.colonne << "\n";

			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				if (state.map.canMyAgentGoTo(s.pos + moves[iMove], agentId)) {
					if (this->setBetter(s.pos + moves[iMove], s.time+1, s.pos, ACTION_DEPLACER)) {
						sits.push({s.pos + moves[iMove], s.time + 1});
					}
				}
			}
			for (int iMove = 0; iMove < NB_MOVES; iMove++) {
				position pos2 = s.pos;
				while (state.map.canMyAgentGoTo(pos2 + moves[iMove], agentId)) {
					pos2 = pos2 + moves[iMove];
				}
				if (this->setBetter(pos2, s.time+3, s.pos, ACTION_GLISSER)) {
					sits.push({pos2, s.time + 3});
				}
			}
		}
	}
}


/**
	Simple dynamic
**/

int dyn_getBaseDistTo[MAP_SIZE][MAP_SIZE][MAP_SIZE][MAP_SIZE];

void init_basic_algos() {
	for (int a = 0; a < MAP_SIZE; a++) {
		for (int b = 0; b < MAP_SIZE; b++) {
			for (int c = 0; c < MAP_SIZE; c++) {
				for (int d = 0; d < MAP_SIZE; d++) {
					dyn_getBaseDistTo[a][b][c][d] = -1;
				}
			}
		}
	}
}

int getBaseDistTo(position depart, position arrivee) {
	int& val = dyn_getBaseDistTo[arrivee.ligne][arrivee.colonne][depart.ligne][depart.colonne];
	if (val == -1) {
		//cerr << "-------- getBaseDistTo\n";
		auto& dyn = dyn_getBaseDistTo[arrivee.ligne][arrivee.colonne];
		for (int lig = 0; lig < MAP_SIZE; lig++) {
			for (int col = 0; col < MAP_SIZE; col++) {
				dyn[lig][col] = INF;
			}
		}
		priority_queue<DeySit> sits;
		sits.push({arrivee, 0});
		while (!sits.empty()) {
			DeySit s = sits.top(); sits.pop();
			if (dyn[s.pos.ligne][s.pos.colonne] == INF) {
				//cerr << "Sit " << s.pos.ligne << " " << s.pos.colonne << " at " << s.time << "\n";
				dyn[s.pos.ligne][s.pos.colonne] = s.time;
				for (int move = 0; move < NB_MOVES; move++) {
					int cost = 0;
					position pos = s.pos;
					while (isCellOk(pos)) {
						if (cost == 0) {
							cost = 1;
						} else {
							if (dyn[pos.ligne][pos.colonne] == INF) {
								sits.push({pos, s.time+cost});
							}
							if (cost == 1) {
								position invert = s.pos + moves[(move+2)%4];
								if (isCellOk(invert)) { // pas un mur, donc pas d'arret !
									break;
								}
							}
							cost = 3;
						}
						pos = pos + moves[move];
					}
				}
			}
		}
	}
	return val;
}