#ifndef HEURISTICS_HPP
#define HEURISTICS_HPP

#include "basicAlgos.hpp"

/**
	Game actions structs
**/

struct GameNewState {
	VirtGameState state;
	vector<ActionHist> actions;

	void applyAction(ActionHist);
	GameNewState(VirtGameState&);
};

const int TARGET_ALIEN = 0;
const int TARGET_PROTECT = 1;
const int TARGET_ATTACK = 2;
const int TARGET_POS = 3;

struct Target {
	position pos;
	int type;
};

using target_array = array<Target, NB_AGENTS>;

/**
	Heuristics
**/

// Base
class MoveChoice {
public:
	target_array getObjectives();
	position getAgentSimpleDest(int);
	MoveChoice(VirtGameState&);

protected:
	VirtGameState& state;
};

// Heuristic 1
class MoveHeuristic_1 : public MoveChoice {
public:
	target_array getObjectives();
	MoveHeuristic_1(VirtGameState&);

protected:
	double getScoreAgentToAlien(int iAgent, alien_info);
};

// Heuristic 2
class MoveHeuristic_2 : public MoveHeuristic_1 {
public:
	target_array getObjectives();
	MoveHeuristic_2(VirtGameState&);
};

#endif