#include "global.h"

/*
	FONCTIONS D'EVALUATION
*/

bool must_destroyBecauseQuadrillage() {
	int nbAlone = 0;
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isBlocADanger({lig, col}, true)) {
				nbAlone++;
			}
		}
	}
	return nbAlone >= SEUIL_ALONES_DESTRUCTION;
}

int countAndDeleteZone(Pos p, Grid& grid) {
	int type = grid[p.lig][p.col];
	grid[p.lig][p.col] = VIDE;
	int n = 1;
	
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && grid[nextP.lig][nextP.col] == type) {
			n += countAndDeleteZone(nextP, grid);
		}
	}
	return n;
}

int getAreaMaxAround(Pos p) {
	int aireMax = 0;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos p2 = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(p2) && gridMe[p2.lig][p2.col] == VIDE) {
			aireMax = std::max(aireMax, sizeZonesMe[p2.lig][p2.col]);
		}
	}
	return aireMax;
}

int getScoreCotesVides(Pos p) {
	int nbCotesVides = 0;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos p2 = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(p2) && gridMe[p2.lig][p2.col] == VIDE) {
			nbCotesVides++;
			for (int iDalle2 = 0; iDalle2 < 4; iDalle2++) {
				if (moves[iDalle2][0] == -moves[iMove][0] && moves[iDalle2][1] == - moves[iMove][1]) {
					continue;
				}
				Pos dalle2 = {p2.lig + moves[iDalle2][0], p2.col + moves[iDalle2][1]};
				if (isPosValid(dalle2) && gridMe[dalle2.lig][dalle2.col] == VIDE) {
					nbCotesVides += 100;
				}
			}
		}
	}
	return nbCotesVides;
}

int evalGrid_pour_catalyse(Grid grid) {
	int value = 0;
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (grid[lig][col] != VIDE) {
				case_type type = grid[lig][col];
				int size = countAndDeleteZone({lig, col}, grid);
				if (isMetal(type)) {
					value += scoreTransmutOrMetal(size);
				} else {
					value += scoreTransmutOrImpur(size);
				}
			}
		}
	}
	return value;
}
