#include "global.h"
/*
	GLOBAL VARIABLES
*/

int PRET_METAL = 8;

int idMe, idOther;
Grid gridMe;
Grid gridOther;
echantillon pairTour;
int nbCasesFullMe;

bool IS_DENSITE_HAUT = false, IS_DENSITE_CRITIQUE = false;

int moves[4][2] = {{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

std::vector<int> nbTypesInGridMe(6, 0);
std::vector<int> nbTypesInGridOther(6, 0);

int sizeZonesMe[SGRID][SGRID];
int sizeZonesOther[SGRID][SGRID];

/*
	MAIN FONCTIONS
*/

void donnerPairSuivante() {
	auto pairNext = echantillon_tour();
	if (nbTypesInGridOther[pairNext.element1] > nbTypesInGridOther[pairNext.element2]) {
		std::swap(pairNext.element1, pairNext.element2);
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = SOUFRE;
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = MERCURE;
	}
	for (int i = 1; i <= 5; i++) {
		if (TYPES_TAB[i] != pairNext.element1 && nbTypesInGridOther[pairNext.element2] >= nbTypesInGridOther[i]) {
			pairNext.element2 = TYPES_TAB[i];
		}
	}
	donner_echantillon(pairNext);
}

/*void donnerPairSuivante2() {
	auto pairNext = echantillon_tour();
	if ((isMetal(pairNext.element1) && isImpur(pairNext.element2))
		|| (isMetal(pairNext.element1) == isMetal(pairNext.element2)
			&& nbTypesInGridOther[pairNext.element1] > nbTypesInGridOther[pairNext.element2])) {
		std::swap(pairNext.element1, pairNext.element2);
	}
	pairNext.element2 = MERCURE;
	if (nbTypesInGridOther[SOUFRE] < nbTypesInGridOther[MERCURE]) {
		pairNext.element2 = SOUFRE;
	}
	if (pairNext.element1 == SOUFRE) {
		pairNext.element2 = MERCURE;
	} else if (pairNext.element1 == MERCURE) {
		pairNext.element2 = SOUFRE;
	}
	donner_echantillon(pairNext);
}*/

/// Fonction appelée au début de la partie.
void partie_init()
{
	std::ios_base::sync_with_stdio(false);
	idMe = moi();
	idOther = (idMe == 1) ? 2 : 1;
	//std::cerr << "MyId = " << idMe << "\n";
	
	gridMe = Grid(SGRID, std::vector<case_type>(SGRID, VIDE));
	gridOther = gridMe;
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	/*if (tour_actuel() > 23) {
		return;
	}*/
	std::cerr << "=============================================================\njouer debut " << idMe << "  tour " << tour_actuel() << "\n";
	//std::flush(std::cerr);
	init_grids();
	afficher_etablis();

	pairTour = echantillon_tour();
	
	if (must_destroyBecauseQuadrillage()) {
		std::cerr << "QUADRILLE\n";
		destroyBecauseQuadrillage();
	}
	
	//std::cerr << pairTour.element1 << ": " << nbTypesInGridMe[pairTour.element1] << "\n";
	//std::cerr << pairTour.element2 << ": " << nbTypesInGridMe[pairTour.element2] << "\n";
	
	placeWithConstraints();
	init_grids();
	
	if (IS_DENSITE_HAUT) {
		transmuteImpurs(IS_DENSITE_CRITIQUE ? PRET_IMPUR/2 : PRET_IMPUR);
	}
	catalyser();
	if (IS_DENSITE_HAUT) {
		transmuteMetaux(IS_DENSITE_CRITIQUE ? PRET_METAL_CRITIQUE : PRET_METAL);
	}
	
	if (tour_actuel() >= NB_TOURS-1) {
		detructAllCases();
	} else {
		donnerPairSuivante();
	}
	
	afficher_etablis();
	//std::cerr << "jouer fin du tour " << tour_actuel() << "\n";
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
	// fonction a completer
  
	if (tour_actuel() >= NB_TOURS-1) {
		donnerPairSuivante();
	}
}

