#include "global.h"

/*
	FONCTIONS DE DESTRUCTION
*/
bool fairePlaceWithoutConstraints() {
	// essayer une grande zone impure
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 3) {
				transmuter({lig, col});
				init_grids();
				return true;
			}
		}
	}
	
	// essayer zone de metal max si au dessus du seuil
	position pMin = {-1, -1};
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isMetal(gridMe[lig][col]) && sizeZonesMe[lig][col] >= PRET_METAL_BAS) {
				if (pMin.col == -1 || sizeZonesMe[lig][col] > sizeZonesMe[pMin.lig][pMin.col]) {
					pMin = {lig, col};
				}
			}
		}
	}
	if (pMin.lig != -1) {
		transmuter(pMin);
		init_grids();
		return true;
	}
	
	// essayer zone de metal petite, mais pas trop
	pMin = {-1, -1};
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isMetal(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 3) {
				if (pMin.col == -1 || sizeZonesMe[lig][col] < sizeZonesMe[pMin.lig][pMin.col]) {
					pMin = {lig, col};
				}
			}
		}
	}
	if (pMin.lig != -1) {
		transmuter(pMin);
		init_grids();
		return true;
	}
	
	// essayer une petite zone impure non-nulle
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 1) {
				transmuter({lig, col});
				init_grids();
				return true;
			}
		}
	}
	
	// n'importe quoi d'autre, sans -3
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] != VIDE && sizeZonesMe[lig][col] >= 2) {
				transmuter({lig, col});
				init_grids();
				return true;
			}
		}
	}
	return false;
}

void transmuteImpurs(int seuil) {
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= seuil) {
				transmuter({lig, col});
				init_grids();
			}
		}
	}
}

void catalyser() {
	// si densitee critique, bloc seul
	if (IS_DENSITE_CRITIQUE) {
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, false)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, true)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
	}

	while (nombre_catalyseurs() > 0) {
		//tenter d'etre a cote du plus gros bloc
		
		int evalMeBase = evalGrid_pour_catalyse(gridMe);
		int evalOtherBase = evalGrid_pour_catalyse(gridOther);
		
		int bestDifference = 0;
		Pos bestPos = {-1, -1};
		bool inMyGrid = true;
		case_type typeChange = VIDE;
		
		// Catalyse on my grid
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID; col++) {
				if (!isImpur(gridMe[lig][col])) {
					continue;
				}
				for (int type = 1; type <= 5; type++) {
					case_type typeBase = gridMe[lig][col];
					gridMe[lig][col] = TYPES_TAB[type];
					int score = evalGrid_pour_catalyse(gridMe);
					gridMe[lig][col] = typeBase;
					
					if (bestDifference < (score - evalMeBase)) {
						bestDifference = (score - evalMeBase);
						bestPos = {lig, col};
						inMyGrid = true;
						typeChange = TYPES_TAB[type];
					}
				}
			}
		}
		
		// Catalyse on the other grid
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID; col++) {
				if (!isMetal(gridOther[lig][col])) {
					continue;
				}
				for (int type = 1; type <= 5; type++) {
					case_type typeBase = gridOther[lig][col];
					gridOther[lig][col] = TYPES_TAB[type];
					int score = evalGrid_pour_catalyse(gridOther);
					gridOther[lig][col] = typeBase;
					
					if (bestDifference < (evalOtherBase - score) ||
						(bestDifference == (evalOtherBase - score) && !inMyGrid  &&
						(nbTypesInGridOther[typeChange] > nbTypesInGridOther[type] ||
							(isMetal(typeChange) && isImpur(TYPES_TAB[type]))))) {
						bestDifference = (evalOtherBase - score);
						bestPos = {lig, col};
						inMyGrid = false;
						typeChange = TYPES_TAB[type];
					}
				}
			}
		}
		
		if (bestDifference > 0) {
			if (inMyGrid) {
				catalyser(bestPos, idMe, typeChange);
			} else {
				catalyser(bestPos, idOther, typeChange);
			}
			init_grids();
		} else { // placer un metal
			Pos minPos = {-1, -1};
			int sizeMin = -1;
			for (int lig = 0; lig < SGRID; lig++) {
				for (int col = 0; col < SGRID; col++) {
					if (isImpur(gridMe[lig][col]) && (sizeMin == -1 || sizeZonesMe[lig][col] < sizeMin)) {
						sizeMin = sizeZonesMe[lig][col];
						minPos = {lig, col};
					}
				}
			}
			if (minPos.lig == -1) {
				break;
			} else {
				case_type metal = CUIVRE;
				if (nbTypesInGridMe[FER] > nbTypesInGridMe[metal]) {
					metal = FER;
				}
				if (nbTypesInGridMe[PLOMB] > nbTypesInGridMe[metal]) {
					metal = PLOMB;
				}
				catalyser(minPos, idMe, metal);
			}
		}
	}
}

void catalyser_old() {
	// si densitee critique, bloc seul
	if (IS_DENSITE_CRITIQUE) {
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, false)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, true)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
	}

	while (nombre_catalyseurs() > 0) {
		//tenter d'etre a cote du plus gros bloc
		std::vector<Pos> positionsSizes[37];
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID; col++) {
				if (isMetal(gridMe[lig][col])) {
					positionsSizes[sizeZonesMe[lig][col]].push_back({lig, col});
				}
			}
		}
		bool avoirCatalyse = false;
		for (int size = 36; size > 0 && !avoirCatalyse; size--) {
			if (!positionsSizes[size].empty()) {
				//std::random_shuffle(positionsSizes[size].begin(), positionsSizes[size].end());
				for (Pos p : positionsSizes[size]) {
					for (int iMove = 0; iMove < 4 && !avoirCatalyse; iMove++) {
						Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
						if (isPosValid(nextP) && gridMe[nextP.lig][nextP.col] != VIDE && (isImpur(gridMe[nextP.lig][nextP.col]) || sizeZonesMe[nextP.lig][nextP.col] < sizeZonesMe[p.lig][p.col])) {
							avoirCatalyse = true;
							catalyser(nextP, idMe, gridMe[p.lig][p.col]);
						}
					}
					if (avoirCatalyse) {
						break;
					}
				}
			}
		}
		if (avoirCatalyse) {
			init_grids();
		} else {
			// se poser quelque part
			Pos minPos = {-1, -1};
			int sizeMin = -1;
			for (int lig = 0; lig < SGRID; lig++) {
				for (int col = 0; col < SGRID; col++) {
					if (isImpur(gridMe[lig][col]) && (sizeMin == -1 || sizeZonesMe[lig][col] < sizeMin)) {
						sizeMin = sizeZonesMe[lig][col];
						minPos = {lig, col};
					}
				}
			}
			if (minPos.lig == -1) {
				break;
			} else {
				case_type metal = CUIVRE;
				if (nbTypesInGridMe[FER] > nbTypesInGridMe[metal]) {
					metal = FER;
				}
				if (nbTypesInGridMe[PLOMB] > nbTypesInGridMe[metal]) {
					metal = PLOMB;
				}
				catalyser(minPos, idMe, metal);
			}
			break;
		}
	}
}

void transmuteMetaux(int seuil) {
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isMetal(gridMe[lig][col]) && sizeZonesMe[lig][col] >= seuil) {
				transmuter({lig, col});
				init_grids();
			}
		}
	}
}

void detructAllCases() {
	transmuteImpurs(3);
	catalyser();
	transmuteMetaux(3);
}

void destroyBecauseQuadrillage() {
	std::cerr << "DESTROY QUADRILLAGE\n";
	detructAllCases();
	PRET_METAL = PRET_METAL_BAS;
}
