#include "global.h"

/*
	USEFULL FONCTIONS
*/
bool isPosValid(position p) {
	return p.ligne >= 0 && p.colonne >= 0 && p.ligne < SGRID && p.colonne < SGRID;
}

bool isMetal(case_type type) {
	return type == PLOMB || type == FER || type == CUIVRE;
}

bool isImpur(case_type type) {
	return type != VIDE && !isMetal(type);
}

int scoreTransmutOrMetal(int nbCases) {
	return (nbCases < 2) ? -3 : (nbCases*nbCases)/4 -1;
}
int scoreTransmutOrImpur(int nbCases) {
	return (nbCases < 2) ? -3 : (nbCases-1)/2;
}

std::vector<position> getZoneSameTypeAdjsVector(position depart, Grid& grid) {
	GridBool vu(SGRID, std::vector<bool>(SGRID, false));
	
	std::vector<position> zone = {depart};
	for (int i = 0; i < (int)zone.size(); i++) {
		vu[zone[i].ligne][zone[i].colonne] = true;
		for (int iMove = 0; iMove < 4; iMove++) {
			position nextPos = {zone[i].ligne+moves[iMove][0], zone[i].colonne + moves[iMove][1]};
			if (isPosValid(nextPos) && grid[nextPos.lig][nextPos.col] == grid[depart.lig][depart.col] && !vu[nextPos.lig][nextPos.col]) {
				zone.push_back(nextPos);
				vu[nextPos.lig][nextPos.col] = true;
			}
		}
	}
	return zone;
}

int getZoneSameTypeAdjsSize(position depart, Grid& grid) {
	return getZoneSameTypeAdjsVector(depart, grid).size();
}

int nbAcoteType(Pos p, case_type type, Grid grid) {
	int n = 0;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && grid[nextP.lig][nextP.col] == type) {
			n++;
		}
	}
	return n;
}

case_type getTypeComposanteNext(Pos p) {
	int sizeMax = 0;
	case_type typeBest = VIDE;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && gridMe[nextP.lig][nextP.col] != VIDE) {
			case_type type = gridMe[nextP.lig][nextP.col];
			if ((sizeZonesMe[nextP.lig][nextP.col] > sizeMax && isMetal(type) == isMetal(typeBest))
				|| (isMetal(type) && !isMetal(typeBest))) {
				
				typeBest = type;
				sizeMax = sizeZonesMe[nextP.lig][nextP.col];
			}
		}
	}
	return typeBest;
}

/*
	Assert functions
*/

bool isBlocADanger(Pos p, bool includeJustAlone, Grid& grid) {
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && ((grid[nextP.lig][nextP.col] == VIDE && includeJustAlone)
			|| grid[nextP.lig][nextP.col] == grid[p.lig][p.col])) {
			return false;
		}
	}
	return true;
}

bool isBlocADanger(Pos p, bool includeJustAlone) {
	return isBlocADanger(p, includeJustAlone, gridMe);
}

std::vector<int> nbTypesAcotePlacable(Grid& grid) {
	std::vector<int> nbOfTypes(6, 0);
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (grid[lig][col] != VIDE) {
				continue;
			}
			bool tile = false;
			for (int iMove = 0; iMove < 4; iMove++) {
				Pos nextP = {lig + moves[iMove][0], col + moves[iMove][1]};
				if (isPosValid(nextP) && grid[nextP.lig][nextP.col] == VIDE) {
					tile = true;
				}
			}
			if (!tile) {
				continue;
			}
			for (int iMove = 0; iMove < 4; iMove++) {
				Pos nextP = {lig + moves[iMove][0], col + moves[iMove][1]};
				if (isPosValid(nextP)) {
					nbOfTypes[grid[nextP.lig][nextP.col]]++;
				}
			}
		}
	}
	return nbOfTypes;
}

/*
	FONCTIONS D'INIT
*/
void init_grids() {
	nbCasesFullMe = 0;
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			gridMe[lig][col] = type_case({lig, col}, idMe);
			gridOther[lig][col] = type_case({lig, col}, idOther);
			
			if (gridMe[lig][col] != VIDE) {
				nbCasesFullMe++;
			}
			
			sizeZonesMe[lig][col] = -1;
			sizeZonesOther[lig][col] = -1;
		}
	}
	IS_DENSITE_HAUT = (nbCasesFullMe > DENSITE_HAUT);
	IS_DENSITE_CRITIQUE = (nbCasesFullMe >= DENSITE_CRITIQUE);
	
	std::fill(nbTypesInGridMe.begin(), nbTypesInGridMe.end(), 0);
	std::fill(nbTypesInGridOther.begin(), nbTypesInGridOther.end(), 0);
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			nbTypesInGridMe[gridMe[lig][col]]++;
			nbTypesInGridOther[gridOther[lig][col]]++;
			
			
			if (sizeZonesMe[lig][col] == -1) {
				auto zone = getZoneSameTypeAdjsVector({lig, col}, gridMe);
				for (Pos p : zone) {
					sizeZonesMe[p.lig][p.col] = zone.size();
				}
			}
			if (sizeZonesOther[lig][col] == -1) {
				auto zone = getZoneSameTypeAdjsVector({lig, col}, gridOther);
				for (Pos p : zone) {
					sizeZonesOther[p.lig][p.col] = zone.size();
				}
			}
		}
	}
}
