#include "prologin.hh"
#include <vector>
#include <iostream>
#include <stack>
#include <algorithm>

#define col colonne
#define lig ligne
#define Pos position

using Grid = std::vector<std::vector<case_type>>;
using GridBool = std::vector<std::vector<bool>>;
const int SGRID = TAILLE_ETABLI;

const int PRET_METAL = 8;
const int PRET_METAL_CRITIQUE = 5;
const int PRET_IMPUR = 7;
const int BONUS_POSE_METAL = 2;
const int DENSITE_HAUT = 17;
const int DENSITE_CRITIQUE = 29;

/*
	GLOBAL VARIABLES
*/

int idMe, idOther;
Grid gridMe;
Grid gridOther;
echantillon pairTour;
int nbCasesFullMe;

bool IS_DENSITE_HAUT = false, IS_DENSITE_CRITIQUE = false;

int moves[4][2] = {{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

std::vector<int> nbTypesInGridMe(6, 0);
std::vector<int> nbTypesInGridOther(6, 0);

int sizeZonesMe[SGRID][SGRID];
int sizeZonesOther[SGRID][SGRID];

/*
	USEFULL FONCTIONS
*/
bool isPosValid(position p) {
	return p.ligne >= 0 && p.colonne >= 0 && p.ligne < SGRID && p.colonne < SGRID;
}

bool isMetal(case_type type) {
	return type == PLOMB || type == FER || type == CUIVRE;
}

bool isImpur(case_type type) {
	return type != VIDE && !isMetal(type);
}

int scoreTransmutOrMetal(int nbCases) {
	return (nbCases < 2) ? -3 : (nbCases*nbCases)/4 -1;
}
int scoreTransmutOrImpur(int nbCases) {
	return (nbCases < 2) ? -3 : (nbCases-1)/2;
}

std::vector<position> getZoneSameTypeAdjsVector(position depart, Grid& grid) {
	GridBool vu(SGRID, std::vector<bool>(SGRID, false));
	
	std::vector<position> zone = {depart};
	for (int i = 0; i < (int)zone.size(); i++) {
		vu[zone[i].ligne][zone[i].colonne] = true;
		for (int iMove = 0; iMove < 4; iMove++) {
			position nextPos = {zone[i].ligne+moves[iMove][0], zone[i].colonne + moves[iMove][1]};
			if (isPosValid(nextPos) && grid[nextPos.lig][nextPos.col] == grid[depart.lig][depart.col] && !vu[nextPos.lig][nextPos.col]) {
				zone.push_back(nextPos);
				vu[nextPos.lig][nextPos.col] = true;
			}
		}
	}
	return zone;
}

int getZoneSameTypeAdjsSize(position depart, Grid& grid) {
	return getZoneSameTypeAdjsVector(depart, grid).size();
}

int nbAcoteType(Pos p, case_type type, Grid grid) {
	int n = 0;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && grid[nextP.lig][nextP.col] == type) {
			n++;
		}
	}
	return n;
}

case_type getTypeComposanteNext(Pos p) {
	int sizeMax = 0;
	case_type typeBest = VIDE;
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && gridMe[nextP.lig][nextP.col] != VIDE) {
			case_type type = gridMe[nextP.lig][nextP.col];
			if ((sizeZonesMe[nextP.lig][nextP.col] > sizeMax && isMetal(type) == isMetal(typeBest))
				|| (isMetal(type) && !isMetal(typeBest))) {
				
				typeBest = type;
				sizeMax = sizeZonesMe[nextP.lig][nextP.col];
			}
		}
	}
	return typeBest;
}

/*
	Assert functions
*/

bool isBlocADanger(Pos p, bool includeJustAlone) {
	for (int iMove = 0; iMove < 4; iMove++) {
		Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
		if (isPosValid(nextP) && ((gridMe[nextP.lig][nextP.col] == VIDE && includeJustAlone)
			|| gridMe[nextP.lig][nextP.col] == gridMe[p.lig][p.col])) {
			return false;
		}
	}
	return true;
}

/*
	FONCTIONS D'INIT
*/
void init_grids() {
	nbCasesFullMe = 0;
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			gridMe[lig][col] = type_case({lig, col}, idMe);
			gridOther[lig][col] = type_case({lig, col}, idOther);
			
			if (gridMe[lig][col] != VIDE) {
				nbCasesFullMe++;
			}
			
			sizeZonesMe[lig][col] = -1;
			sizeZonesOther[lig][col] = -1;
		}
	}
	IS_DENSITE_HAUT = (nbCasesFullMe > DENSITE_HAUT);
	IS_DENSITE_CRITIQUE = (nbCasesFullMe >= DENSITE_CRITIQUE);
	
	std::fill(nbTypesInGridMe.begin(), nbTypesInGridMe.end(), 0);
	std::fill(nbTypesInGridOther.begin(), nbTypesInGridOther.end(), 0);
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			nbTypesInGridMe[gridMe[lig][col]]++;
			nbTypesInGridOther[gridOther[lig][col]]++;
			
			
			if (sizeZonesMe[lig][col] == -1) {
				auto zone = getZoneSameTypeAdjsVector({lig, col}, gridMe);
				for (Pos p : zone) {
					sizeZonesMe[p.lig][p.col] = zone.size();
				}
			}
			if (sizeZonesOther[lig][col] == -1) {
				auto zone = getZoneSameTypeAdjsVector({lig, col}, gridOther);
				for (Pos p : zone) {
					sizeZonesOther[p.lig][p.col] = zone.size();
				}
			}
		}
	}
}

/*
	FONCTIONS DE DESTRUCTION
*/
void fairePlaceWithoutConstraints() {
	//TODO: zones au "maximum"

	// essayer une grande zone impure
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 3) {
				transmuter({lig, col});
				init_grids();
				return ;
			}
		}
	}
	
	// essayer zone de metal petite, mais pas trop
	position pMin = {-1, -1};
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isMetal(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 3) {
				if (pMin.col == -1 || sizeZonesMe[lig][col] < sizeZonesMe[pMin.lig][pMin.col]) {
					pMin = {lig, col};
				}
			}
		}
	}
	if (pMin.lig != -1) {
		transmuter(pMin);
		init_grids();
		return ;
	}
	
	// essayer une petite zone impure non-nulle
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= 1) {
				transmuter({lig, col});
				init_grids();
				return ;
			}
		}
	}
	
	// n'importe quoi d'autre, sans -3
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] != VIDE && sizeZonesMe[lig][col] >= 2) {
				transmuter({lig, col});
				init_grids();
				return ;
			}
		}
	}
	
	// n'importe quoi d'autre
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] != VIDE) {
				transmuter({lig, col});
				init_grids();
				return ;
			}
		}
	}
}

void transmuteImpurs(int seuil) {
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isImpur(gridMe[lig][col]) && sizeZonesMe[lig][col] >= seuil) {
				transmuter({lig, col});
				init_grids();
			}
		}
	}
}

void catalyser() {
	// si densitee critique, bloc seul
	if (IS_DENSITE_CRITIQUE) {
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, false)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID && nombre_catalyseurs() > 0; col++) {
				if (isBlocADanger({lig, col}, true)) {
					catalyser({lig, col}, idMe, getTypeComposanteNext({lig, col}));
					init_grids();
				}
			}
		}
	}

	while (nombre_catalyseurs() > 0) {
		//tentez d'etre a cote du plus gros bloc
		std::vector<Pos> positionsSizes[37];
		for (int lig = 0; lig < SGRID; lig++) {
			for (int col = 0; col < SGRID; col++) {
				if (isMetal(gridMe[lig][col])) {
					positionsSizes[sizeZonesMe[lig][col]].push_back({lig, col});
				}
			}
		}
		bool avoirCatalyse = false;
		for (int size = 36; size > 0 && !avoirCatalyse; size--) {
			if (!positionsSizes[size].empty()) {
				//std::random_shuffle(positionsSizes[size].begin(), positionsSizes[size].end());
				for (Pos p : positionsSizes[size]) {
					for (int iMove = 0; iMove < 4 && !avoirCatalyse; iMove++) {
						Pos nextP = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
						if (isPosValid(nextP) && gridMe[nextP.lig][nextP.col] != VIDE && (isImpur(gridMe[nextP.lig][nextP.col]) || sizeZonesMe[nextP.lig][nextP.col] < sizeZonesMe[p.lig][p.col])) {
							avoirCatalyse = true;
							catalyser(nextP, idMe, gridMe[p.lig][p.col]);
						}
					}
					if (avoirCatalyse) {
						break;
					}
				}
			}
		}
		if (avoirCatalyse) {
			init_grids();
		} else {
			// se poser quelque part
			Pos minPos = {-1, -1};
			int sizeMin = -1;
			for (int lig = 0; lig < SGRID; lig++) {
				for (int col = 0; col < SGRID; col++) {
					if (isImpur(gridMe[lig][col]) && (sizeMin == -1 || sizeZonesMe[lig][col] < sizeMin)) {
						sizeMin = sizeZonesMe[lig][col];
						minPos = {lig, col};
					}
				}
			}
			if (minPos.lig == -1) {
				break;
			} else {
				case_type metal = CUIVRE;
				if (nbTypesInGridMe[FER] > nbTypesInGridMe[metal]) {
					metal = FER;
				}
				if (nbTypesInGridMe[PLOMB] > nbTypesInGridMe[metal]) {
					metal = PLOMB;
				}
				catalyser(minPos, idMe, metal);
			}
			break;
		}
	}
}

void transmuteMetaux(int seuil) {
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (isMetal(gridMe[lig][col]) && sizeZonesMe[lig][col] >= seuil) {
				transmuter({lig, col});
				init_grids();
			}
		}
	}
}

void detructAllCases() {
	transmuteImpurs(3);
	catalyser();
	transmuteMetaux(3);
}

/*
	FONCTIONS DE PLACEMENT
*/
void placeWithoutConstraints() {
	/*for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] == VIDE) {
				for (int iMove = 0; iMove < 4; iMove++) {
					position pNext = {lig+moves[iMove][0], col+moves[iMove][1]};
					if (isPosValid(pNext) && gridMe[pNext.lig][pNext.col] == VIDE) {
						placer_echantillon({lig, col}, pNext);
						return ;
					}
				}
			}
		}
	}*/
	std::vector<position_echantillon> placements = placements_possible_echantillon(pairTour, idMe);
	if (!placements.empty()) {
		position_echantillon posBest;
		int zoneVideMax = -1, nbCotesVidesMax = 0;
		
		for (position_echantillon posEch : placements) {
			placer_echantillon(posEch.pos1, posEch.pos2);
			init_grids();
			
			int aireMax = 0, nbCotesVides = 0;
			std::vector<Pos> positions = {posEch.pos1, posEch.pos2};
			for (Pos p : positions) {
				for (int iMove = 0; iMove < 4; iMove++) {
					Pos p2 = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
					if (isPosValid(p2) && gridMe[p2.lig][p2.col] == VIDE) {
						nbCotesVides++;
						for (int iDalle2 = 0; iDalle2 < 4; iDalle2++) {
							if (moves[iDalle2][0] == -moves[iMove][0] && moves[iDalle2][1] == - moves[iMove][1]) {
								continue;
							}
							Pos dalle2 = {p2.lig + moves[iDalle2][0], p2.col + moves[iDalle2][1]};
							if (isPosValid(dalle2) && gridMe[dalle2.lig][dalle2.col] == VIDE) {
								nbCotesVides += 100;
							}
						}
						aireMax = std::max(aireMax, sizeZonesMe[p2.lig][p2.col]);
					}
				}
			}
			if (aireMax > zoneVideMax || (aireMax == zoneVideMax && nbCotesVides > nbCotesVidesMax)) {
				zoneVideMax = aireMax;
				nbCotesVidesMax = nbCotesVides;
				//std::cerr << zoneVideMax << " " << nbCotesVidesMax << "\n";
				posBest = posEch;
			}
			annuler();
		}
		
		init_grids();
		if (zoneVideMax > -1) {
			placer_echantillon(posBest.pos1, posBest.pos2);
			return ;
		}
	} 
	// Pas de positions libres
	fairePlaceWithoutConstraints();
	placeWithoutConstraints();
}

int getScorePlacement(Pos posPlace1, Pos posPlace2) {
	gridMe[posPlace1.lig][posPlace1.col] = pairTour.element1;
	gridMe[posPlace2.lig][posPlace2.col] = pairTour.element2;
	
	//std::cerr << "----- Placer " << posPlace1.lig << " " << posPlace1.col << "  and  " <<posPlace2.lig << " " << posPlace2.col << "\n";
	int size1 = getZoneSameTypeAdjsSize(posPlace1, gridMe);
	//std::cerr << "size1 = " << size1 << "\n";
	int score = 0;
	
	if (isMetal(pairTour.element1)) {
		score += scoreTransmutOrMetal(size1) + BONUS_POSE_METAL;
	} else {
		score += scoreTransmutOrImpur(size1);
	}
	if (pairTour.element2 != pairTour.element1) {
		int size2 = getZoneSameTypeAdjsSize(posPlace2, gridMe);
		//std::cerr << "size2 = " << size2 << "\n";
		if (isMetal(pairTour.element2)) {
			score += scoreTransmutOrMetal(size2) + BONUS_POSE_METAL;
		} else {
			score += scoreTransmutOrImpur(size2);
		}
	}
	//std::cerr << "score = " << score << "\n";
	
	gridMe[posPlace1.lig][posPlace1.col] = VIDE;
	gridMe[posPlace2.lig][posPlace2.col] = VIDE;
	
	return score;
}

void placeWithConstraints() {
	if (nbTypesInGridMe[pairTour.element1] == 0 && nbTypesInGridMe[pairTour.element2] == 0) {
		placeWithoutConstraints();
		return ;
	}

	int maxScore = -10;
	Pos posMaxScoreEl1 = {-1, -1};
	Pos posMaxScoreEl2 = {-1, -1};
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] != VIDE) {
				continue;
			}
			//std::cerr << "main: " << lig << " " << col << "\n";
			for (int iMove = 0; iMove < 4; iMove++) {
				position pNext = {lig+moves[iMove][0], col+moves[iMove][1]};
				if (!isPosValid(pNext) || gridMe[pNext.lig][pNext.col] != VIDE) {
					continue;
				}
				//std::cerr << "sub: " << pNext.lig << " " << pNext.col << "\n";
				if (nbAcoteType({lig, col}, pairTour.element1, gridMe) + nbAcoteType(pNext, pairTour.element2, gridMe)==0) {
					continue;
				}
				int score = getScorePlacement({lig, col}, pNext);
				if (score > maxScore) {
					maxScore = score;
					posMaxScoreEl1 = {lig, col};
					posMaxScoreEl2 = pNext;
				}
			}
		}
	}
	
	if (posMaxScoreEl1.lig != -1) {
		placer_echantillon(posMaxScoreEl1, posMaxScoreEl2);
		return ;
	}
	
	fairePlaceWithoutConstraints(); // TODO: fonction dediee
	placeWithConstraints();
}

/*
	MAIN FONCTIONS
*/

void donnerPairSuivante() {
	auto pairNext = echantillon_tour();
	if ((isMetal(pairNext.element1) && isImpur(pairNext.element2))
		|| (isMetal(pairNext.element1) == isMetal(pairNext.element2)
			&& nbTypesInGridOther[pairNext.element1] > nbTypesInGridOther[pairNext.element2])) {
		std::swap(pairNext.element1, pairNext.element2);
	}
	pairNext.element2 = MERCURE;
	if (nbTypesInGridOther[SOUFRE] < nbTypesInGridOther[MERCURE]) {
		pairNext.element2 = SOUFRE;
	}
	if (pairNext.element1 == SOUFRE) {
		pairNext.element2 = MERCURE;
	} else if (pairNext.element1 == MERCURE) {
		pairNext.element2 = SOUFRE;
	}
	donner_echantillon(pairNext);
}

/// Fonction appelée au début de la partie.
void partie_init()
{
	idMe = moi();
	idOther = (idMe == 1) ? 2 : 1;
	//std::cerr << "MyId = " << idMe << "\n";
	
	gridMe = Grid(SGRID, std::vector<case_type>(SGRID, VIDE));
	gridOther = gridMe;
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	/*if (tour_actuel() > 23) {
		return;
	}*/
	std::cerr << "=============================================================\njouer debut " << idMe << "  tour " << tour_actuel() << "\n";
	//std::flush(std::cerr);
	init_grids();
	afficher_etablis();

	pairTour = echantillon_tour();
	
	//std::cerr << pairTour.element1 << ": " << nbTypesInGridMe[pairTour.element1] << "\n";
	//std::cerr << pairTour.element2 << ": " << nbTypesInGridMe[pairTour.element2] << "\n";
	
	placeWithConstraints();
	init_grids();
	
	// TODO: transmutations et utilisation des catalyseurs. Zones au "max"
	
	if (IS_DENSITE_HAUT) {
		transmuteImpurs(IS_DENSITE_CRITIQUE ? PRET_IMPUR/2 : PRET_IMPUR);
	}
	catalyser();
	if (IS_DENSITE_HAUT) {
		transmuteMetaux(IS_DENSITE_CRITIQUE ? PRET_METAL_CRITIQUE : PRET_METAL);
	}
	
	if (tour_actuel() >= NB_TOURS-1) {
		detructAllCases();
	} else {
		donnerPairSuivante();
	}
	
	afficher_etablis();
	//std::cerr << "jouer fin du tour " << tour_actuel() << "\n";
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
	// fonction a completer
  
	if (tour_actuel() >= NB_TOURS-1) {
		donnerPairSuivante();
	}
}

