#ifndef DECLARE_H
#define DECLARE_H

#include "global.h"

/*
	FONCTIONS D'EVALUATION
*/
bool must_destroyBecauseQuadrillage();
int countAndDeleteZone(Pos p, Grid& grid);
int evalGrid_pour_catalyse(Grid grid);
int getAreaMaxAround(Pos p);
int getScoreCotesVides(Pos p);

/*
	FONCTIONS DE PLACEMENT
*/
void placeWithoutConstraints();
int getScorePlacement(Pos posPlace1, Pos posPlace2);
bool hasPairConstraints(echantillon pair);
bool tryToPlaceWithConstraints();
void placeWithConstraints();

/*
	FONCTIONS DE DESTRUCTION
*/
bool fairePlaceWithoutConstraints();
void transmuteImpurs(int seuil);
void catalyser();
void catalyser_old();
void transmuteMetaux(int seuil);
void detructAllCases();
void destroyBecauseQuadrillage();

/*
	USEFULL FONCTIONS
*/
bool isPosValid(position p);
bool isMetal(case_type type);
bool isImpur(case_type type);
int scoreTransmutOrMetal(int nbCases);
int scoreTransmutOrImpur(int nbCases);
std::vector<position> getZoneSameTypeAdjsVector(position depart, Grid& grid);
int getZoneSameTypeAdjsSize(position depart, Grid& grid);
int nbAcoteType(Pos p, case_type type, Grid grid);
case_type getTypeComposanteNext(Pos p);
std::vector<int> nbTypesAcotePlacable(Grid& grid);

/*
	Assert functions
*/
bool isBlocADanger(Pos p, bool includeJustAlone, Grid& grid);
bool isBlocADanger(Pos p, bool includeJustAlone);

/*
	FONCTIONS D'INIT
*/
void init_grids();

#endif
