/*
	FONCTIONS DE PLACEMENT
*/
void placeWithoutConstraints() {
	/*for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] == VIDE) {
				for (int iMove = 0; iMove < 4; iMove++) {
					position pNext = {lig+moves[iMove][0], col+moves[iMove][1]};
					if (isPosValid(pNext) && gridMe[pNext.lig][pNext.col] == VIDE) {
						placer_echantillon({lig, col}, pNext);
						return ;
					}
				}
			}
		}
	}*/
	std::vector<position_echantillon> placements = placements_possible_echantillon(pairTour, idMe);
	if (!placements.empty()) {
		position_echantillon posBest;
		int zoneVideMax = -1, nbCotesVidesMax = 0;
		
		for (position_echantillon posEch : placements) {
			placer_echantillon(posEch.pos1, posEch.pos2);
			init_grids();
			
			int aireMax = 0, nbCotesVides = 0;
			std::vector<Pos> positions = {posEch.pos1, posEch.pos2};
			for (Pos p : positions) {
				for (int iMove = 0; iMove < 4; iMove++) {
					Pos p2 = {p.lig + moves[iMove][0], p.col + moves[iMove][1]};
					if (isPosValid(p2) && gridMe[p2.lig][p2.col] == VIDE) {
						nbCotesVides++;
						for (int iDalle2 = 0; iDalle2 < 4; iDalle2++) {
							if (moves[iDalle2][0] == -moves[iMove][0] && moves[iDalle2][1] == - moves[iMove][1]) {
								continue;
							}
							Pos dalle2 = {p2.lig + moves[iDalle2][0], p2.col + moves[iDalle2][1]};
							if (isPosValid(dalle2) && gridMe[dalle2.lig][dalle2.col] == VIDE) {
								nbCotesVides += 100;
							}
						}
						aireMax = std::max(aireMax, sizeZonesMe[p2.lig][p2.col]);
					}
				}
			}
			if (aireMax > zoneVideMax || (aireMax == zoneVideMax && nbCotesVides > nbCotesVidesMax)) {
				zoneVideMax = aireMax;
				nbCotesVidesMax = nbCotesVides;
				//std::cerr << zoneVideMax << " " << nbCotesVidesMax << "\n";
				posBest = posEch;
			}
			annuler();
		}
		
		init_grids();
		if (zoneVideMax > -1) {
			placer_echantillon(posBest.pos1, posBest.pos2);
			return ;
		}
	} 
	// Pas de positions libres
	if (fairePlaceWithoutConstraints()) {
		placeWithoutConstraints();
	} else {
		destroyBecauseQuadrillage();
	}
}

int getScorePlacement(Pos posPlace1, Pos posPlace2) {
	gridMe[posPlace1.lig][posPlace1.col] = pairTour.element1;
	gridMe[posPlace2.lig][posPlace2.col] = pairTour.element2;
	
	//std::cerr << "----- Placer " << posPlace1.lig << " " << posPlace1.col << "  and  " <<posPlace2.lig << " " << posPlace2.col << "\n";
	int size1 = getZoneSameTypeAdjsSize(posPlace1, gridMe);
	//std::cerr << "size1 = " << size1 << "\n";
	int score = 0;
	
	if (isMetal(pairTour.element1)) {
		score += scoreTransmutOrMetal(size1) + BONUS_POSE_METAL;
	} else {
		score += scoreTransmutOrImpur(size1);
	}
	if (pairTour.element2 != pairTour.element1) {
		int size2 = getZoneSameTypeAdjsSize(posPlace2, gridMe);
		//std::cerr << "size2 = " << size2 << "\n";
		if (isMetal(pairTour.element2)) {
			score += scoreTransmutOrMetal(size2) + BONUS_POSE_METAL;
		} else {
			score += scoreTransmutOrImpur(size2);
		}
	}
	//std::cerr << "score = " << score << "\n";
	
	gridMe[posPlace1.lig][posPlace1.col] = VIDE;
	gridMe[posPlace2.lig][posPlace2.col] = VIDE;
	
	return score;
}

bool hasPairConstraints(echantillon pair) {
	return (nbTypesInGridMe[pair.element1] > 0 || nbTypesInGridMe[pair.element2] > 0);
}

bool tryToPlaceWithConstraints() {
	int maxScore = -10;
	Pos posMaxScoreEl1 = {-1, -1};
	Pos posMaxScoreEl2 = {-1, -1};
	
	for (int lig = 0; lig < SGRID; lig++) {
		for (int col = 0; col < SGRID; col++) {
			if (gridMe[lig][col] != VIDE) {
				continue;
			}
			//std::cerr << "main: " << lig << " " << col << "\n";
			for (int iMove = 0; iMove < 4; iMove++) {
				position pNext = {lig+moves[iMove][0], col+moves[iMove][1]};
				if (!isPosValid(pNext) || gridMe[pNext.lig][pNext.col] != VIDE) {
					continue;
				}
				//std::cerr << "sub: " << pNext.lig << " " << pNext.col << "\n";
				if (nbAcoteType({lig, col}, pairTour.element1, gridMe) + nbAcoteType(pNext, pairTour.element2, gridMe)==0) {
					continue;
				}
				int score = getScorePlacement({lig, col}, pNext);
				if (score > maxScore) {
					maxScore = score;
					posMaxScoreEl1 = {lig, col};
					posMaxScoreEl2 = pNext;
				}
			}
		}
	}
	
	if (posMaxScoreEl1.lig != -1) {
		placer_echantillon(posMaxScoreEl1, posMaxScoreEl2);
		return maxScore+10;
	}
	return 0;
}

void placeWithConstraints() {
	if (!hasPairConstraints(pairTour)) {
		placeWithoutConstraints();
		return ;
	}

	if (tryToPlaceWithConstraints()) {
		return;
	}
	
	for (int etape = 0; etape < 3; etape++) {
		for (int lig1 = 0; lig1 < SGRID; lig1++) {
			for (int col1 = 0; col1 < SGRID; col1++) {
				if (etape == 1 && !isImpur(gridMe[lig1][col1])) {
					continue;
				}
				if (etape == 2 && !isMetal(gridMe[lig1][col1])) {
					continue;
				}
				if (etape != 3 && sizeZonesMe[lig1][col1] < 2) {
					continue;
				}
				if (gridMe[lig1][col1] != VIDE) {
					transmuter({lig1, col1});
				
					if (tryToPlaceWithConstraints()) {
						return;
					}
				
					annuler();
					init_grids();
				}
			}
		}
	}
	
	destroyBecauseQuadrillage();
}
