/*************

Fichier principal. Les commentaires de la fonctions jouer_tour
decrivrent le dereoulement d'un tour de cette IA

*************/

#include "global.h"
/*
	GLOBAL VARIABLES
*/

int PRET_METAL = 8;

int idMe, idOther;
Grid gridMe;
Grid gridOther;
echantillon pairTour;
int nbCasesFullMe;

bool IS_DENSITE_HAUT = false, IS_DENSITE_CRITIQUE = false;

int moves[4][2] = {{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

std::vector<int> nbTypesInGridMe(6, 0);
std::vector<int> nbTypesInGridOther(6, 0);

int sizeZonesMe[SGRID][SGRID];
int sizeZonesOther[SGRID][SGRID];

/*
	MAIN FONCTIONS
*/

/*void donnerPairSuivante() {
	auto pairNext = echantillon_tour();
	if (nbTypesInGridOther[pairNext.element1] > nbTypesInGridOther[pairNext.element2]) {
		std::swap(pairNext.element1, pairNext.element2);
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = SOUFRE;
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = MERCURE;
	}
	for (int i = 1; i <= 5; i++) {
		if (TYPES_TAB[i] != pairNext.element1 && nbTypesInGridOther[pairNext.element2] >= nbTypesInGridOther[i]) {
			pairNext.element2 = TYPES_TAB[i];
		}
	}
	donner_echantillon(pairNext);
}*/

void donnerPairSuivante() {
	auto pairNext = echantillon_tour();
	auto nbTypesPlacables = nbTypesAcotePlacable(gridOther);
	if (nbTypesPlacables[pairNext.element1] > nbTypesPlacables[pairNext.element2]) {
		std::swap(pairNext.element1, pairNext.element2);
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = SOUFRE;
	}
	if (pairNext.element1 == pairNext.element2) {
		pairNext.element2 = MERCURE;
	}
	for (int i = 1; i <= 5; i++) {
		if (TYPES_TAB[i] != pairNext.element1 && nbTypesPlacables[pairNext.element2] >= nbTypesPlacables[i]) {
			pairNext.element2 = TYPES_TAB[i];
		}
	}
	donner_echantillon(pairNext);
}

/// Fonction appelée au début de la partie.
void partie_init()
{
	std::ios_base::sync_with_stdio(false);
	idMe = moi();
	idOther = (idMe == 1) ? 2 : 1;
	
	gridMe = Grid(SGRID, std::vector<case_type>(SGRID, VIDE));
	gridOther = gridMe;
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	/** Initialisiser les variables represantant l'etat du jeu localement **/
	init_grids();

	pairTour = echantillon_tour();
	
	/** Dans un cas bloquant, reset la grille **/
	if (must_destroyBecauseQuadrillage()) {
		destroyBecauseQuadrillage();
	}
	
	/** Placer la piece, en supprimant si necessaire une zone **/
	placeWithConstraints();
	init_grids(); // recalcule les valeurs en fonction de la modification precedente
	
	/** En cas de forte densitee, supprimer les grosses zones de non-metaux **/
	if (IS_DENSITE_HAUT) {
		transmuteImpurs(IS_DENSITE_CRITIQUE ? PRET_IMPUR/2 : PRET_IMPUR);
	}
	/** Utiliser au mieux tout les catalysateurs possibles **/
	catalyser();
	/** En cas de forte densitee, supprimer les grosses zones de metaux **/
	if (IS_DENSITE_HAUT) {
		transmuteMetaux(IS_DENSITE_CRITIQUE ? PRET_METAL_CRITIQUE : PRET_METAL);
	}
	
	if (tour_actuel() >= NB_TOURS-1) {
		/** Au dernier tour, destruire toutes les zones rapportant de l'or **/
		detructAllCases();
	} else {
		/** Calculer la paire a donner a l'adversaire **/
		donnerPairSuivante();
	}
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
	// fonction a completer
  
	if (tour_actuel() >= NB_TOURS-1) {
		donnerPairSuivante();
	}
}

