///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_php.rb
//

#include "interface.hh"

static void _init_php();

template <typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
zval* cxx2lang<zval*, int>(int in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_LONG(x, (long)in);
    return x;
}

template <>
zval* cxx2lang<zval*, bool>(bool in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_BOOL(x, in);
    return x;
}

template <>
zval* cxx2lang<zval*, std::string>(std::string in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    ZVAL_STRINGL(x, in.c_str(), in.length(), true);
    return x;
}

template <typename Cxx>
zval* cxx2lang_array(const std::vector<Cxx>& in)
{
    zval* x;
    MAKE_STD_ZVAL(x);
    array_init(x);

    size_t s = in.size();

    for (size_t i = 0; i < s; ++i)
      add_next_index_zval(x, cxx2lang<zval*, Cxx>(in[i]));

    return x;
}

template <typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
int lang2cxx<zval*, int>(zval* in)
{
    if (in->type != IS_LONG) {
        zend_error(E_WARNING, "parameter should be an int");
        throw 42;
    }
    return (int)Z_LVAL_P(in);
}

template <>
bool lang2cxx<zval*, bool>(zval* in)
{
    if (in->type != IS_BOOL) {
        zend_error(E_WARNING, "parameter should be a boolean");
        throw 42;
    }
    return Z_BVAL_P(in);
}

template <>
std::string lang2cxx<zval*, std::string>(zval* in)
{
    if (in->type != IS_STRING) {
        zend_error(E_WARNING, "parameter should be a string");
        throw 42;
    }
    return Z_STRVAL_P(in);
}

template <typename Cxx>
std::vector<Cxx> lang2cxx_array(zval* in)
{
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter should be an array");
        throw 42;
    }

    HashTable* ht = Z_ARRVAL_P(in);
    std::vector<Cxx> out;
    size_t s = zend_hash_num_elements(ht);

    for (size_t i = 0; i < s; ++i)
    {
        zval** v;
        zend_hash_index_find(ht, i, (void**)&v);
        out.push_back(lang2cxx<zval*, Cxx>(*v));
    }

    return out;
}
///
// Erreurs possibles
//
template <>
zval* cxx2lang<zval*, erreur>(erreur in)
{
    return cxx2lang<zval*, int>((int)in);
}

template <>
erreur lang2cxx<zval*, erreur>(zval* in)
{
    return (erreur)lang2cxx<zval*, int>(in);
}

///
// Position sur la carte, donnée par deux coordonnées.
//
template <>
zval* cxx2lang<zval*, position>(position in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, int>(in.x));
    add_assoc_zval(ret, "x", tmp);
    tmp = (cxx2lang<zval*, int>(in.y));
    add_assoc_zval(ret, "y", tmp);
    return ret;
}

template <>
position lang2cxx<zval*, position>(zval* in)
{
    position out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "x", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"x\" of struct \"position\" not found");
        throw 42;
    }
    out.x = lang2cxx<zval*, int>(*tmp);
    if (zend_hash_find(ht, "y", 2, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"y\" of struct \"position\" not found");
        throw 42;
    }
    out.y = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Représente un lien existant.
//
template <>
zval* cxx2lang<zval*, lien>(lien in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, position>(in.extr1));
    add_assoc_zval(ret, "extr1", tmp);
    tmp = (cxx2lang<zval*, position>(in.extr2));
    add_assoc_zval(ret, "extr2", tmp);
    tmp = (cxx2lang<zval*, int>(in.joueur_l));
    add_assoc_zval(ret, "joueur_l", tmp);
    return ret;
}

template <>
lien lang2cxx<zval*, lien>(zval* in)
{
    lien out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "extr1", 6, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"extr1\" of struct \"lien\" not found");
        throw 42;
    }
    out.extr1 = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "extr2", 6, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"extr2\" of struct \"lien\" not found");
        throw 42;
    }
    out.extr2 = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "joueur_l", 9, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"joueur_l\" of struct \"lien\" not found");
        throw 42;
    }
    out.joueur_l = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Représente un champ de contrôle existant.
//
template <>
zval* cxx2lang<zval*, champ>(champ in)
{
    zval* ret;
    zval* tmp;
    MAKE_STD_ZVAL(ret);
    array_init(ret);
    tmp = (cxx2lang<zval*, position>(in.som1));
    add_assoc_zval(ret, "som1", tmp);
    tmp = (cxx2lang<zval*, position>(in.som2));
    add_assoc_zval(ret, "som2", tmp);
    tmp = (cxx2lang<zval*, position>(in.som3));
    add_assoc_zval(ret, "som3", tmp);
    tmp = (cxx2lang<zval*, int>(in.joueur_c));
    add_assoc_zval(ret, "joueur_c", tmp);
    return ret;
}

template <>
champ lang2cxx<zval*, champ>(zval* in)
{
    champ out;
    if (in->type != IS_ARRAY) {
        zend_error(E_WARNING, "parameter is not a structure");
        throw 42;
    }
    zval** tmp;
    HashTable* ht = Z_ARRVAL_P(in);
    if (zend_hash_find(ht, "som1", 5, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"som1\" of struct \"champ\" not found");
        throw 42;
    }
    out.som1 = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "som2", 5, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"som2\" of struct \"champ\" not found");
        throw 42;
    }
    out.som2 = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "som3", 5, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"som3\" of struct \"champ\" not found");
        throw 42;
    }
    out.som3 = lang2cxx<zval*, position>(*tmp);
    if (zend_hash_find(ht, "joueur_c", 9, (void**)&tmp) != SUCCESS) {
        zend_error(E_WARNING, "field \"joueur_c\" of struct \"champ\" not found");
        throw 42;
    }
    out.joueur_c = lang2cxx<zval*, int>(*tmp);
    return out;
}

///
// Déplace votre agent sur la case passée en argument.
//
PHP_FUNCTION(php_api_deplacer)
{
    zval* _dest;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_dest) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_deplacer(lang2cxx<zval*, position>(_dest)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Utilise un turbo.
//
PHP_FUNCTION(php_api_utiliser_turbo)
{
        try {
zval* ret = cxx2lang<zval*, erreur>(api_utiliser_turbo());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Capture le portail où est positionné votre agent.
//
PHP_FUNCTION(php_api_capturer)
{
        try {
zval* ret = cxx2lang<zval*, erreur>(api_capturer());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Crée un lien entre le portail où se trouve votre agent et le portail de destination donné en argument.
//
PHP_FUNCTION(php_api_lier)
{
    zval* _portail;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_portail) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, erreur>(api_lier(lang2cxx<zval*, position>(_portail)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Neutralise le portail où se trouve votre agent.
//
PHP_FUNCTION(php_api_neutraliser)
{
        try {
zval* ret = cxx2lang<zval*, erreur>(api_neutraliser());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Ajoute un bouclier au portail sur lequel se trouve votre agent.
//
PHP_FUNCTION(php_api_ajouter_bouclier)
{
        try {
zval* ret = cxx2lang<zval*, erreur>(api_ajouter_bouclier());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les liens présents.
//
PHP_FUNCTION(php_api_liste_liens)
{
        try {
zval* ret = cxx2lang_array(api_liste_liens());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les champs de contrôle.
//
PHP_FUNCTION(php_api_liste_champs)
{
        try {
zval* ret = cxx2lang_array(api_liste_champs());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les portails de la carte.
//
PHP_FUNCTION(php_api_liste_portails)
{
        try {
zval* ret = cxx2lang_array(api_liste_portails());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les liens existants qui croisent un segment, entravant la création d'un lien.
//
PHP_FUNCTION(php_api_liens_bloquants)
{
    zval* _ext1;
    zval* _ext2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_ext1, &_ext2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_liens_bloquants(lang2cxx<zval*, position>(_ext1), lang2cxx<zval*, position>(_ext2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Prend les positions de deux portails, et renvoie un booléen indiquant s'ils sont reliés. Le résultat est `false` lorsque l'une des deux positions ne repère pas un portail.
//
PHP_FUNCTION(php_api_lien_existe)
{
    zval* _ext1;
    zval* _ext2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_ext1, &_ext2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_lien_existe(lang2cxx<zval*, position>(_ext1), lang2cxx<zval*, position>(_ext2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie un booléen indiquant si les 3 positions repèrent bien 3 portails tous reliés entre eux.
//
PHP_FUNCTION(php_api_champ_existe)
{
    zval* _som1;
    zval* _som2;
    zval* _som3;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_som1, &_som2, &_som3) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_champ_existe(lang2cxx<zval*, position>(_som1), lang2cxx<zval*, position>(_som2), lang2cxx<zval*, position>(_som3)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie un booléen indiquant si la case ``pos`` se trouve dans un champ.
//
PHP_FUNCTION(php_api_case_dans_champ)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_case_dans_champ(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des champs à l'intérieur desquels ``pos`` se trouve. Si la case est un portail, le résultat de ``case_champs`` sera disjoint de celui de ``champs_incidents_portail``.
//
PHP_FUNCTION(php_api_case_champs)
{
    zval* _pos;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_pos) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_case_champs(lang2cxx<zval*, position>(_pos)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le numéro du joueur correspondant au portail donné, -1 si le portail est neutre, -2 si la case n'est pas un portail. Vous pouvez utiliser cette fonction pour vérifier qu'une case donnée est bien un portail.
//
PHP_FUNCTION(php_api_portail_joueur)
{
    zval* _portail;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_portail) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_portail_joueur(lang2cxx<zval*, position>(_portail)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le nombre de boucliers présents sur un portail (-2 si la case n'est pas un portail).
//
PHP_FUNCTION(php_api_portail_boucliers)
{
    zval* _portail;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_portail) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_portail_boucliers(lang2cxx<zval*, position>(_portail)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les liens dont le portail donné est une extrémité.
//
PHP_FUNCTION(php_api_liens_incidents_portail)
{
    zval* _portail;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_portail) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_liens_incidents_portail(lang2cxx<zval*, position>(_portail)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les champs dont le portail donné est un sommet.
//
PHP_FUNCTION(php_api_champs_incidents_portail)
{
    zval* _portail;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_portail) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_champs_incidents_portail(lang2cxx<zval*, position>(_portail)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste de tous les champs dont le lien donné est un côté. Si le segment n'est pas un lien présent, renvoie la liste de tous les champs que la création du lien ferait apparaître.
//
PHP_FUNCTION(php_api_champs_incidents_segment)
{
    zval* _ext1;
    zval* _ext2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_ext1, &_ext2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang_array(api_champs_incidents_segment(lang2cxx<zval*, position>(_ext1), lang2cxx<zval*, position>(_ext2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des portails capturés par votre adversaire au dernier tour.
//
PHP_FUNCTION(php_api_hist_portails_captures)
{
        try {
zval* ret = cxx2lang_array(api_hist_portails_captures());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des portails neutralisés par votre adversaire au dernier tour.
//
PHP_FUNCTION(php_api_hist_portails_neutralises)
{
        try {
zval* ret = cxx2lang_array(api_hist_portails_neutralises());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des liens créés par votre adversaire au dernier tour.
//
PHP_FUNCTION(php_api_hist_liens_crees)
{
        try {
zval* ret = cxx2lang_array(api_hist_liens_crees());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des champs créés par votre adversaire au dernier tour.
//
PHP_FUNCTION(php_api_hist_champs_crees)
{
        try {
zval* ret = cxx2lang_array(api_hist_champs_crees());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la liste des positions où votre adversaire a ajouté des boucliers au dernier tour.
//
PHP_FUNCTION(php_api_hist_boucliers_ajoutes)
{
        try {
zval* ret = cxx2lang_array(api_hist_boucliers_ajoutes());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie la distance de Manhattan entre deux positions.
//
PHP_FUNCTION(php_api_distance)
{
    zval* _pos1;
    zval* _pos2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zz", &_pos1, &_pos2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_distance(lang2cxx<zval*, position>(_pos1), lang2cxx<zval*, position>(_pos2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le nombre de points que rapporte(rait) chaque tour un champ existant ou hypothétique.
//
PHP_FUNCTION(php_api_score_triangle)
{
    zval* _som1;
    zval* _som2;
    zval* _som3;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzz", &_som1, &_som2, &_som3) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_score_triangle(lang2cxx<zval*, position>(_som1), lang2cxx<zval*, position>(_som2), lang2cxx<zval*, position>(_som3)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Indique si deux segments se croisent. Cette fonction correspond exactement à la condition d'interférence entre liens, c'est-à-dire qu'elle renvoie ``false`` si l'intersection est une extrémité des deux segments.
//
PHP_FUNCTION(php_api_intersection_segments)
{
    zval* _a1;
    zval* _a2;
    zval* _b1;
    zval* _b2;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzzz", &_a1, &_a2, &_b1, &_b2) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_intersection_segments(lang2cxx<zval*, position>(_a1), lang2cxx<zval*, position>(_a2), lang2cxx<zval*, position>(_b1), lang2cxx<zval*, position>(_b2)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Indique si un point se trouve à l'intérieur d'un triangle. Le critère coïncide avec celui de ``case_champs``.
//
PHP_FUNCTION(php_api_point_dans_triangle)
{
    zval* _p;
    zval* _som1;
    zval* _som2;
    zval* _som3;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "zzzz", &_p, &_som1, &_som2, &_som3) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, bool>(api_point_dans_triangle(lang2cxx<zval*, position>(_p), lang2cxx<zval*, position>(_som1), lang2cxx<zval*, position>(_som2), lang2cxx<zval*, position>(_som3)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie votre numéro de joueur.
//
PHP_FUNCTION(php_api_moi)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_moi());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le numéro de votre adversaire.
//
PHP_FUNCTION(php_api_adversaire)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_adversaire());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Indique la position de l'agent du joueur désigné par le numéro ``id_joueur``.
//
PHP_FUNCTION(php_api_position_agent)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, position>(api_position_agent(lang2cxx<zval*, int>(_id_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Indique votre nombre de points d'actions restants pour ce tour-ci.
//
PHP_FUNCTION(php_api_points_action)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_points_action());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Indique votre nombre de points de déplacement restants pour ce tour-ci.
//
PHP_FUNCTION(php_api_points_deplacement)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_points_deplacement());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le score du joueur désigné par le numéro ``id_joueur``.
//
PHP_FUNCTION(php_api_score)
{
    zval* _id_joueur;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_id_joueur) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
zval* ret = cxx2lang<zval*, int>(api_score(lang2cxx<zval*, int>(_id_joueur)));
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Renvoie le numéro du tour actuel.
//
PHP_FUNCTION(php_api_tour_actuel)
{
        try {
zval* ret = cxx2lang<zval*, int>(api_tour_actuel());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
//
PHP_FUNCTION(php_api_annuler)
{
        try {
zval* ret = cxx2lang<zval*, bool>(api_annuler());
    RETURN_ZVAL(ret, 0, 0);
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type erreur
//
PHP_FUNCTION(php_api_afficher_erreur)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_erreur(lang2cxx<zval*, erreur>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type position
//
PHP_FUNCTION(php_api_afficher_position)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_position(lang2cxx<zval*, position>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type lien
//
PHP_FUNCTION(php_api_afficher_lien)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_lien(lang2cxx<zval*, lien>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

///
// Affiche le contenu d'une valeur de type champ
//
PHP_FUNCTION(php_api_afficher_champ)
{
    zval* _v;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "z", &_v) == FAILURE)
    {
        RETURN_NULL();
    }

        try {
api_afficher_champ(lang2cxx<zval*, champ>(_v));
    RETURN_NULL();
    } catch (...) { RETURN_NULL(); }
}

static zend_function_entry module_functions_table[] = {
    PHP_FALIAS(deplacer, php_api_deplacer, NULL)    PHP_FALIAS(utiliser_turbo, php_api_utiliser_turbo, NULL)    PHP_FALIAS(capturer, php_api_capturer, NULL)    PHP_FALIAS(lier, php_api_lier, NULL)    PHP_FALIAS(neutraliser, php_api_neutraliser, NULL)    PHP_FALIAS(ajouter_bouclier, php_api_ajouter_bouclier, NULL)    PHP_FALIAS(liste_liens, php_api_liste_liens, NULL)    PHP_FALIAS(liste_champs, php_api_liste_champs, NULL)    PHP_FALIAS(liste_portails, php_api_liste_portails, NULL)    PHP_FALIAS(liens_bloquants, php_api_liens_bloquants, NULL)    PHP_FALIAS(lien_existe, php_api_lien_existe, NULL)    PHP_FALIAS(champ_existe, php_api_champ_existe, NULL)    PHP_FALIAS(case_dans_champ, php_api_case_dans_champ, NULL)    PHP_FALIAS(case_champs, php_api_case_champs, NULL)    PHP_FALIAS(portail_joueur, php_api_portail_joueur, NULL)    PHP_FALIAS(portail_boucliers, php_api_portail_boucliers, NULL)    PHP_FALIAS(liens_incidents_portail, php_api_liens_incidents_portail, NULL)    PHP_FALIAS(champs_incidents_portail, php_api_champs_incidents_portail, NULL)    PHP_FALIAS(champs_incidents_segment, php_api_champs_incidents_segment, NULL)    PHP_FALIAS(hist_portails_captures, php_api_hist_portails_captures, NULL)    PHP_FALIAS(hist_portails_neutralises, php_api_hist_portails_neutralises, NULL)    PHP_FALIAS(hist_liens_crees, php_api_hist_liens_crees, NULL)    PHP_FALIAS(hist_champs_crees, php_api_hist_champs_crees, NULL)    PHP_FALIAS(hist_boucliers_ajoutes, php_api_hist_boucliers_ajoutes, NULL)    PHP_FALIAS(distance, php_api_distance, NULL)    PHP_FALIAS(score_triangle, php_api_score_triangle, NULL)    PHP_FALIAS(intersection_segments, php_api_intersection_segments, NULL)    PHP_FALIAS(point_dans_triangle, php_api_point_dans_triangle, NULL)    PHP_FALIAS(moi, php_api_moi, NULL)    PHP_FALIAS(adversaire, php_api_adversaire, NULL)    PHP_FALIAS(position_agent, php_api_position_agent, NULL)    PHP_FALIAS(points_action, php_api_points_action, NULL)    PHP_FALIAS(points_deplacement, php_api_points_deplacement, NULL)    PHP_FALIAS(score, php_api_score, NULL)    PHP_FALIAS(tour_actuel, php_api_tour_actuel, NULL)    PHP_FALIAS(annuler, php_api_annuler, NULL)    PHP_FALIAS(afficher_erreur, php_api_afficher_erreur, NULL)    PHP_FALIAS(afficher_position, php_api_afficher_position, NULL)    PHP_FALIAS(afficher_lien, php_api_afficher_lien, NULL)    PHP_FALIAS(afficher_champ, php_api_afficher_champ, NULL)    {NULL, NULL, NULL}
};
static zend_module_entry api_module_entry = {
    STANDARD_MODULE_HEADER,
    "api",
    module_functions_table,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "1.0",
    STANDARD_MODULE_PROPERTIES
};

static void _init_php()
{
    static int initialized = 0;
    if (initialized)
        return;
    initialized = 1;

    char* argv[] = { "champion", NULL };
    char buffer[1024];
    const char* path;
    zend_file_handle script;

    path = getenv("CHAMPION_PATH");
    if (!path)
        path = ".";

    snprintf(buffer, 1024, "include('%s/%s.php');", path, "prologin");

    php_embed_init(1, argv PTSRMLS_CC);
    zend_startup_module(&api_module_entry);
    zend_eval_string(buffer, NULL, "PHP to Stechec interface");
}

///
// Fonction appelée au début de la partie.
//
extern "C" void partie_init()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_init", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée à chaque tour.
//
extern "C" void jouer_tour()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "jouer_tour", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

///
// Fonction appelée à la fin de la partie.
//
extern "C" void partie_fin()
{
    zval* ret;
    zval* fname;
    _init_php();

    MAKE_STD_ZVAL(ret);
    MAKE_STD_ZVAL(fname);
    ZVAL_STRING(fname, "partie_fin", 1);
    if (call_user_function(EG(function_table), NULL, fname, ret, 0, NULL TSRMLS_CC) == FAILURE)
    {
        abort();
    }
    zval_ptr_dtor(&ret);
    zval_ptr_dtor(&fname);
}

