///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

int absint(int n){ return (n < 0)?-n:n; }
int signe(int n){ return (n >= 0)? 1: -1; }
const int INFINI = 1000*1000*1000;

#include "prologin.hh"
#include <vector>
#include <algorithm>
#include <cstdio>

bool operator == (const position& a, const position& b){ return a.x == b.x && a.y == b.y; }
bool operator != (const position& a, const position& b){ return !(a == b); }

///
// Fonction appelée au début de la partie.
//
void partie_init()
{
  // fonction a completer
}

struct Action
{
    position portail;
    int nbBoucliers;
    Action(){ portail.x = -1; }
    Action(position p, int n){ portail = p, nbBoucliers = n; }
};

struct Portail  // structure pour choisir et classer les portails suivants possibles
{
    position pos;
    int pertesEnemis;
    int gains;
    int dist;
    int coutAttaque; // mettre la distance divise par 6 dedans
};

const int distChampAction = 12;
//const int coutMaxAttaque = 50;

/*bool operator < (const Portail& a, const Portail& b)
{
    if (a.dist > distChampAction && b.dist > distChampAction) // en dehors du champ d'action, on va au plus pres
        return a.dist < b.dist;
    if (a.dist > distChampAction)
        return false;
    if (b.dist > distChampAction)
        return true;
    
    if (a.coutAttaque > coutMaxAttaque && b.coutAttaque > coutMaxAttaque)
        return a.dist < b.dist;
    if (a.coutAttaque > coutMaxAttaque)
        return false;
    if (b.coutAttaque > coutMaxAttaque)
        return true;
    
    return (a.gains + a.pertesEnemis) > (a.gains + a.pertesEnemis);
}*/

const double coefMediumDist = 5.;
const double coefDist = 100.;
const double coefGains = 120.;
const double coefDegats = 200.;//3;
const double coefCout = 50.;

int maxiZone = 0;

double encoder (const Portail& a)
{
    double malusPos = abs((double)a.dist - coefMediumDist) * coefDist / 42.;
    double valGains = (double)a.gains * coefGains / 800.;
    double valDegats = (double)a.pertesEnemis * coefDegats / 800.;
    double malusCout = (double)a.coutAttaque * coefCout / 42.;
    
    printf("\ncomparaison:\n");
    printf("  malusPos %lf\n", malusPos);
    printf("  valGains %lf\n", valGains);
    printf("  valDegats %lf\n", valDegats);
    printf("  malusCout %lf\n", malusCout);
    return valGains + valDegats - malusPos - malusCout;
}

//const int

int proteger(const Portail& a)
{
    return 2;
}

bool operator < (const Portail& a, const Portail& b)
{
    if (a.dist > distChampAction && b.dist > distChampAction) // en dehors du champ d'action, on va au plus pres
        return a.dist < b.dist;
    if (a.dist > distChampAction)
        return false;
    if (b.dist > distChampAction)
        return true;
    
    double code1 = encoder(a);
    double code2 = encoder(b);
    
    return code1 < code2;
}

/*position posPortailGo()
{
    std::vector<position> portails = liste_portails();
    int distMeil = INFINI;
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi()) {
            int d = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            if (d < distMeil)
                distMeil = d, posMeil = portails[i];
        }
    return posMeil;
}*/

Action actionFind()
{
    printf("\naction find\n");
    /*std::vector<position> portails = liste_portails();
    int distMeil = INFINI;
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi()) {
            int d = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            if (d < distMeil)
                distMeil = d, posMeil = portails[i];
        }
    int nbBoucliers = 1;
    if (posMeil.x != -1)
        if (portail_boucliers(posMeil) > nbBoucliers)
            nbBoucliers = portail_boucliers(posMeil);
    return Action(posMeil, nbBoucliers);*/
    std::vector<position> portails = liste_portails();
    std::vector<Portail> suivants;
    
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi())
        {
            Portail port;
            port.pos = portails[i];
            port.dist = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            port.coutAttaque = COUT_CAPTURE + port.dist/6;
            if (portail_boucliers(portails[i]) > 0)
                port.coutAttaque += portail_boucliers(portails[i]) * COUT_NEUTRALISATION_BOUCLIER;
            if (portail_joueur(portails[i]) > -1)
                port.coutAttaque += COUT_NEUTRALISATION;
            
            port.pertesEnemis = 0;
            std::vector<champ> champsEnemis = champs_incidents_portail(portails[i]);
            for (int iChamp = 0; iChamp < (int)champsEnemis.size(); iChamp++)
                port.pertesEnemis += score_triangle(champsEnemis[iChamp].som1, champsEnemis[iChamp].som2, champsEnemis[iChamp].som3);
            
            port.gains = POINTS_CAPTURE;
            std::vector<lien> liens = liste_liens();
            for (int iLien = 0; iLien < (int)liens.size(); iLien++)
            {
                lien li = liens[iLien];
                if (li.joueur_l == moi())
                {
                    std::vector<lien> coupes = liens_bloquants(portails[i], li.extr1);
                    std::vector<lien> coupes2 = liens_bloquants(portails[i], li.extr2);
                    for (int a = 0; a < (int)coupes2.size(); a++)
                        coupes.push_back(coupes2[a]);
                    bool estCoupe = false;
                    
                    for (int iCoupe = 0; iCoupe < (int)coupes.size(); iCoupe++)
                        if (coupes[iCoupe].extr1 != portails[i] && coupes[iCoupe].extr2 != portails[i]) {
                            estCoupe = true;
                            break;
                        }
                    if (!estCoupe)
                    {
                        port.gains += score_triangle(portails[i], li.extr1, li.extr2);
                    }
                }
            }
            
            suivants.push_back(port);
            
        }
    
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    int nbBoucliers = 0;
    std::sort(suivants.begin(), suivants.end());
    
    if ((int)suivants.size() > 0)
    {
        int iChoisit = 0;
        posMeil = suivants[iChoisit].pos;
        nbBoucliers = proteger(suivants[iChoisit]);
    }
    
    return Action(posMeil, nbBoucliers);
    
}

bool termineLiens = true;

bool jouerAction(Action& act, int& nbDeps, int& nbPts)
{
    if (act.portail.x == -1)
        return true;
    
    printf ("je joue une action... joueur de la case %d %d: %d", act.portail.x, act.portail.y, portail_joueur(act.portail));
    position pos = position_agent(moi());
    printf("position de moi %d %d\n", pos.x, pos.y);
    // go vers ledit lieu
    
    if (pos.x != act.portail.x || pos.y != act.portail.y) // deplacer
    {
        printf("deplacement\n");
        position go = act.portail;
        int dist = absint(go.x-pos.x) + absint(go.y-pos.y);
        
        while (nbDeps < dist && nbPts >= COUT_TURBO) {
            nbDeps++, nbPts -= COUT_TURBO;
            utiliser_turbo();
        }
        
        int depX = std::min(absint(pos.x-go.x), nbDeps) * signe(go.x-pos.x);
        nbDeps -= abs(depX);
        int depY = std::min(absint(pos.y-go.y), nbDeps) * signe(go.y-pos.y);
        nbDeps -= abs(depY);
        
        pos.x += depX; pos.y += depY;
        
        erreur e = deplacer(pos);
        if (e != OK)
            printf("erreur!!! \n");
        if (e == PA_INSUFFISANTS)
            printf("pas assez de pa\n");
        if (e == POSITION_INVALIDE)
            printf("pos invalide\n");
        if (e == POSITION_ELOIGNEE)
            printf("pos trop loin\n");
        
        if (pos.x != go.x || pos.y != go.y)
            return false;
    }
    
    // neutraliser
    
    if (portail_joueur(pos) == adversaire())
    {
        int cout = portail_boucliers(pos) * COUT_NEUTRALISATION_BOUCLIER + COUT_NEUTRALISATION;
        if (cout > nbPts)
            return false;
        nbPts -= cout;
        neutraliser();
    }
    
    // capturer
    
    if (portail_joueur(pos) != moi())
    {
        if (COUT_CAPTURE > nbPts)
            return false;
        nbPts -= COUT_CAPTURE;
        capturer();
    }
    
    // creer les liens
    
    std::vector<position> portails = liste_portails();
    for (int i = 0; i < (int)portails.size(); i++)
    {
        erreur e = lier(portails[i]);
        if (e == OK)
            nbPts -= COUT_LIEN;
        if (e == PA_INSUFFISANTS)
            return false;
    }
    
    // creer les boucliers
    
    printf("\n %d boucliers case %d %d\n", act.nbBoucliers, act.portail.x, act.portail.y);
    
    /*int nbBoucliersPoses = portail_boucliers(pos);
    while (act.nbBoucliers > nbBoucliersPoses)
    {
        printf("acheter un bouclier, il y en a maintenant %d\n", nbBoucliersPoses);
        if (nbPts < COUT_BOUCLIER)
            return false;
        nbPts -= COUT_BOUCLIER;
        ajouter_bouclier();
        nbBoucliersPoses++;
    }*/
    
    while (act.nbBoucliers > 0)
    {
        if (nbPts < COUT_BOUCLIER)
            return false;
        printf("reste a poser %d boucliers\n", act.nbBoucliers);
        nbPts -= COUT_BOUCLIER;
        ajouter_bouclier();
        act.nbBoucliers--;
    }
    
    return true;
}

///
// Fonction appelée à chaque tour.
//
Action actAfaire;
void jouer_tour()
{
    
    int nbDeps = NB_POINTS_DEPLACEMENT, nbPts = NB_POINTS_ACTION;
    
    while (jouerAction(actAfaire, nbDeps, nbPts))
    {
        actAfaire = actionFind();
        if (actAfaire.portail.x == -1)
            break;
    }
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
  // fonction a completer
  printf("\n\n\n maxiZone: %d", maxiZone);
}

