///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

int absint(int n){ return (n < 0)?-n:n; }
int signe(int n){ return (n >= 0)? 1: -1; }
const int INFINI = 1000*1000*1000;

#include "prologin.hh"
#include <vector>
#include <algorithm>
#include <cstdio>

///
// Fonction appelée au début de la partie.
//
void partie_init()
{
  // fonction a completer
}

position posPortailGo()
{
    std::vector<position> portails = liste_portails();
    int distMeil = INFINI;
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi()) {
            int d = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            if (d < distMeil)
                distMeil = d, posMeil = portails[i];
        }
    return posMeil;
}

bool termineLiens = true;

///
// Fonction appelée à chaque tour.
//
void jouer_tour()
{
    
    int nbDeps = NB_POINTS_DEPLACEMENT, nbPts = NB_POINTS_ACTION;
    int tourFini = false;
    
    while (!tourFini)
    {
        // faire les liens
        
        if (portail_joueur(position_agent(moi())) != moi())
            termineLiens = true;
        
        if (!termineLiens)
        {
            std::vector<position> portails = liste_portails();
            for (int i = 0; i < (int)portails.size(); i++)
                //if (portail_joueur(portails[i]) == moi()
                //    && (portails[i].x != position_agent(moi()).x || portails[i].y != position_agent(moi()).y) ) 
                {
                    erreur e = lier(portails[i]);
                    if (e == OK)
                        nbPts -= COUT_LIEN;
                    if (e == PA_INSUFFISANTS)
                        return ;
                }
                termineLiens = true;
        }
        
        // puis go au plus proche
        
        position go = posPortailGo();
        if (go.x != -1)
        {
            int dist = absint(go.x-position_agent(moi()).x) + absint(go.y-position_agent(moi()).y);
            
            while (nbDeps < dist && nbPts >= COUT_TURBO) {
                nbDeps++, nbPts -= COUT_TURBO;
                utiliser_turbo();
            }
            
            position pos = position_agent(moi());
            int depX = std::min(absint(pos.x-go.x), nbDeps) * signe(go.x-pos.x);
            nbDeps -= depX;
            int depY = std::min(absint(pos.y-go.y), nbDeps) * signe(go.y-pos.y);
            nbDeps -= depY;
            
            pos.x += depX; pos.y += depY;
            
            deplacer(pos);
            
            if (pos.x != go.x || pos.y != go.y)
                return ;
            if (portail_joueur(pos) == adversaire())
            {
                int cout = portail_boucliers(pos) * COUT_NEUTRALISATION_BOUCLIER + COUT_NEUTRALISATION;
                if (cout > nbPts)
                    return ;
                nbPts -= cout;
                neutraliser();
            }
            if (COUT_CAPTURE > nbPts)
                return ;
            nbPts -= COUT_CAPTURE;
            capturer();
            
            termineLiens = false;
            
        }
        
    }
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
  // fonction a completer
}

