/*
    Algo bourrin qui cherche les portails les plus proches (en gros), de maniere tres simple
*/

int absint(int n){ return (n < 0)?-n:n; }
int absdouble(double n){ return (n < 0)?-n:n; }
int signe(int n){ return (n >= 0)? 1: -1; }
const int INFINI = 1000*1000*1000;

#include "prologin.hh"
#include <vector>
#include <algorithm>
#include <cstdio>
#include <cmath>
#include <chrono>
#include <ctime>
#include <cstdlib>

bool operator == (const position& a, const position& b){ return a.x == b.x && a.y == b.y; }
bool operator != (const position& a, const position& b){ return !(a == b); }

struct Action
{
    position portail;
    int nbBoucliers;
    Action(){ portail.x = -1; }
    Action(position p, int n){ portail = p, nbBoucliers = n; }
};

struct Portail
{
    position pos;
    int dist;
    int coutAttaque;
    bool enemi;
    int surfaceDeb;
};

int proteger(const Portail& a)
{
    return 2;
}

const int distOpti = 4;
const int distMin = 2;
const int ecartDistsTolere = 2;
const int coefDiviseMoinsEnemiCout = 4;

bool operator < (const Portail& a, const Portail& b)
{
    if (a.dist < distMin && b.dist >= distMin)
        return false;
    if (a.dist >= distMin && b.dist < distMin)
        return true;
        
    if ((a.surfaceDeb > 0) != (b.surfaceDeb > 0)) // si un seul des deux est relie, il domine
        return (a.surfaceDeb > 0);
    
    int distA = /*a.dist + 1;/*/( std::abs(a.dist - distOpti) + 1 );
    int distB = /*b.dist + 1;/*/( std::abs(b.dist - distOpti) + 1 );
    
    /*if (a.enemi && !b.enemi && a.coutAttaque / 5 <= b.coutAttaque * 4)
        return true;
    if (!a.enemi && b.enemi && b.coutAttaque / 5 <= a.coutAttaque * 4)
        return false;
    
    if (std::abs(a.dist - b.dist) < ecartDistsTolere)
        if (a.coutAttaque != b.coutAttaque)
            return a.coutAttaque < b.coutAttaque;*/
    
    if (std::abs(distA - distB) <= ecartDistsTolere)
    {
        int coutA = a.coutAttaque, coutB = b.coutAttaque;
        if (a.enemi)
            coutA -= coutA / coefDiviseMoinsEnemiCout;
        if (b.enemi)
            coutB -= coutB / coefDiviseMoinsEnemiCout;
        
        if (coutA != coutB)
            return coutA < coutB;
        return distA > distB;
    }
    
    return distA < distB;
}

bool compPositions(const position& a, const position& b)
{
    int d1 = std::abs(a.x-position_agent(moi()).x) + absint(a.y-position_agent(moi()).y);
    int d2 = std::abs(b.x-position_agent(moi()).x) + absint(b.y-position_agent(moi()).y);
    return d1 < d2;
}

Action actionFind()
{
    /*std::chrono::time_point<std::chrono::system_clock> start, end;
    start = std::chrono::system_clock::now();*/
    
    //printf("\naction find\n");
    std::vector<position> portails = liste_portails();
    std::vector<Portail> suivants;
    
    std::sort(portails.begin(), portails.end(), compPositions);
    
    bool debute = false;
    Portail pMeil;
    
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi())
        {
            Portail port;
            port.pos = portails[i];
            port.dist = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            port.coutAttaque = COUT_CAPTURE;
            if (portail_boucliers(portails[i]) > 0)
                port.coutAttaque += portail_boucliers(portails[i]) * COUT_NEUTRALISATION_BOUCLIER;
            if (portail_joueur(portails[i]) > -1)
                port.coutAttaque += COUT_NEUTRALISATION;
            if (portail_joueur(portails[i]) == moi())
                port.coutAttaque = 0;
            port.coutAttaque += port.dist * 6;
            
            port.enemi = (portail_joueur(portails[i]) == adversaire());
            
            /*port.reliee = true;
            if ((int)liens_bloquants(portails[i], position_agent(moi())).size() > 0)
                port.reliee = false;*/
            port.surfaceDeb = 0;
            //if (portail_joueur(position_agent(moi())) == moi())
            //{
            /*std::vector<lien> liensDeb = liens_incidents_portail(position_agent(moi()));
            for (int iLien = 0; iLien < (int)liensDeb.size(); iLien++)
                if ((int)liens_bloquants(liensDeb[iLien].extr1, portails[i]).size() < 1 &&
                    (int)liens_bloquants(liensDeb[iLien].extr2, portails[i]).size() < 1)
                        port.surfaceDeb += score_triangle(liensDeb[iLien].extr1, liensDeb[iLien].extr2, portails[i]);*/
            if ((int)liens_bloquants(position_agent(moi()), portails[i]).size() < 1)
                port.surfaceDeb = 1;
            //}
            
            //suivants.push_back(port);
            if (!debute || port < pMeil) {
                printf(" - PRIS: ");
                pMeil = port, debute = true;
            }
            
            //printf("portail %d %d dist %d coutAttaque %d enemi %d surfaceDeb %d\n", port.pos.x, port.pos.y, port.dist, port.coutAttaque, (int)port.enemi, port.surfaceDeb);
            
        }
    
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    int nbBoucliers = 2;
    std::sort(suivants.begin(), suivants.end());
    
    
    /*end = std::chrono::system_clock::now();
    std::chrono::duration<double> elapsed_seconds = end-start;
    printf("\n--- > fonction actionFind time : %lf secondes\n", elapsed_seconds.count());*/
    
    if (debute)
        return Action(pMeil.pos, nbBoucliers);
    
    //if ((int)suivants.size() > 0)
    //    return Action(suivants[0].pos, nbBoucliers);
    
    return Action(posMeil, nbBoucliers);
    
}

bool jouerAction(Action& act, int& nbDeps, int& nbPts)
{
    /*std::chrono::time_point<std::chrono::system_clock> start, end;
    start = std::chrono::system_clock::now();*/
    if (act.portail.x == -1)
        return true;
    
    position pos = position_agent(moi());
    
    //deplacement
    
    if (pos.x != act.portail.x || pos.y != act.portail.y)
    {
        position go = act.portail;
        int dist = absint(go.x-pos.x) + absint(go.y-pos.y);
        
        while (nbDeps < dist && nbPts >= COUT_TURBO) {
            nbDeps++, nbPts -= COUT_TURBO;
            utiliser_turbo();
        }
        
        int depX = std::min(absint(pos.x-go.x), nbDeps) * signe(go.x-pos.x);
        nbDeps -= abs(depX);
        int depY = std::min(absint(pos.y-go.y), nbDeps) * signe(go.y-pos.y);
        nbDeps -= abs(depY);
        
        pos.x += depX; pos.y += depY;
        
        deplacer(pos);
        
        if (pos.x != go.x || pos.y != go.y)
            return false;
    }
    
    // neutraliser
    
    if (portail_joueur(pos) == adversaire())
    {
        int cout = portail_boucliers(pos) * COUT_NEUTRALISATION_BOUCLIER + COUT_NEUTRALISATION;
        if (cout > nbPts)
            return false;
        nbPts -= cout;
        neutraliser();
    }
    
    // capturer
    
    if (portail_joueur(pos) != moi())
    {
        if (COUT_CAPTURE > nbPts)
            return false;
        nbPts -= COUT_CAPTURE;
        capturer();
    }
    
    // creer les liens
    
    std::vector<position> portails = liste_portails();
    for (int i = 0; i < (int)portails.size(); i++)
    {
        erreur e = lier(portails[i]);
        if (e == OK)
            nbPts -= COUT_LIEN;
        if (e == PA_INSUFFISANTS)
            return false;
    }
    
    // creer les boucliers
    
    int ad = 2 + rand()%2;
    ad -= portail_boucliers(pos);
    while (ad > 0)
    {
        if (nbPts < COUT_BOUCLIER)
            return false;
        nbPts -= COUT_BOUCLIER;
        ajouter_bouclier();
        ad--;
    }
    /*end = std::chrono::system_clock::now();
    std::chrono::duration<double> elapsed_seconds = end-start;
    printf("\nfonction deplacer time : %lf secondes\n", elapsed_seconds.count());*/
    
    return true;
}

///
// Fonction appelée à chaque tour.
//
Action actAfaire;
void jouer_tour()
{
    int nbDeps = NB_POINTS_DEPLACEMENT, nbPts = NB_POINTS_ACTION;
    
    while (jouerAction(actAfaire, nbDeps, nbPts))
    {
        actAfaire = actionFind();
        if (actAfaire.portail.x == -1)
            break;
    }
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
  // fonction a completer
}

