
struct Action
{
    int iPortail;
    int boucliers;
    bool termine;
    Action (){ termine = true; }
    Action (int p, int b){ this->iPortail = p, this->boucliers = b; termine = false; }
};

struct Game
{

    std::vector<Portail> portails;
    std::vector< std::vector<int> >voisins;
    std::vector<Lien> liens;
    std::vector<Champ> champs;
    
    Action act[2];
    Position pos[2];
    int agentActu;
    int deps, pa;
    
    // pour l'arbre
    int firstChild, lastChild;
    int codeVal;                // le codeVal est la difference entre son score et celui de l'adversaire
    int maxValArbre, bestChild;
    std::vector<Action> actions;
    
    // initialisateurs
    
    void initialiser()
    {
        firstChild = -1, lastChild = -1;
        codeVal = 0;
        maxValArbre = 0, bestChild = -1;
        
        deps = 6, pa = 42;
    }
    
    void genererVoisins()
    {
        for (int i = 0; i < (int)liens.size(); i++)
            voisins[liens[i].bout1].push_back(liens[i].bout2), voisins[liens[i].bout2].push_back(liens[i].bout1);
    }
    
    void recurGenereChamp(int iPort, int profond, Champ& c;)
    {
        Champ c;
        if (profond >= 4)
            if (c.p1 == iPort && portails[c.p1].pos > portails[c.p2].pos && portails[c.p1].pos > portails[c.p3].pos)
                if (portails[c.p1].agent == portails[c.p2].agent && portails[c.p1].agent == portails[c.p3].agent)
                    champs.push_back(c);
        
        if (profond == 1) c.p1 = iPort;
        if (profond == 2) c.p2 = iPort;
        if (profond == 3) c.p3 = iPort;
        
        for (int i = 0; i < (int)voisins[iPort].size(); i++)
            recurGenereChamp(voisins[iPort][i], profond+1, c);
    }
    
    void genererChamps()
    {
        if ((int)champs.size() < 1)
        {
            genererVoisins();
            for (int i = 0; i < (int)portails.size(); i++)
                recurGenereChamp(i, 1, Champ(-1, -1, -1, portails[i].agent);
        }
    }
    
    Game(){ initialiser(); }
    
    // fonction geometriques
    
    bool ptDansChamp(Position pt)
    {
        for (int i = 0; i < (int)this->champs.size(); i++)
        {
            Position p1 = champs[i].p1.pos, p2 = champs[i].p2.pos, p2 = champs[i].p2.pos;
            Point pt0 = Point(pt.x, pt.y), pt1 = Point(p1.x, p1.y), pt2 = Point(p2.x, p2.y), pt3 = Point(p3.x, p3.y);
            
            int signe1 = signe(prodVect(Vecteur(pt1, pt2), Vecteur(pt1, pt0)));
            int signe2 = signe(prodVect(Vecteur(pt2, pt3), Vecteur(pt2, pt0)));
            int signe3 = signe(prodVect(Vecteur(pt3, pt1), Vecteur(pt3, pt0)));
            
            if (signe1 == signe2 && signe2 == signe3 && signe1 != 0 && signe2 != 0 && signe3 != 0)
                return true;
        }
        return false;
    }

};
