///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

int absint(int n){ return (n < 0)?-n:n; }
int signe(int n){ return (n >= 0)? 1: -1; }
const int INFINI = 1000*1000*1000;

#include "prologin.hh"
#include <vector>
#include <algorithm>
#include <cstdio>
#include <ctime>
#include <cstdlib>

///
// Fonction appelée au début de la partie.
//
void partie_init()
{
  // fonction a completer
}

position objectifPos;
int termineLiens = false;
int boucliersPose = 0;
int objectifActu = false;

// constantes de config

const int TXdistMin = 4;
const int TXdistRand = 2;

struct Portail
{
    position pos;
    position pos2;
    Portail(){}
    Portail(position p){
        pos = p, pos2 = p;
        pos2.x += rand()%(TXdistRand+1) - (TXdistRand+1)/2;
        pos2.y += rand()%(TXdistRand+1) - (TXdistRand+1)/2;
    }
};

bool operator < (const Portail &a, const Portail &b)
{
    position agent = position_agent(moi());
    int distAgent1 = abs(agent.x-a.pos2.x) + abs(agent.y-a.pos2.y);
    int distAgent2 = abs(agent.x-b.pos2.x) + abs(agent.y-b.pos2.y);
    
    if (distAgent1 >= TXdistMin && distAgent2 < TXdistMin)
        return true;
    if (distAgent1 < TXdistMin && distAgent2 >= TXdistMin)
        return false;
    if (distAgent1 >= TXdistMin)
        return distAgent1 < distAgent2;
    return distAgent1 > distAgent2;
}

void terminator() // determine le prochain
{
    printf("\nterminator %d: ", moi());
    
    std::vector<position> portails = liste_portails();
    std::vector<Portail> possibles;
    
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi()) {
            possibles.push_back(Portail(portails[i]));
        }
    
    if ((int)possibles.size() < 1){
        objectifActu = false;
        printf("plus de possibilites\n");
        return ;
    }
        
    std::sort(possibles.begin(), possibles.end());
    objectifPos = possibles[0].pos;
    
    printf("position %d %d\n", objectifPos.x, objectifPos.y);
    
    objectifActu = true;
    boucliersPose = 1;
    //objectifPos = posMeil;
}

bool TX_terminer(int& nbDeps, int& nbPts) // jouer l'action
{
    position pos = position_agent(moi());
    printf("\n TX %d de %d %d  -> %d %d\n", moi(), pos.x, pos.y, objectifPos.x, objectifPos.y);
    
    if (pos.x != objectifPos.x || pos.y != objectifPos.y) // deplacer
    {
        position go = objectifPos;
        int dist = absint(go.x-position_agent(moi()).x) + absint(go.y-position_agent(moi()).y);
        
        while (nbDeps < dist && nbPts >= COUT_TURBO) {
            nbDeps++, nbPts -= COUT_TURBO;
            utiliser_turbo();
        }
        
        int depX = std::min(absint(pos.x-go.x), nbDeps) * signe(go.x-pos.x);
        nbDeps -= depX;
        int depY = std::min(absint(pos.y-go.y), nbDeps) * signe(go.y-pos.y);
        nbDeps -= depY;
        
        pos.x += depX; pos.y += depY;
        
        deplacer(pos);
        
        if (pos.x != go.x || pos.y != go.y)
            return false;
    }
    
    if (portail_joueur(pos) == adversaire()) // neutraliser le portail
    {
        int cout = portail_boucliers(pos) * COUT_NEUTRALISATION_BOUCLIER + COUT_NEUTRALISATION;
        if (cout > nbPts)
            return false;
        nbPts -= cout;
        neutraliser();
    }
    
    // capturer le portail
    if (COUT_CAPTURE > nbPts)
        return false;
    nbPts -= COUT_CAPTURE;
    capturer();
    
    // faire les liens
    if (!termineLiens)
    {
        std::vector<position> portails = liste_portails();
        for (int i = 0; i < (int)portails.size(); i++)
        {
            erreur e = lier(portails[i]);
            if (e == OK)
                nbPts -= COUT_LIEN;
            if (e == PA_INSUFFISANTS)
                return false;
        }
        termineLiens = true;
    }
    
    // pose des boucliers
    
    while (boucliersPose > 0)
    {
        int coutPose = COUT_BOUCLIER + portail_boucliers(pos);
        if (coutPose > nbPts)
            return false;
        coutPose -= nbPts;
        ajouter_bouclier();
        boucliersPose--;
    }
    
    objectifActu = false;
    termineLiens = false;
    return true;
}

///
// Fonction appelée à chaque tour.
//
void jouer_tour()
{
    srand(time(NULL));
    int nbDeps = NB_POINTS_DEPLACEMENT, nbPts = NB_POINTS_ACTION;
    
    if (!objectifActu)
        terminator();
    
    while (TX_terminer(nbDeps, nbPts) && objectifActu)
    {
        terminator();
    }
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
  // fonction a completer
}

