// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_rust.rb

use api::{self,
// Types de cases
CaseType,
// Direction
Direction,
// Erreurs possibles
Erreur,
// Types d'actions
ActionType,
// Types de drapeaux de débug
DebugDrapeau,
};
use std::{mem, ptr, slice};
use std::os::raw::{c_float ,c_double, c_int, c_void};

#[repr(C)]
#[derive(Clone)]
pub struct Array<T> {
    pub ptr: *const T,
    pub len: usize,
}

pub trait ToAPI {
  type To;
  unsafe fn to_api(&self) -> Self::To;
}

pub trait ToFFI {
  type To;
  fn to_ffi(&self) -> Self::To;
}

impl<T: ToAPI + Clone> ToAPI for Array<T> {
  type To = Vec<T::To>;
  unsafe fn to_api(&self) -> Self::To {
    let vec;
    {
      let slice = slice::from_raw_parts(self.ptr, self.len);
      vec = slice.iter().map(|elem| elem.to_api()).collect();
    }
    free(self.ptr as _);
    vec
  }
}

impl<T: ToFFI> ToFFI for Vec<T> {
  type To = Array<T::To>;
  fn to_ffi(&self) -> Self::To {
    unsafe {
      let ptr: *mut T::To = malloc(self.len() * mem::size_of::<T::To>()) as _;
      let len = self.len();
      for i in 0..len {
        ptr::write(ptr.add(i), self[i].to_ffi());
      }
      Array { ptr, len }
    }
  }
}

impl ToAPI for () {
  type To = ();
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for () {
  type To = ();
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_int {
  type To = c_int;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_int {
  type To = c_int;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_float {
  type To = c_float;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_float {
  type To = c_float;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for c_double {
  type To = c_double;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for c_double {
  type To = c_double;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for bool {
  type To = bool;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for bool {
  type To = bool;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

impl ToAPI for *const char {
  type To = *const char;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for *const char {
  type To = *const char;
  fn to_ffi(&self) -> Self::To { self.clone() }
}

// Types de cases
impl ToAPI for CaseType {
  type To = CaseType;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for CaseType {
  type To = CaseType;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Direction
impl ToAPI for Direction {
  type To = Direction;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for Direction {
  type To = Direction;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Erreurs possibles
impl ToAPI for Erreur {
  type To = Erreur;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for Erreur {
  type To = Erreur;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Types d'actions
impl ToAPI for ActionType {
  type To = ActionType;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for ActionType {
  type To = ActionType;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Types de drapeaux de débug
impl ToAPI for DebugDrapeau {
  type To = DebugDrapeau;
  unsafe fn to_api(&self) -> Self::To { self.clone() }
}

impl ToFFI for DebugDrapeau {
  type To = DebugDrapeau;
  fn to_ffi(&self) -> Self::To { self.clone() }
}


// Position dans la mine, donnée par deux coordonnées.
#[repr(C)]
#[derive(Clone)]
pub struct Position {
  /// Coordonnée : ligne
  pub ligne: c_int,
  /// Coordonnée : colonne
  pub colonne: c_int,
}

impl ToAPI for Position {
  type To = api::Position;
  unsafe fn to_api(&self) -> Self::To {
    api::Position {
      ligne: self.ligne.to_api(),
      colonne: self.colonne.to_api(),
    }
  }
}

impl ToFFI for api::Position {
  type To = Position;
  fn to_ffi(&self) -> Self::To {
    Position {
      ligne: self.ligne.to_ffi(),
      colonne: self.colonne.to_ffi(),
    }
  }
}


// Minerai à récolter
#[repr(C)]
#[derive(Clone)]
pub struct Minerai {
  /// Nombre de coups de pioches encore nécessaires avant que le bloc de minerais ne casse
  pub resistance: c_int,
  /// Valeur marchande du bloc de minerai
  pub rendement: c_int,
}

impl ToAPI for Minerai {
  type To = api::Minerai;
  unsafe fn to_api(&self) -> Self::To {
    api::Minerai {
      resistance: self.resistance.to_api(),
      rendement: self.rendement.to_api(),
    }
  }
}

impl ToFFI for api::Minerai {
  type To = Minerai;
  fn to_ffi(&self) -> Self::To {
    Minerai {
      resistance: self.resistance.to_ffi(),
      rendement: self.rendement.to_ffi(),
    }
  }
}


// Nain (standard)
#[repr(C)]
#[derive(Clone)]
pub struct Nain {
  /// Position actuelle du nain (standard)
  pub pos: Position,
  /// Point(s) de vie restant du nain (standard)
  pub vie: c_int,
  /// Point(s) d'action restant du nain (standard)
  pub pa: c_int,
  /// Point(s) de déplacement restant du nain (standard)
  pub pm: c_int,
  /// Le nain (standard) est accroché à la paroi ou à une corde
  pub accroche: bool,
  /// Valeur marchande totale que le nain (standard) possède
  pub butin: c_int,
}

impl ToAPI for Nain {
  type To = api::Nain;
  unsafe fn to_api(&self) -> Self::To {
    api::Nain {
      pos: self.pos.to_api(),
      vie: self.vie.to_api(),
      pa: self.pa.to_api(),
      pm: self.pm.to_api(),
      accroche: self.accroche.to_api(),
      butin: self.butin.to_api(),
    }
  }
}

impl ToFFI for api::Nain {
  type To = Nain;
  fn to_ffi(&self) -> Self::To {
    Nain {
      pos: self.pos.to_ffi(),
      vie: self.vie.to_ffi(),
      pa: self.pa.to_ffi(),
      pm: self.pm.to_ffi(),
      accroche: self.accroche.to_ffi(),
      butin: self.butin.to_ffi(),
    }
  }
}


// Action de déplacement représentée dans l'historique.
#[repr(C)]
#[derive(Clone)]
pub struct ActionHist {
  /// Type de l'action
  pub atype: ActionType,
  /// Numéro du nain (standard) concerné par l'action
  pub id_nain: c_int,
  /// Direction visée par le nain (standard) durant le déplacement
  pub dir: Direction,
  /// Sens de l'action, utilisé uniquement pour préciser si l'on doit tirer une corde vers le bas ou vers le haut. Direction doit cibler la droite ou la gauche.
  pub sens: Direction,
}

impl ToAPI for ActionHist {
  type To = api::ActionHist;
  unsafe fn to_api(&self) -> Self::To {
    api::ActionHist {
      atype: self.atype.to_api(),
      id_nain: self.id_nain.to_api(),
      dir: self.dir.to_api(),
      sens: self.sens.to_api(),
    }
  }
}

impl ToFFI for api::ActionHist {
  type To = ActionHist;
  fn to_ffi(&self) -> Self::To {
    ActionHist {
      atype: self.atype.to_ffi(),
      id_nain: self.id_nain.to_ffi(),
      dir: self.dir.to_ffi(),
      sens: self.sens.to_ffi(),
    }
  }
}


extern {
fn malloc(size: usize) -> *mut c_void;

fn free(p: *mut c_void);

// Renvoie un chemin entre deux positions de la mine sous la forme d'une suite de directions à emprunter. Ce chemin minimise le nombre de blocs de granite nécessaire à casser. Si la position est invalide ou qu'il n'existe pas de tel chemin, le chemin renvoyé est vide.
pub fn chemin(pos1: Position, pos2: Position) -> Array<Direction>;

// Déplace le nain (standard) ``id_nain`` d'une case dans la direction choisie.
pub fn deplacer(id_nain: c_int, dir: Direction) -> Erreur;

// Le nain (standard) ``id_nain`` lâche la paroi.
pub fn lacher(id_nain: c_int) -> Erreur;

// Le nain (standard) ``id_nain`` s'agrippe à la paroi.
pub fn agripper(id_nain: c_int) -> Erreur;

// Le nain (standard) ``id_nain`` mine le bloc ou le nain (standard) dans la direction indiquée.
pub fn miner(id_nain: c_int, dir: Direction) -> Erreur;

// Le nain (standard) ``id_nain`` tire la corde dans le sens donné (HAUT ou BAS).
pub fn tirer(id_nain: c_int, dir_corde: Direction, sens: Direction) -> Erreur;

// Le nain (standard) ``id_nain`` pose une corde dans la direction indiquée.
pub fn poser_corde(id_nain: c_int, dir: Direction) -> Erreur;

// Affiche le drapeau spécifié sur la case indiquée.
pub fn debug_afficher_drapeau(pos: Position, drapeau: DebugDrapeau) -> Erreur;

// Renvoie le type d'une case donnée.
pub fn type_case(pos: Position) -> CaseType;

// Renvoie la liste de toutes les positions occupées par une corde dans la mine.
pub fn liste_cordes() -> Array<Position>;

// Indique si une corde se trouve sur une case donnée.
pub fn corde_sur_case(pos: Position) -> bool;

// Renvoie le numéro du joueur à qui appartienent les nains (standard) sur la case indiquée. Renvoie -1 s'il n'y a pas de nain (standard) ou si la position est invalide.
pub fn nain_sur_case(pos: Position) -> c_int;

// Renvoie la description du nain (standard) désigné par le numéro ``id_nain`` appartenant au joueur ``id_joueur``. Si le nain (standard)  n'est pas présent sur la carte, tous les membres de la structure ``nain`` renvoyée sont initialisés à -1 (et le champ ``accroche`` à `false`).
pub fn info_nain(id_joueur: c_int, id_nain: c_int) -> Nain;

// Renvoie la liste de tous les minerais dans la mine.
pub fn liste_minerais() -> Array<Position>;

// Renvoie la description d'un minerai en fonction d'une position donnée. Si le minerai n'est pas présent sur la carte, ou si la position est invalide, tous les membres de la structure ``minerai`` renvoyée sont initialisés à -1.
pub fn info_minerai(pos: Position) -> Minerai;

// Renvoie le nombre de points de déplacement que coûterai le déplacement d'un nain (standard) dans une direction donnée. Renvoie -1 si le déplacement n'est pas possible.
pub fn cout_de_deplacement(id_nain: c_int, dir: Direction) -> c_int;

// Renvoie la position de la taverne appartenant au joueur ``id_joueur``. Si le joueur n'existe pas, renvoie la position (-1, -1).
pub fn position_taverne(id_joueur: c_int) -> Position;

// Renvoie la liste des actions effectuées par l’adversaire durant son tour, dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans cette liste.
pub fn historique() -> Array<ActionHist>;

// Renvoie le score du joueur ``id_joueur``. Renvoie -1 si le joueur est invalide.
pub fn score(id_joueur: c_int) -> c_int;

// Renvoie votre numéro de joueur.
pub fn moi() -> c_int;

// Renvoie le numéro de joueur de votre adversaire.
pub fn adversaire() -> c_int;

// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à annuler ce tour ci.
pub fn annuler() -> bool;

// Retourne le numéro du tour actuel.
pub fn tour_actuel() -> c_int;

// Affiche le contenu d'une valeur de type case_type
pub fn afficher_case_type(v: CaseType);

// Affiche le contenu d'une valeur de type direction
pub fn afficher_direction(v: Direction);

// Affiche le contenu d'une valeur de type erreur
pub fn afficher_erreur(v: Erreur);

// Affiche le contenu d'une valeur de type action_type
pub fn afficher_action_type(v: ActionType);

// Affiche le contenu d'une valeur de type debug_drapeau
pub fn afficher_debug_drapeau(v: DebugDrapeau);

// Affiche le contenu d'une valeur de type position
pub fn afficher_position(v: Position);

// Affiche le contenu d'une valeur de type minerai
pub fn afficher_minerai(v: Minerai);

// Affiche le contenu d'une valeur de type nain
pub fn afficher_nain(v: Nain);

// Affiche le contenu d'une valeur de type action_hist
pub fn afficher_action_hist(v: ActionHist);

}
