/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>

using namespace std;

const int TAILLE_TOTAL = TAILLE_MINE * TAILLE_MINE;
const string endll = "\n";
const int ACTION_MINE = 1;
const int ACTION_ATTACK = 2;
const int ACTION_PULL_ROPE_UP = 4;
const int ACTION_PULL_ROPE_DOWN = 8;


typedef enum case_t {
    OBSI = -2,
    ROPE = -1,
    EMPTY = 0,
    // >1 = resistance
} case_t;

using board_t = int[TAILLE_TOTAL];

typedef struct dwarf_t {
    int life, pos, pa, pm, butin;
} dwarf_t;

typedef struct gamestate_t {
    board_t b;
    board_t earnings;

    dwarf_t me[NB_NAINS];
    dwarf_t him[NB_NAINS];

    int my_spawn;
    int his_spawn;
} gamestate_t;

typedef struct move_t {
    int dwarf_id;
    int pos; //move
    int action, action_pos; //mine, attack
    int cost_pm; //cost
    // int debug1, debug2;
} move_t;

const int UP = -TAILLE_MINE;
const int DOWN = TAILLE_MINE;


inline int min(int a, int b) { return a < b ? a : b;}
inline int abs(int x) { return x < 0 ? -x : x;}
int dist(int a, int b) {return abs((a - b) % TAILLE_MINE) + abs((a - b) / TAILLE_MINE);}
int from_position(position p) {return TAILLE_MINE * p.ligne + p.colonne;}

direction from_diff(int from, int to) {
    if(to % TAILLE_MINE > from % TAILLE_MINE) {
        return DROITE;
    }
    if(to % TAILLE_MINE < from  % TAILLE_MINE) {
        return GAUCHE;
    }
    if(to / TAILLE_MINE > from / TAILLE_MINE) {
        return BAS;
    }
    return HAUT;
}

void afficher_plateau(board_t& b, bool raw) {
    for(int y = 0 ; y < TAILLE_MINE ; y++) {
        for(int x = 0 ; x < TAILLE_MINE ; x++) {
            int v = b[y * TAILLE_MINE + x];
            if(!raw) {
                if(v == -1)
                    cout << "|";
                else if(v == 0)
                    cout << ".";
                else
                    cout << "X";
            } else {
                if ( v >= 50 ) {
                    cout << "x";
                } else if ( v < 0 ) { cout << "-"; } else {
                    cout << v / 5;
                }
            }
        }
        cout << endll;
    }
}
void afficher_gamestate(gamestate_t& g) {
    for(int y = 0 ; y < TAILLE_MINE ; y++) {
        for(int x = 0 ; x < TAILLE_MINE ; x++) {
            int v = g.b[y * TAILLE_MINE + x];
            for(int i = 0 ; i < NB_NAINS ; i++) {
                if (g.me[i].pos == y * TAILLE_MINE + x){
                    v = -3;
                }
            }
            
            if (v == -3) {
                cout << "M";
            }
            else if(v == -1)
                cout << "|";
            else if(v == 0)
                cout << ".";
            else
                cout << "X";
        }
        cout << endll;
    }
}

void afficher_pos(int p) {
    cout << "x: " << p % TAILLE_MINE << " y: " << p / TAILLE_MINE;
}

void afficher_dwarf_t(dwarf_t& dw) {
    cout <<  " butin is " << dw.butin<< endll;
    cout <<  " life is " << dw.life << endll;
    cout <<  " pa is " << dw.pa << endll;
    cout <<  " pm is " << dw.pm << endll;
    cout <<  " pos is ";
    afficher_pos(dw.pos);
    
    cout << endll;
}

void afficher_move_t(move_t& mv, gamestate_t& g) {
    cout << "me is " << api_moi() << endll;
    cout << "dwarf:    " << mv.dwarf_id << endll;
    afficher_dwarf_t(g.me[mv.dwarf_id]);
    cout << "pos:      ";
    afficher_pos(mv.pos);
    cout << endll;

    cout << "action:   " << mv.action << endll;
    cout << "actionpos:";
    afficher_pos(mv.action_pos);
    cout << endll;
    cout << "cost_pm:  " << mv.cost_pm << endll;
    // cout << "debug1:   " << mv.debug1 << endll;
    // cout << "debug2:   " << mv.debug2 << endll;
    // if(mv.debug2 > 0) {
    //     afficher_dwarf_t(g.him[mv.debug2]);
    // }
}

void copy_gamestate(gamestate_t& from, gamestate_t& dst) {
    for(int i = 0 ; i < TAILLE_TOTAL ; i++) {
        dst.b[i] = from.b[i];
        dst.earnings[i] = from.earnings[i];
    }
    for(int i = 0 ; i < NB_NAINS ; i++) {
        dst.him[i] = from.him[i];
        dst.me[i] = from.me[i];
    }
    dst.his_spawn = from.his_spawn;
    dst.my_spawn = from.my_spawn;
}

bool compare_nain(int i, dwarf_t& a, dwarf_t& b) {
    if((b.life <= 0) != (a.life <= 0)) {
        cout << "Nain " << i << " life is " << a.life << " != " << b.life << endll;
        return false;
    } else if (b.life < 0 || a.life < 0) {
        return true;
    }

    if(a.butin != b.butin) {
        cout << "Nain " << i << " butin is " << a.butin << " != " << b.butin << endll;
        return false;

    }
    if(a.life != b.life) {
        cout << "Nain " << i << " life is " << a.life << " != " << b.life << endll;
        return false;
    }
    if(a.pa != b.pa) {
        cout << "Nain " << i << " pa is " << a.pa << " != " << b.pa << endll;
        return false;
    }
    if(a.pm != b.pm) {
        cout << "Nain " << i << " pm is " << a.pm << " != " << b.pm << endll;
        return false;
    }
    if(a.pos != b.pos) {
        cout << "Nain " << i << " pos is ";
        afficher_pos(a.pos);
        cout << " != ";
        afficher_pos(b.pos);
        cout << endll;
        return false;
    }
    return true;
}

bool compare_gamestates(gamestate_t& a, gamestate_t& b) {
    for(int i = 0 ; i < TAILLE_MINE ; i++) {
        if (a.b[i] != b.b[i]) {
            cout << "Board diff at index " << i << " a: " << a.b[i] << " != " << b.b[i] << endll;
            return false;
        }
        if (a.earnings[i] != b.earnings[i]) {
            cout << "Earnings diff at index " << i << " a: " << a.earnings[i] << " != " << b.earnings[i] << endll;
            return false;
        }
    }
    for(int i = 0 ; i < NB_NAINS ; i++) {
        if (!compare_nain(i, a.me[i], b.me[i])) {
            return false;
        }
        if (!compare_nain(i, a.him[i], b.him[i])) {
            return false;
        }
    }
    return true;
}

void fill_board(board_t& b, int v) {
    for(int i = 0 ; i < TAILLE_TOTAL ; i++) {
        b[i] = v;
    }
}

void init_board(board_t& b) {
    fill_board(b, 0);
}

inline int down_ray(board_t& board, int p) {
    int k = 0;
    while(board[p] <= 0 && p < TAILLE_MINE*TAILLE_MINE) {
        p += DOWN;
        k++;
    }
    k--;
    return k;
}

int neighs(board_t& board, int pos, int* moves) {
    int ptr = 0;
    if(pos % TAILLE_MINE > 0) {
        moves[ptr++] = pos-1;
        int d = down_ray(board, pos-1);
        if(d >= 1 && d < 4) {
            moves[ptr++] = pos-1+DOWN*d;
        }
    }
    if(pos % TAILLE_MINE < TAILLE_MINE-1) {
        moves[ptr++] = pos+1;
        int d = down_ray(board, pos+1);
        if(d >= 1 && d < 4) {
            moves[ptr++] = pos+1+DOWN*d;
        }
    }
    if(pos >= TAILLE_MINE) {
        moves[ptr++] = pos+UP;
    }
    if(pos < TAILLE_MINE*(TAILLE_MINE-1)) {
        moves[ptr++] = pos+DOWN;
    }
    int d = down_ray(board, pos);
    if(d > 1 && d <= 4) {
        moves[ptr++] = pos+DOWN*d;
    }

    return ptr;
}

const int MAXDIST = 300;
const int MAX_SAME_TIME = 100;

short NEXT[MAXDIST * MAX_SAME_TIME];
int NEXT_ptrs[MAXDIST];

bool check_dessous(int p, board_t& b) {
    if(p >= TAILLE_MINE*(TAILLE_MINE-1))
        return true;
    else
        return b[p+TAILLE_MINE] > 0 || b[p+TAILLE_MINE] == OBSI;
}

void djikstra(board_t& board, int start, board_t& results, board_t& back_board) {
    std::array<bool, TAILLE_TOTAL> visited;
    for(int i = 0 ; i < TAILLE_TOTAL ; i++) {
        visited[i] = board[i] == OBSI;
        results[i] = 100000;
        back_board[i] = -1;
    }

    for(int i = 0 ; i < MAXDIST ; i++) {
        NEXT_ptrs[i] = 0;
    }

    results[start] = 0;
    NEXT_ptrs[0] = 1;
    NEXT[0] = start;

    int fastneighs[8];
    

    for(int d = 0 ; d < MAXDIST ; d++) {
        for(int i = 0 ; i < NEXT_ptrs[d] ; i++) {
            short p = NEXT[d * MAX_SAME_TIME + i];
            bool p_dessous = check_dessous(p, board);

            if (visited[p]) {
                continue;
            }

            visited[p] = true;
            int s = neighs(board, p, fastneighs);

            for(int x = 0 ; x < s ; x ++) {
                int nei = fastneighs[x];
                int v_nei = board[nei];
                bool dessous = check_dessous(nei, board);

                int new_d;
                if (dist(nei, p) > 1) {
                    new_d = d + 2 - (p_dessous);
                } else if (v_nei == ROPE) {
                    new_d = d + 1;
                } else if (v_nei == EMPTY) {
                    new_d = d + 2 - (dessous && p_dessous);
                } else {
                    new_d = NB_POINTS_DEPLACEMENT * (d / NB_POINTS_DEPLACEMENT + v_nei);
                }

                if(results[nei] <= new_d || new_d >= MAXDIST || v_nei == OBSI) {
                    continue;
                }
                //cout << "i: " << i << " p: " << p << " d: " << d << " -> new_d: " << new_d << " nei: " << nei << endll;

                back_board[nei] = p;
                results[nei] = new_d;
                NEXT[new_d * MAX_SAME_TIME + NEXT_ptrs[new_d]] = nei;
                NEXT_ptrs[new_d]++;
            }
        }
    }
}

void test_djikstra() {
    board_t test, results, dual;
    fill_board(test, 1);
    for(int i = 0 ; i < TAILLE_MINE ; i++) {
        test[i * TAILLE_MINE + TAILLE_MINE/2] = ROPE;
    }
    djikstra(test, 0, results, dual);
    afficher_plateau(test, false);
    afficher_plateau(results, true);
    afficher_plateau(dual, true);
}

int getCible(dwarf_t& dw, gamestate_t& g, board_t& results, board_t& results_spawn, float& maxScore) {
    int bestpos = -1;
    for(int j = 0 ; j < TAILLE_TOTAL ; j++) {
        if(g.earnings[j] == 0) {
            continue;
        } 

        int thune = min(25, g.earnings[j]+dw.butin);
        float d = results[j] + results_spawn[j] + dist(j, dw.pos) / 2.0;

        
        if ((d - 2)/ 5 + api_tour_actuel() >= NB_TOURS) {
            continue;
        }

        float s = float(thune) / d;
        if(s > maxScore) {
            maxScore = s;
            bestpos = j;
        }
    }
    if(bestpos == -1) {
        cout << "no interesting pos found" << endll;
    } else  {
        afficher_pos(bestpos);
        int thune = min(25, g.earnings[bestpos]+dw.butin);
        int d = results[bestpos] + results_spawn[bestpos] + dist(bestpos, dw.pos) / 2;
        float s = float(thune) / d;
        cout << " thune: " << thune << " dist: " << d << " = " << results[bestpos] << " + " << results_spawn[bestpos] << " " << " s: " << s << endl;
        afficher_plateau(results, true);
    }
    return bestpos;
}

// Idee de scoring plateau
//  Defense: peut etre tue
//  Attaque: Peut tuer cible
//  Minage: Proche de cible (mine ou taverne)
//  Vie: Plus la vie est faible, plus le butin est important

float score_plateau(gamestate_t& g) {
    float score = 0;

    board_t results[NB_NAINS];
    board_t results_spawn;
    board_t dual;

    djikstra(g.b, g.my_spawn, results_spawn, dual);

    for(int i = 0 ; i < NB_NAINS ; i++) {
        dwarf_t& me = g.me[i];
        if(me.life <= 0) {
            continue;
        }

        djikstra(g.b, me.pos, results[i], dual);

        if(me.butin > 12) {
            score += 1.0 / (results_spawn[me.pos] + float(dist(me.pos, g.my_spawn)) / 10.0);
        } else {
            float s=0;
            getCible(me, g, results[i], results_spawn, s);
            score += s;
        }

    }
    return score;

}

bool generate_move(int dw_id, gamestate_t& g, board_t& results, board_t& dual, int to, move_t& ye) {
    if (to < 0) {
        return false;
    }
    dwarf_t& dw = g.me[dw_id];

    int e = to;
    int l = to;
    while(results[e] > dw.pm || !(g.b[e] == EMPTY || g.b[e] == ROPE)) {
        l = e;
        e = dual[e];
    }

    ye.cost_pm = results[e];
    ye.dwarf_id = dw_id;
    ye.pos = e;
    ye.action = 0;
    ye.action_pos = -1;

    if(g.b[l] > 0) {
        ye.action = ACTION_MINE;
        ye.action_pos = l;
    }
    for (int i = 0 ; i < NB_NAINS ; i++) {
        if(g.him[i].pos == l && g.him[i].life > 0) {
            ye.action = ACTION_ATTACK;
            ye.action_pos = l;
            break;
        }
    }

    if(dw.pa < 6 && ye.action > 0) {
        ye.action = 0;
    }
    if(ye.action == 0 && ye.pos == dw.pos) {
        return false;
    }

    return true;
}

// Idees de coup
// Aller miner un truc
// Aller vers la tavesrne
// Aller taper des trucs proche

std::vector<move_t> generate_moves(gamestate_t& g) {
    std::vector<move_t> moves;
    board_t results_spawn, duall;

    djikstra(g.b, g.my_spawn, results_spawn, duall);

    for(int dwarf = 0 ; dwarf < NB_NAINS ; dwarf++) {
        if(g.me[dwarf].life <= 0) {
            continue;
        }
        board_t results, dual;

        //afficher_plateau(g.b, true);

        djikstra(g.b, g.me[dwarf].pos, results, dual);
        
        //afficher_plateau(results, true);

        // Aller taper un mec
        int closestDist = 300;
        int closestId = -1;
        for(int ennemi_dwarf = 0 ; ennemi_dwarf < NB_NAINS ; ennemi_dwarf++) {
            if (g.him[ennemi_dwarf].life <= 0)
                continue;
            int p = g.him[ennemi_dwarf].pos;
            int d = results[p];
            if (d < closestDist) {
                closestDist = d;
                closestId = ennemi_dwarf;
            }            
        }
        if(closestId != -1) {
            move_t mv;
            
            if (generate_move(dwarf, g, results, dual, g.him[closestId].pos, mv)) {
                moves.push_back(mv);
            }
        }
        move_t mv;
        if (generate_move(dwarf, g, results, dual, g.my_spawn, mv)) {
            moves.push_back(mv);
        }
        move_t mv2;
        float f=0;
        int i = getCible(g.me[dwarf], g, results, results_spawn, f);

        //std::cout << "cible is " << i << " with butin: " << g.me[dwarf].butin << endll;
        if (generate_move(dwarf, g, results, dual, i, mv2)) {
            moves.push_back(mv2);
        }
    }

    return moves;
}

void apply_move(gamestate_t& g, move_t& mv) {
    dwarf_t& dw = g.me[mv.dwarf_id];
    swap(dw.pos, mv.pos);
    dw.pm -= mv.cost_pm;
    
    if(mv.action != 0) {
        dw.pa = 0;
    }
    if(mv.action == ACTION_MINE) {
        g.b[mv.action_pos] -= 1;
        if(g.b[mv.action_pos] == 0) {
            dw.butin += g.earnings[mv.action_pos];
        }
    }
    if(mv.action == ACTION_ATTACK) {
        g.b[mv.action_pos] -= 1;
        for(int i = 0 ; i < NB_NAINS ; i++) {
            if(g.him[i].pos == mv.action_pos) {
                g.him[i].life -= DEGAT_PIOCHE;
                if (g.him[i].life <= 0 && g.him[i].life > -DEGAT_PIOCHE) {
                    dw.butin += g.him[i].butin;
                }
            }
        }
    }
}

void undo_move(gamestate_t& g, move_t& mv) {
    dwarf_t& dw = g.me[mv.dwarf_id];
    swap(dw.pos, mv.pos);
    dw.pm += mv.cost_pm;
    if(mv.action == ACTION_ATTACK) {
        g.b[mv.action_pos] += 1;
        for(int i = 0 ; i < NB_NAINS ; i++) {
            if(g.him[i].pos == mv.action_pos) {
                if (g.him[i].life <= 0 && g.him[i].life > -DEGAT_PIOCHE) {
                    dw.butin -= g.him[i].butin;
                }
                g.him[i].life += DEGAT_PIOCHE;
            }
        }
    }
    if(mv.action == ACTION_MINE) {
        if(g.b[mv.action_pos] == 0) {
            dw.butin -= g.earnings[mv.action_pos];
        }
        g.b[mv.action_pos] += 1;
    }
    if(mv.action != 0) {
        dw.pa = 6;
    }
}

void parse_gamestate(gamestate_t& g) {
    position pos = api_position_taverne(api_moi());
    g.my_spawn = from_position(pos);

    position pos2 = api_position_taverne(api_adversaire());
    g.his_spawn = from_position(pos2);

    for (int i = 0 ; i < TAILLE_TOTAL ; i++) {
        g.earnings[i] = 0;
        position p;
        p.colonne = i % TAILLE_MINE;
        p.ligne = i / TAILLE_MINE;
        case_type t = api_type_case(p);

        switch(t) {
        case GRANITE:
            {
                minerai t2 = api_info_minerai(p);
                if(t2.rendement == -1) {
                    g.b[i] = 1;
                } else {
                    g.b[i] = t2.resistance;
                    g.earnings[i] = t2.rendement;
                }
            }
            break;
        case LIBRE:
            g.b[i] = EMPTY;
            break;
        case OBSIDIENNE:
            g.b[i] = OBSI;
            break;
        default:
            break;
        }
    }
    for (position& x : liste_cordes()) {
        g.b[from_position(x)] = ROPE;
    }
    for (int i = 0 ; i < NB_NAINS ; i++) {
        nain me = info_nain(api_moi(), i);
        g.me[i].butin = me.butin;
        g.me[i].life = me.vie;
        g.me[i].pa = me.pa;
        g.me[i].pm = me.pm;
        g.me[i].pos = from_position(me.pos);

        nain him = info_nain(api_adversaire(), i);
        g.him[i].butin = him.butin;
        g.him[i].life = him.vie;
        g.him[i].pa = him.pa;
        g.him[i].pm = him.pm;
        g.him[i].pos = from_position(him.pos);
        if(g.him[i].life > 0) {
            g.b[g.him[i].pos] = max(g.b[g.him[i].pos], 1 + (him.vie -1) / DEGAT_PIOCHE);
        }
    }
}

void play_move(gamestate_t& g, const move_t& mv) {
    board_t results, dual;
    int start_pos = g.me[mv.dwarf_id].pos;
    djikstra(g.b, start_pos, results, dual);

    std::vector<int> pos_list;
    int p = mv.pos;

    while(p != start_pos) {
        pos_list.push_back(p);
        p = dual[p];
    }
    //cout << "mv size " << pos_list.size() << endll;
    int last_pm = 0;
    int last_pos = start_pos;

    for(int i = pos_list.size() - 1; i >= 0 ; i--) {
        int new_pos = pos_list[i];
        int diff_pm = results[new_pos] - last_pm;
        int d = dist(new_pos, last_pos);

        if(diff_pm == 1 && g.b[new_pos] != ROPE) {
            api_lacher(mv.dwarf_id);
        } else {
            api_agripper(mv.dwarf_id);
        }

        // cout << " from ";
        // afficher_pos(last_pos);
        // cout << " -> ";
        // afficher_pos(new_pos);
        // cout << " cost: ";
        // cout << diff_pm << endll;

        erreur e = api_deplacer(mv.dwarf_id, from_diff(last_pos, new_pos));
        if (e != OK) {
            cout << "play_move Erreur pdt le deplacement " << e << " de ";
            afficher_pos(last_pos);
            cout << " a ";
            afficher_pos(new_pos);
            cout << " err: " << e << endll;
        }
        if(d > 1) {
            api_lacher(mv.dwarf_id);
        }

        last_pm = results[new_pos];
        last_pos = new_pos;
    }
    for(int i = 0 ; i < NB_NAINS ; i++) {
       api_agripper(i);
    }

    if(mv.action == ACTION_ATTACK || mv.action == ACTION_MINE) {
        api_miner(mv.dwarf_id, from_diff(mv.pos, mv.action_pos));
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
    gamestate_t g;
    parse_gamestate(g);
    while(true) {
        // cout << "--" << endll;
        float best_score = 0;
        move_t best_move;

        bool ok = false;
        float baseline = score_plateau(g);
            afficher_gamestate(g);
            std::cout << "baseline: " << baseline << endl;

        
        debug_drapeau x = DRAPEAU_ROUGE;
        if(api_moi() == 1) {
            x = DRAPEAU_BLEU;
        }
        position y;
        y.colonne = 0;
        y.ligne = 0;
        debug_afficher_drapeau(y, x);


        for (move_t& mv : generate_moves(g)) {
                cout << " --> debug this move " << endll;
                afficher_move_t(mv, g);
            gamestate_t tmp;
            copy_gamestate(g, tmp);
            apply_move(g, mv);
            float f = score_plateau(g) - baseline;
            undo_move(g, mv);

                cout << "final score:  " << f << endll;
                cout << " <-- " << endll;

            if (!compare_gamestates(g, tmp)) {
                cout << "At generation" << endl;
            }

            if(f > best_score) {
                best_move = mv;
                best_score = f;
                ok = true;
            }
        }

        if(!ok) {
            break;
        }

        //afficher_move_t(best_move, g);
        play_move(g, best_move);
        apply_move(g, best_move);
        
        gamestate_t tmp;
        parse_gamestate(tmp);
        if (!compare_gamestates(g, tmp)) {
            cout << "At parsing" << endl;
            return;
        }
    }
}

/// Fonction appelée au début de la partie.
void partie_init()
{

}
/// Fonction appelée à la fin de la partie.
void partie_fin()
{

}
