/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb
#include "prologin.hh"
#include <ctime>
#include <iostream>

#define AGENT_MOI 3
#define AGENT_LUI 4
#define POUSSER_FLAG 2048
#define NULLMOVE_FLAG 4096

typedef int plateau[625];
typedef struct {
	int pos;
	int start;
	int cout;
	int flags; // Les premiers bits du flag peuvent contenir de l'information, comme la direction a pousser
} move_t;

alien_info aliens_pos[625];
std::vector<alien_info> aliens_list;

typedef struct {
	plateau p;
	
	int agents_moi[4];
	int agents_lui[4];
	int agents_PA[4];
	
	plateau cap;
	
	int score_moi, score_lui;
	int tour;
} gamestate;

direction directions[4] = {NORD, EST, SUD, OUEST};

void dist_to_cases(plateau& pla, int pos_start, plateau& result, plateau& dual_graph);

inline int from_position(position& pos) {
	return pos.ligne * 25 + pos.colonne;
}

inline int abs(int x) {
	return x < 0 ? -x : x;
}

int l1_dist(int pos, int pos2) {
	return abs(pos%25 - pos2%25) + abs(pos/25-pos2/25);
}

bool est_capturable(alien_info& alien, int tour, int cap) {
	return cap != NB_TOURS_CAPTURE && (alien.tour_invasion <= tour && alien.duree_invasion + alien.tour_invasion + cap - 3 > tour);
}

bool cmp_plateau(plateau& p1, plateau& p2) {
	for(int i = 0 ; i < 625 ; i++) {
		if(p1[i] != p2[i])
			return false;
	}
	return true;
}

void afficher_raw(plateau& p) {
	for(int y = 0 ; y < 25 ; y++) {
		for(int x = 0 ; x < 25 ; x++) {
			int v = p[y*25+x];
			if(v < 10)
				printf("%d   ", v);
			else if(v < 100)
				printf("%d  ", v);
			else if(v < 1000)
				printf("%d ", v);
			else
				printf("%d..", v/100);
		}
		printf("\n");
	}
}

int pousser_res(plateau& p, int pos, direction dir) {
	int c = pos % 25;
	int l = pos / 25;
	if(dir == EST) {
		int dec = 1;
		while(c+dec < 25 && p[pos+dec] <= 0) {
			dec += 1;
		}
		dec -= 1;
		return pos+dec;
	}
	if(dir == OUEST) {
		int dec = 1;
		while(c-dec >= 0&& p[pos-dec] <= 0) {
			dec += 1;
		}
		dec -= 1;
		return pos-dec;
	}
	if(dir == NORD) {
		int dec = 1;
		while(l-dec >= 0 && p[pos-25*dec] <= 0) {
			dec += 1;
		}
		dec -= 1;
		return pos-25*dec;
	}
	if(dir == SUD) {
		int dec = 1;
		while(l+dec < 25 && p[pos+25*dec] <= 0) {
			dec += 1;
		}
		dec -= 1;
		return pos+25*dec;
	}
	return -156;
}

direction diff_to_direction(int diff) {
	if(diff > 0) {
		if(diff < 25)
			return EST;
		return SUD;
	} else {
		if(diff > -25) {
			return OUEST;
		}
		return NORD;
	}
}

void appliquer_move(gamestate& g, move_t& mv) {
	int val = g.p[mv.start];
	g.p[mv.start] = 0;
	g.p[mv.pos] = val;
	if(val == AGENT_MOI) {
		for(int i = 0 ; i < 4 ; i++) {
			if(g.agents_moi[i] == mv.start) {
				g.agents_moi[i] = mv.pos;
				g.agents_PA[i] -= mv.cout;
			}
		}
	}
	if(val == AGENT_LUI) {
		for(int i = 0 ; i < 4 ; i++) {
			if(g.agents_lui[i] == mv.start) {
				g.agents_lui[i] = mv.pos;
				g.agents_PA[i] -= mv.cout;
			}
		}
	}
	if((mv.flags & POUSSER_FLAG) > 0) {
		int to_push = mv.flags & 1023; // Premiers bits
		int res = pousser_res(g.p, to_push, diff_to_direction(to_push - mv.pos));
		int pushed_id = g.p[to_push];
		g.p[to_push] = 0;
		g.p[res] = pushed_id;
		if(pushed_id == AGENT_MOI) {
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_moi[i] == to_push) {
					g.agents_moi[i] = res;
				}
			}
		}
		if(pushed_id == AGENT_LUI) {
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_lui[i] == to_push) {
					g.agents_lui[i] = res;
				}
			}
		}
	}
}

void annuler_move(gamestate& g, move_t& mv) {
	int val = g.p[mv.pos];
	g.p[mv.pos] = 0;
	g.p[mv.start] = val;
	if(val == AGENT_MOI) {
		for(int i = 0 ; i < 4 ; i++) {
			if(g.agents_moi[i] == mv.pos) {
				g.agents_moi[i] = mv.start;
				g.agents_PA[i] += mv.cout;
			}
		}
	}
	if(val == AGENT_LUI) {
		for(int i = 0 ; i < 4 ; i++) {
			if(g.agents_lui[i] == mv.pos) {
				g.agents_lui[i] = mv.start;
				g.agents_PA[i] += mv.cout;
			}
		}
	}
	if((mv.flags & POUSSER_FLAG) > 0) {
		int to_push = mv.flags & 1023; // Premiers bits
		direction dir = diff_to_direction(to_push - mv.pos);
		int res = pousser_res(g.p, to_push, dir);
		if(g.p[res] > 2) {
			return;
		}
		if(dir == EST) {
			res += 1;
		}
		if(dir == OUEST) {
			res -= 1;
		}
		if(dir == NORD) {
			res -= 25;
		}
		if(dir == SUD) {
			res += 25;
		}
		int pushed_id = g.p[res];
		g.p[res] = 0;
		g.p[to_push] = pushed_id;
		if(pushed_id == AGENT_MOI) {
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_moi[i] == res) {
					g.agents_moi[i] = to_push;
				}
			}
		}
		if(pushed_id == AGENT_LUI) {
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_lui[i] == res) {
					g.agents_lui[i] = to_push;
				}
			}
		}
	}
}
int deplacer_agent_api(int agent_id, int start, int dst, plateau& dual_graph) {
	int len = 0;
	std::vector<int> pos_succ = std::vector<int>();
	while(dst != start) {
		pos_succ.push_back(dst);
		len += 1;
		dst = dual_graph[dst];
	}
	for(int i = 0 ; i < len ; i++) {
		int next = pos_succ.back();
		pos_succ.pop_back();
		int diff = next-start;
		//printf("I should be at %d-%d --> %d-%d diff: %d\n", start%25, start/25, next%25, next/25, diff);
		if(diff == 1) {
			if(deplacer(agent_id, EST) != OK) { printf("Err trying to move\n"); break; }
		} else if(diff == -1) {
			if(deplacer(agent_id, OUEST) != OK) { printf("Err trying to move\n"); break; }
		} else if(diff == 25) {
			if(deplacer(agent_id, SUD) != OK) { printf("Err trying to move\n"); break; } // TODO Potentiel inversion ici
		} else if(diff == -25) {
			if(deplacer(agent_id, NORD) != OK) { printf("Err trying to move\n"); break; }
		} else if(diff > 0 && diff < 25) {
			if(glisser(agent_id, EST) != OK) { printf("Err trying to move\n"); break; }
		} else if(diff < 0 && diff > -25) {
			if(glisser(agent_id, OUEST) != OK) { printf("Err trying to move\n"); break; }
		} else if(diff > 0) {
			if(glisser(agent_id, SUD) != OK) { printf("Err trying to move\n"); break; }
		} else  {
			if(glisser(agent_id, NORD) != OK) { printf("Err trying to move\n"); break; }
		}
		start = next;
	}
	return start;
}

void afficher_plateau(plateau& p, bool afficher_aliens, int tour) {
	for(int y = 0 ; y < 25 ; y++) {
		for(int x = 0 ; x < 25 ; x++) {
			char c;
			int v = p[y*25+x];
			switch(v) {
				case LIBRE:
					c = '.';
					break;
				case MUR:
					c = '*';
					break;
				case AGENT_LUI:
					c = 'E';
					break;
				case AGENT_MOI:
					c = 'M';
					break;
				default:
					c = ' ';
					break;
			}
			if(c == ' ') {
				printf("ERREUR: Carte corrompue\n");
			}
			if(afficher_aliens) {
				alien_info alien = aliens_pos[y*25+x];
				if(est_capturable(alien, tour, alien.capture_en_cours)) {
					if(c == '.') {
						c = 'a';
					}
				}
			}
			printf("%c", c);
		}
		printf("\n");
	}
}
void jouer_coup(gamestate& g, move_t& mv) {
	int agent_id = -1;
	for(int i = 0 ; i < 4 ; i++) {
		if(g.agents_moi[i] == mv.start) {
			agent_id = i;
			break;
		}
	}
	if(agent_id == -1) {
		return;
	}

	plateau res, dual;
	dist_to_cases(g.p, mv.start, res, dual);
	int end = deplacer_agent_api(agent_id, mv.start, mv.pos, dual);
	
	if(end != mv.pos) {
		afficher_plateau(g.p, true, g.tour);
		for(int i = 0 ; i < 4 ; i++) {
			printf("%d ", g.agents_PA[i]);
		}
		printf(" %d\n", agent_id);
		printf("Something is wrong !!!!!!!\n");
	}

	if((mv.flags & POUSSER_FLAG) > 0) {
		int to_push = mv.flags & 1023; // Premiers bits
		int res = pousser(agent_id, diff_to_direction(to_push - mv.pos));
		if(res != OK) {
			printf("POUSSER FAILED !!! Something is wrong !! err code: %d\n", res);
		}
	}
}


std::vector<int> gen_sides(plateau& p, int pos) {
	std::vector<int> mv = std::vector<int>();
	int c = pos%25;
	int l = pos/25;
	
	// positions adjaceantes
	if(c != 0) {
		mv.push_back(pos-1);
	}
	if(c != 24) {
		mv.push_back(pos+1);
	}
	if(l != 0) {
		mv.push_back(pos-25);
	}
	if(l != 24) {
		mv.push_back(pos+25);
	}
	return mv;
}

void gen_mouvements(plateau& p, int pos, int* moves) {
	std::vector<int> mv = std::vector<int>();
	int c = pos%25;
	int l = pos/25;
	int ptr = 0;
	
	// positions adjaceantes
	if(c != 0) {
		moves[ptr++] = pos-1;
	}
	if(c != 24) {
		moves[ptr++] = pos+1;
	}
	if(l != 0) {
		moves[ptr++] = pos-25;
	}
	if(l != 24) {
		moves[ptr++] = pos+25;
	}
	//glissade a droite
	int dec = 1;
	while(c+dec < 25 && p[pos+dec] <= 0) {
		dec += 1;
	} 
	dec -= 1;
	if(dec >= 3) {
		moves[ptr++] = (pos+dec) | 2048;
	}
	
	//glissade a gauche
	dec = 1;
	while(c-dec >= 0 && p[pos-dec] <= 0) {
		dec += 1;
	} 
	dec -= 1;
	if(dec >= 3) {
		moves[ptr++] = (pos-dec) | 2048;
	}
	
	//glissade en haut
	dec = 1;
	while(l-dec >= 0 && p[pos-25*dec] <= 0) {
		dec += 1;
	} 
	dec -= 1;
	if(dec >= 3) {
		moves[ptr++] = (pos-25*dec) | 2048;
	}
	
	//glissade en bas
	dec = 1;
	while(l+dec < 25 && p[pos+25*dec] <= 0) {
		dec += 1;
	} 
	dec -= 1;
	if(dec >= 3) {
		moves[ptr++] = (pos+25*dec) | 2048;
	}
	moves[ptr] = -1;
}

#define MAX_DIST 350
#define MAX_SAME_DIST 200
// ^ can be 625 if problems
int prio_queue[MAX_DIST*MAX_SAME_DIST];
int pointers[MAX_DIST];
	
std::clock_t st_temps;

inline void prio_push_back(int queue, int pos) {
	prio_queue[queue+pointers[queue]*MAX_DIST] = pos;
	pointers[queue] += 1;
}

inline int prio_pop_back(int queue) {
	pointers[queue] -= 1;
	return prio_queue[queue+pointers[queue]*MAX_DIST];
}

void dist_to_cases(plateau& pla, int pos_start, plateau& result, plateau& dual_graph) {
	for(int i = 0 ; i < 625 ; i++) {
		result[i] = 1000;
	}
	result[pos_start] = 0;
	
	prio_push_back(0, pos_start);
	int t = 0;
	int left = 1;
	int moves[9];
		
	while(left > 0) {
		int p = prio_pop_back(t);
		gen_mouvements(pla, p, moves);
	
		for(int m_id = 0 ; m_id < 8 ; m_id++) {
			int move = moves[m_id];
			if(move < 0)
				break;
			int t_arrival = 1 + result[p];
			if((move & 2048) > 0) {
				int reste = 8-(result[p]%8);
				if(reste >= 3)
					reste = 0;
				t_arrival += 2 + reste;
				move -= 2048;
			}
			if(pla[move] > 0) {
				if(t_arrival - 1 < result[move]) {
					result[move] = t_arrival - 1;
					dual_graph[move] = p;
				}
				continue;
			}
			if(t_arrival < result[move] && t_arrival < MAX_DIST) {
				result[move] = t_arrival;
				dual_graph[move] = p;
				prio_push_back(t_arrival, move);
			}
		}
		left -= 1;
		while(left == 0 && t < MAX_DIST - 1) {
			t += 1;
			left = pointers[t];
		}
	}
}

inline bool is_safe(gamestate& g, int pos) {
	int c = pos%25;
	int l = pos/25;
	int v = 0;
	int h = 0;
	// positions adjaceantes
	if(c != 0) {
		h += g.p[pos-1] > 0;
	}
	if(c != 24) {
		v += g.p[pos+1] > 0;
	}
	if(l != 0) {
		h += g.p[pos-25] > 0;
	}
	if(l != 24) {
		v += g.p[pos+25] > 0;
	}
	return h > 0 && v > 0;
}

float coeff_points = 1.0f;
float coeff_capture = 0.33f;
float coeff_dist_score = 0.005f;
float coeff_presence = 0.001f;
float coeff_kickable = 0.15f;

float score_state(gamestate& g) {
	plateau dists_moi[4];
	plateau dists_lui[4];

	plateau dual;
	for(int i = 0 ; i < 4 ; i++) {
		dist_to_cases(g.p, g.agents_moi[i], dists_moi[i], dual);
		dist_to_cases(g.p, g.agents_lui[i], dists_lui[i], dual);
	}
	
	float presence = 0;
	for(alien_info& al : aliens_list) {
		int i = from_position(al.pos);
		int u = 0;
		int val = g.p[i];
		if(val == AGENT_LUI) {
			u = -1;
		} else if(val == AGENT_MOI) {
			u = 1;
		} else {
			int min = 1000;
			u = 1;
			for(int j = 0 ; j < 4 ; j++) {
				if(dists_moi[j][i] < min) {
					min = dists_moi[j][i];
				}
			}
			for(int j = 0 ; j < 4 ; j++) {
				if(dists_lui[j][i] == min) {
					u = 0;
				}
				if(dists_lui[j][i] < min) {
					u = -1;
					break;
				}
			}
		}
		presence += u * al.points_capture / (1 + abs(al.tour_invasion + al.duree_invasion / 2 - g.tour));
	}
	
	float points_score = g.score_moi - g.score_lui;
	
	float capture_score = 0;
	bool at_least_one_cap = false;
	for(int i = 0 ; i < 4 ; i++) {
		alien_info al = aliens_pos[g.agents_moi[i]];
		if(est_capturable(al, g.tour, g.cap[g.agents_moi[i]])) {
			at_least_one_cap = true;
			capture_score += al.points_capture * (1 + g.cap[g.agents_moi[i]]);
			bool coin = is_safe(g, from_position(al.pos));
			if(!coin) {
				for(int j = 0 ; j < 4 ; j++) {
					if(dists_lui[j][g.agents_moi[i]] <= 3) {
						capture_score -= al.points_capture * coeff_kickable;
						break;
					}
				}
			}
		}
	}
	for(int i = 0 ; i < 4 ; i++) {
		alien_info al = aliens_pos[g.agents_lui[i]];
		if(est_capturable(al, g.tour, g.cap[g.agents_lui[i]])) {
			at_least_one_cap = true;
			capture_score -= al.points_capture * (1 + g.cap[g.agents_lui[i]]);
		}
	}
	if(!at_least_one_cap) {
		coeff_presence = 0.1f;
	}
	float dist_score = 0;
	
	for(alien_info& al : aliens_list) {
		int al_pos = from_position(al.pos);
		if(est_capturable(al, g.tour, 0) && !(g.p[al_pos] > 2 && g.cap[al_pos] == 2)) {
			int min_dist = 100;
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_moi[i] != al_pos && est_capturable(aliens_pos[g.agents_moi[i]], g.tour, g.cap[g.agents_moi[i]]))
					continue;
				int t_d = dists_moi[i][al_pos];
				if(t_d < min_dist) {
					min_dist = t_d;
				}
			}
			int min_dist_e = 100;
			for(int i = 0 ; i < 4 ; i++) {
				if(g.agents_lui[i] != al_pos && est_capturable(aliens_pos[g.agents_lui[i]], g.tour, g.cap[g.agents_lui[i]]))
					continue;
				int t_d = dists_lui[i][al_pos];
				if(t_d < min_dist_e) {
					min_dist_e = t_d;
				}
			}
			dist_score += ((min_dist_e/8 - min_dist / 8)*2 + (min_dist_e - min_dist)) * al.points_capture;
		}
	}
	return points_score * coeff_points + capture_score * coeff_capture + dist_score * coeff_dist_score + presence * coeff_presence;
}

void init_plateau(plateau& p) {
	for(int i = 0 ; i < 625 ; i++) {
		p[i] = 0;
	}
}

std::vector<move_t> gen_push_moves(gamestate& state, int side) {
	std::vector<move_t> good_moves = std::vector<move_t>();
	int LUI = (side == api_moi()) ? AGENT_LUI : AGENT_MOI;
	for(int i = 0 ; i < 4 ; i++) {
		if(state.agents_PA[i] == 0)
			continue;
		int pos = (side == api_moi()) ? state.agents_moi[i] : state.agents_lui[i];
		plateau res, dual;
		dist_to_cases(state.p, pos, res, dual);
		
		for(alien_info& al : aliens_list) { // A cote de lalien
			int al_pos = from_position(al.pos);
			int t_dist = res[al_pos]/8; 
			if(est_capturable(al, state.tour+t_dist, state.cap[al_pos]) && state.p[al_pos] > 0) {
				for(int m : gen_sides(state.p, al_pos)) {
					if(state.p[m] > 0 && m != pos)
						continue;
					int to_add = m;
					while(res[to_add] > state.agents_PA[i]) {
						to_add = dual[to_add];
					}
					move_t mv;
					mv.flags = 0;
					if(state.p[al_pos] == LUI && res[m] <= 3-8+state.agents_PA[i]) { // On ne vient pas pour rien, on vient pour pousser si on est suffisamment pres
						//printf("dist %d PA %d\n", res[m], state.agents_PA[i]);
						mv.flags = POUSSER_FLAG | al_pos;
					}
					mv.pos = to_add;
					mv.start = pos;
					mv.cout = res[to_add] + (((mv.flags & POUSSER_FLAG) > 0) ? 5 : 0);
					if((mv.flags & POUSSER_FLAG) > 0) {
						good_moves.push_back(mv);
					}
				}
			}
		}
	}
	return good_moves;
}

void parse_ascii(gamestate& g) {
	int cnt = 0;
	int cnt2 = 0;
	
const char* a = ".........................\
..*..................E*..\
.........................\
..........**.**..........\
........**.....**........\
.......E.........E.......\
......*...........*......\
...*..**..*...*..**..*...\
......a...........a......\
.....*..*.......*..*.....\
*.......*.**.**.*.......*\
*..*...*...*.*...*...*..*\
............*............\
...a.*...*.....*...*.a...\
........*...*...*........\
......MM*.......*EM......\
.a.*.................*.a.\
.........................\
*...*...............*...*\
........***...***........\
*..*........*........*..*\
.**...................**.\
..*...................*..\
......*....*.*....*......\
......*..........M*......";
	for(int i = 0 ; i < 625 ; i++) {
		char v = a[i];
		if(v == '.') {
			g.p[i] = LIBRE;
		}
		if(v == 'E') {
			g.p[i] = AGENT_LUI;
			g.agents_lui[cnt++] = i;
		}
		if(v == 'M') {
			g.p[i] = AGENT_MOI;
			g.agents_moi[cnt2++] = i;
		}
		if(v == '*') {
			g.p[i] = MUR;
		}
	}
}

std::vector<move_t> gen_interesting_moves(gamestate& state, int side) {
	std::vector<move_t> good_moves = std::vector<move_t>();
	move_t null_move;
	null_move.start = 0;
	null_move.pos = 0;
	null_move.flags = 0;
	null_move.cout = NULLMOVE_FLAG;
	int LUI = (side == api_moi()) ? AGENT_LUI : AGENT_MOI;
	
	good_moves.push_back(null_move);

	for(int i = 0 ; i < 4 ; i++) {
		if(state.agents_PA[i] == 0)
			continue;
		int pos = (side == api_moi()) ? state.agents_moi[i] : state.agents_lui[i];
		plateau res, dual;
		dist_to_cases(state.p, pos, res, dual);
		for(alien_info& al : aliens_list) { // Alien
			int al_pos = from_position(al.pos);
			int t_dist = res[al_pos]/8;
			if(est_capturable(al, state.tour+t_dist, state.cap[al_pos]) && state.p[al_pos] <= 0) {
				int to_add = al_pos;
				int s = 0;
				while(res[to_add] > state.agents_PA[i]) {
					to_add = dual[to_add];
					s++;
				}
				move_t mv;
				mv.pos = to_add;
				mv.start = pos;
				mv.flags = s + 10*(to_add == al_pos);
				mv.cout = res[to_add];
				if(mv.pos != mv.start) {
					good_moves.push_back(mv);
				}
			}
		}
		
		for(alien_info& al : aliens_list) { // A cote de lalien avec qqun dessus
			int al_pos = from_position(al.pos);
			int t_dist = res[al_pos]/8; 
			/*
				if(pos == 18+15*25 && al_pos == 17+15*25) {
					printf("OHAI %d %d %d %d %d\n", est_capturable(al, state.tour+t_dist, state.cap[al_pos]), state.tour, \
					state.cap[al_pos] != NB_TOURS_CAPTURE, al.tour_invasion <= state.tour, al.duree_invasion + al.tour_invasion + state.cap[al_pos] - 3 > state.tour);
				}
			*/
			
			if(est_capturable(al, state.tour+t_dist, state.cap[al_pos]) && state.p[al_pos] > 0) {
				for(int& m : gen_sides(state.p, al_pos)) {
					if(res[m] == 1000 || (state.p[m] > 0 && m != pos))
						continue;
					int to_add = m;
					//printf("mv %d PA %d\n", to_add, state.agents_PA[i]);
					while(res[to_add] > state.agents_PA[i]) {
						to_add = dual[to_add];
					}
					move_t mv;
					mv.flags = 123;
					if(state.p[al_pos] == LUI && res[m] <= 3-8+state.agents_PA[i]) { // On ne vient pas pour rien, on vient pour pousser si on est suffisamment pres
						//printf("%d %d\n", res[m], state.agents_PA[i]);
						mv.flags = POUSSER_FLAG | al_pos;
					}
					mv.pos = to_add;
					mv.start = pos;
					mv.cout = res[to_add] + (((mv.flags & POUSSER_FLAG) > 0) ? 5 : 0);
					if(mv.pos != mv.start || (mv.flags & POUSSER_FLAG) > 0) {
						good_moves.push_back(mv);
					}
				}
			}
		}
	}
	if(good_moves.size() < 10) {
		for(int i = 0 ; i < 4 ; i++) {
			int pos = (side == api_moi()) ? state.agents_moi[i] : state.agents_lui[i];
			if(state.agents_PA[i] == 0)
				continue;
			if(state.agents_PA[i] >= 3) {
				for(direction& dir : directions) {
					int res = pousser_res(state.p, pos, dir);
					if(res != pos) {
						move_t mv;
						mv.flags = 888;
						mv.pos = res;
						mv.start = pos;
						mv.cout = 3;
						good_moves.push_back(mv);
					}
				}
			} else {
				for(int& m : gen_sides(state.p, pos)) {
					if(state.p[m] <= 0) {
						move_t mv;
						mv.flags = 888;
						mv.pos = m;
						mv.start = pos;
						mv.cout = 1;
						good_moves.push_back(mv);
					}
				}
			}
		}
	}
	return good_moves;
}

void charger_jeu(gamestate& g) {
	g.tour = api_tour_actuel();
	
	for(int i = 0 ; i < 625 ; i++) {
		position pos;
		pos.ligne = i/25;
		pos.colonne = i%25;
		case_type info = type_case(pos);
		g.p[i] = info;
		g.cap[i] = 0;
	}
	
	for(alien_info& inf : aliens_list) {
		if(alien_sur_case(inf.pos)) {
			g.cap[from_position(inf.pos)] = info_alien(inf.pos).capture_en_cours;
		} else if(g.tour >= inf.tour_invasion && g.tour < inf.tour_invasion+inf.duree_invasion) {
			g.cap[from_position(inf.pos)] = 3;
			debug_afficher_drapeau(inf.pos, DRAPEAU_VERT);
		}
	}
	
	for(int i = 0 ; i < 4 ; i++) {
		position agent_pos = position_agent(api_moi(), i);
		g.agents_moi[i] = from_position(agent_pos);
		g.p[g.agents_moi[i]] = AGENT_MOI;
		g.agents_PA[i] = 8;
	}
	for(int i = 0 ; i < 4 ; i++) {
		position agent_pos = position_agent(api_adversaire(), i);
		g.agents_lui[i] = from_position(agent_pos);
		g.p[g.agents_lui[i]] = AGENT_LUI;
	}
	g.score_moi = 0;//api_score(api_moi());
	g.score_lui = 0;//api_score(api_adversaire());
	
}

void cpy_plateau(plateau& src, plateau& dst) {
	for(int i = 0 ; i < 625 ; i++) {
		dst[i] = src[i];
	}
}

/// Fonction appelée au début de la partie.
void partie_init()
{
	printf("Init start..\n");
	for(int i = 0 ; i < 625 ; i++) {
		aliens_pos[i].tour_invasion = -1000;
		aliens_pos[i].duree_invasion = 0;
		aliens_pos[i].points_capture = 0;
		aliens_pos[i].duree_invasion = 0;
	}
	
	for(int i = 0 ; i < MAX_DIST ; i++) {
		pointers[i] = 0;
	}
	aliens_list = liste_aliens();
	for(alien_info& alien : aliens_list) {
		aliens_pos[from_position(alien.pos)] = alien;
	}
	printf("Init OK\n");
}

void afficher_coup(move_t mv) {
	printf("%d-%d %d-%d %d %d\n", mv.start%25, mv.start/25, mv.pos%25, mv.pos/25, mv.cout, mv.flags);
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{
	
	gamestate state;
	charger_jeu(state);
	
	/*
	parse_ascii(state);
	state.cap[17+15*25] = 2;
	state.tour = 11;
	plateau res, dual;
	dist_to_cases(state.p, 18+15*25, res, dual);
	afficher_raw(res);
	printf("---");
	afficher_raw(dual);
	
	move_t mv;
	mv.start = 1;
	mv.pos = 16*25+1;
	mv.flags = 0;
	mv.cout = 3;
	appliquer_move(state, mv);
	state.tour = 10;
	afficher_plateau(state.p, true, 10);
	for(move_t& mv : gen_interesting_moves(state, api_moi())) {
		afficher_coup(mv);
	}
	plateau res, dual;
	
	
	return;
	*/
	
	for(alien_info& al : aliens_list) {
		if(al.tour_invasion == state.tour + 2) {
			debug_afficher_drapeau(al.pos, DRAPEAU_BLEU);
		}
		if(al.tour_invasion == state.tour + 1) {
			debug_afficher_drapeau(al.pos, DRAPEAU_ROUGE);
		}
	}
	printf("Tour %d --- \n", state.tour);
	auto time = std::clock();
	auto time2 = std::clock();
	afficher_plateau(state.p, true, state.tour);
	int total = 32;
	move_t best_move;
	best_move.start = -1;
		st_temps = 0;
	int coups = 0;
	do {
		float max_score = -1000000;
		int mv_count = 0;
		for(move_t& mv : gen_interesting_moves(state, api_moi())) {
			plateau tmp, tmp2;
			cpy_plateau(state.p, tmp);
			appliquer_move(state, mv);
			float minscore = score_state(state);
			/*
			int save[4];
			
			for(int i = 0 ; i < 4 ; i++) {
				save[i] = state.agents_PA[i];
				state.agents_PA[i] = 8;
				state.cap[state.agents_moi[i]] += 1;
				if(state.cap[state.agents_moi[i]] == 3) {
					state.score_moi += aliens_pos[state.agents_moi[i]].points_capture;
				}
			}
			std::vector<move_t> enemy_push_moves = gen_push_moves(state, api_adversaire());
			if(enemy_push_moves.size() > 0) {
				for(move_t& mv : enemy_push_moves) {
					plateau tmp3, tmp4;
					cpy_plateau(state.p, tmp3);
					appliquer_move(state, mv);
					float score = score_state(state);
					if(score < minscore) {
						minscore = score;
					}
					cpy_plateau(state.p, tmp4);
					annuler_move(state, mv);
					if(!cmp_plateau(tmp3, state.p)) {
						printf("AH !!! Pas bien ca !!!!!!!\n");
						afficher_coup(mv);
						afficher_plateau(tmp3, true, state.tour);
						printf("-\n");
						afficher_plateau(tmp4, true, state.tour);
						printf("-\n");
						afficher_plateau(state.p, true, state.tour);
					}
				}
			}
			for(int i = 0 ; i < 4 ; i++) {
				state.agents_PA[i] = save[i];
				if(state.cap[state.agents_moi[i]] == 3) {
					state.score_moi -= aliens_pos[state.agents_moi[i]].points_capture;
				}
				state.cap[state.agents_moi[i]] -= 1;
			}
			* */
			//printf("score %f for ", minscore);
			//afficher_coup(mv);
			cpy_plateau(state.p, tmp2);
			annuler_move(state, mv);
			
			
			
			if(!cmp_plateau(tmp, state.p)) {
				printf("AH !!! Pas bien ca !!!\n");
				afficher_coup(mv);
				afficher_plateau(tmp, true, state.tour);
				printf("-\n");
				afficher_plateau(tmp2, true, state.tour);
				printf("-\n");
				afficher_plateau(state.p, true, state.tour);
			}
			
			
			if(minscore > max_score) {
				max_score = minscore;
				best_move = mv;
			}
			mv_count++;
		}
		if(best_move.start != -1) {
			jouer_coup(state, best_move);
			appliquer_move(state, best_move);
			total -= best_move.cout;
			printf("%d coups analyse\n", mv_count);
			coups += mv_count;
			printf("score - %f ", max_score);
			afficher_coup(best_move);
			time2 = std::clock();
		} else {
			break;
		}
		printf("---\n");
	} while((best_move.flags & NULLMOVE_FLAG) == 0 && total > 0 && (1000*(time2-time)/CLOCKS_PER_SEC) < 850);
	
	std::cout << 1000*st_temps/CLOCKS_PER_SEC << "ms for scoring taken" << std::endl;
	std::cout << 1000*(std::clock()-time)/CLOCKS_PER_SEC << "ms taken, so thats " << (float)(coups) / (1000*(std::clock()-time)/CLOCKS_PER_SEC) << std::endl;
	/*
	for(int i = 0 ; i < 4 ; i++) {
		base[agents_moi[i]] = LIBRE;
	}
	
	plateau a, b;
	dist_to_cases(base, 0 + 17*25, a, b);
	for(int mv : gen_mouvements(base, 17*25, 8)) {		
		if((mv & 2048) > 0) {
			mv -= 2048;
		}
		printf("%d %d ", mv%25, mv/25);
	}
	printf("\n");
	printf("\n");
	afficher_raw(b);
	afficher_raw(a);
	*/
	/*
	for(int i = 0 ; i < 4 ; i++) {
		printf("Agent %d ---\n", i);
		alien_info inf = aliens_pos[agents_moi[i]];
		if(est_capturable(inf, tour)) {
			printf("En cours de capture... %d %d %d\n", inf.tour_invasion, inf.duree_invasion, inf.duree_invasion);
			continue;
		}
		plateau res, dual;
		dist_to_cases(base, agents_moi[i], res, dual);
		int min_dist = 10000;
		int pos = -1;
		for(alien_info& al : aliens_list) {
			int al_pos = from_position(al.pos);
			
			if(!est_capturable(al, tour) || base[al_pos] == AGENT_MOI) {
				continue;
			}
			if(res[al_pos] < min_dist) {
				min_dist = res[al_pos];
				pos = al_pos;
			}
		}
		int d = abs(pos - agents_moi[i]);
		if(base[pos] == AGENT_LUI && (d == 1 || d == 25)) {// A cote
			printf("Decide de pousser l'enemi\n");\
			direction dir = diff_to_direction(pos-agents_moi[i]);
			pousser(i, dir);
			deplacer(i, dir);
			
			int res = pousser_res(base, pos, dir);
			agents_moi[i] = pos;
			for(int j = 0 ; j < 4 ; j++) {
				if(agents_enemi[j] == pos) {
					agents_enemi[j] = res;
					break;
				}
			}
			base[pos] = AGENT_MOI;
			base[res] = AGENT_LUI;
		} else if(pos != -1) {
			printf("Decide de bouger vers %d %d au prix de %d PA\n", pos%25, pos/25, min_dist);
			pos = deplacer_agent_api(i, agents_moi[i], pos, dual);
			base[pos] = AGENT_MOI;
			base[agents_moi[i]] = LIBRE;
			agents_moi[i] = pos;
		} else {
			printf("Rien d'interessant a faire.. \n");
		}
	}
	*/
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{

}

int main() {
	partie_init();
	return 0;
}
