/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cxx.rb

#include "prologin.hh"
#include <iostream>
#include <algorithm>
#include <chrono>
#include <ctime>
#include <cstdlib>

using namespace std;

using etabli = int[36];
using etabli_visit = bool[36];
using region = vector<int>;
typedef struct {int gold; int cat;} gold_cat; // Chat en or (lol)
vector<position_echantillon> all_pos;
vector<echantillon> ech_hist;
bool dangereux = false;

position to_position(int pos) {
    return (position){pos/6, pos%6};
}

int from_position(position pos) {
    return pos.ligne*6 + pos.colonne;
}

// PRINTING
void print_etabli(etabli e) {
    for(int l = 0 ; l < 6 ; l++) {
        for(int c = 0 ; c < 6 ; c++) {
            cout << e[l*6+c] << " ";
        }
        cout << endl;
    }
}

void print_region(region g) {
    cout << "[";
    if(g.size() > 0) {
        cout << g[0];
        for(unsigned int i = 1 ; i < g.size() ; i++) {
            cout << ", " << g[i];
        }
    }
    cout << "]";
}

void print_vector(vector<int> g) {
    cout << "[";
    if(g.size() > 0) {
        cout << g[0];
        for(unsigned int i = 1 ; i < g.size() ; i++) {
            cout << ", " << g[i];
        }
    }
    cout << "]";
}

void print_regions(vector<region> g) {
    cout << "[";
    if(g.size() > 0) {
        print_region(g[0]);
        for(unsigned int i = 1 ; i < g.size() ; i++) {
            cout << ", ";
            print_region(g[i]);
        }
    }
    cout << "]";
}

// END PRINT

// INIT THINGS

void init_etabli(etabli& e, int apprentiId) {
    for(int i = 0 ; i < 36 ; i++) {
        e[i] = (int)api_type_case(to_position(i), apprentiId);
    }
}

void init_etabli_visit(etabli_visit& e) {
    for(int i = 0 ; i < 36 ; i++)
        e[i] = false;
}

void partie_init()
{
    ech_hist = vector<echantillon>();
    all_pos = vector<position_echantillon>();
    for(int c = 0 ; c < 6 ; c++)
        for(int l = 0 ; l < 5 ; l++) {
            all_pos.push_back({{l, c}, {l+1, c}});
            all_pos.push_back({{l+1, c}, {l, c}});
        }
    for(int c = 0 ; c < 5 ; c++)
        for(int l = 0 ; l < 6 ; l++) {
            all_pos.push_back({{l, c}, {l, c+1}});
            all_pos.push_back({{l, c+1}, {l, c}});
        }
    long ms = std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::system_clock::now().time_since_epoch()).count();
    std::srand((int)(ms*10000));
}
// END INIT THIGNS

// USEFULL FUNCTIOJS

vector<int> neighbours(etabli e, int p) {
    vector<int> pos = vector<int>();
    if(p%6 > 0) {
        pos.push_back(p-1);
    }
    if(p/6 > 0) {
        pos.push_back(p-6);
    }
    if(p%6 < 5) {
        pos.push_back(p+1);
    }
    if(p/6 < 5) {
        pos.push_back(p+6);
    }
    return pos;
}

region get_region(etabli e, etabli_visit& vis, int pos) {
    region g = region();
    vector<int> cur = vector<int>();
    vector<int> next = vector<int>();
    int type = e[pos];
    
    cur.push_back(pos);
    vis[pos] = true;
    
    while(cur.size() > 0) {
        next.clear();
        for (int elem : cur) {  
            g.push_back(elem);
            for(int nei : neighbours(e, elem)) {
                if(!vis[nei] && e[nei] == type) {
                    next.push_back(nei);
                    vis[nei] = true;
                }
            }
        }
        cur.swap(next);
    }
    
    return g;
}

vector<region> regions(etabli e) {
    etabli_visit visit;
    init_etabli_visit(visit);
    vector<region> regions = vector<region>();
    for(int i = 0 ; i < 36 ; i++) {
        if(!visit[i] && e[i] > 0 ) {
            regions.push_back(get_region(e, visit, i));
        }
    }
    return regions;
}

gold_cat score_region(etabli e, region g) {
    int len = g.size();
    if(len == 0) {
        return {-3, 0};
    }
    if(e[g[0]] <= 3) {
        return {api_quantite_transmutation_or(len), 0};
    }
    return {api_quantite_transmutation_catalyseur_or(len),
            api_quantite_transmutation_catalyseur(len)};
}

region find_best_region_gold(vector<region> regions, etabli e) {
    int max = 0;
    region best;
    
    for(region g : regions) {
        gold_cat score = score_region(e, g);
        if(score.gold >= max) {
            max = score.gold;
            best = g;
        }
    }
    
    return best;
}

int isolement_region(region r, etabli etab) {
    int sum = 0;
    for(int i = 0 ; i < 36 ; i++) {
        if(etab[i] == 0) {
            for(int p : neighbours(etab, i)) {
                for(int k : r) {
                    if(k == p) {
                        sum += 1;
                        break;
                    }
                }
            }
        }
    }
    return sum;
}

const float COEFF_CATA = 0.7; // 0.9
const float COEFF_GOLD = 1.6; // 1.6
const float COEFF_REGI = 3.4; // 3.4 nombre de regions
const float COEFF_ISOLEMENT = 1.3; // score region a region entre 0 et 10
const float COEFF_TROU = 0.01; // Generalement etnre 0 et 10
const float COEFF_SERPENT = 1.05;

void score_stats(etabli etab) {
    float score = 0;
    vector<region> regs = regions(etab);
    cout << "Il y a " << regs.size() << " regions" << endl;
    for(region r : regs) {
        gold_cat score_r = score_region(etab, r);
        int type = etab[r[0]];
        if(score_r.gold == -3)
            score_r.gold = 0;
        int isolement = isolement_region(r, etab)/(3+r.size());
        
        float serpent = 0;
        for(int k : r) {
            int sum = 0;
            for(int ne : neighbours(etab, k)) {
                if(etab[ne] == type) {
                    sum += 1;
                }
            }
            serpent += sum;
        }
        serpent /= r.size();
        
        cout << "  " << score_r.gold*COEFF_GOLD << "g " << score_r.cat*COEFF_CATA << "c " << isolement*COEFF_ISOLEMENT << "i " << endl;
        score += score_r.gold*COEFF_GOLD + score_r.cat*COEFF_CATA + isolement*COEFF_ISOLEMENT; // SCORE TODO
    }
    cout << "total: " << score << endl;
    score -= regs.size()*COEFF_REGI;
    cout << "region size: " << regs.size()*COEFF_REGI << endl;
    float trous = 0;
    for(int i = 0 ; i < 36 ; i++) {
        if(etab[i] == 0) {
            vector<int> n = neighbours(etab, i);
            int sum = 0;
            for(int k : n) {
                if(etab[k] == 0) {
                    sum++;
                }
            }
            if(sum == 0) {
                trous += 1;
            }
            if(sum == 1) {
                trous += .3;
            }
            if(sum == 2) {
                trous += .001;
            }
        }
    }
    score -= trous*COEFF_TROU;
    cout << "trous: " << trous*COEFF_TROU << endl;
    cout << "final: " << score << endl;
}

float score_etabli(etabli etab) {
    float score = 0;
    vector<region> regs = regions(etab);
    for(region r : regs) {
        gold_cat score_r = score_region(etab, r);
        int type = etab[r[0]];
        if(score_r.gold == -3)
            score_r.gold = 0;
        int isolement = isolement_region(r, etab)/(3+r.size());
        
        float serpent = 0;
        for(int k : r) {
            int sum = 0;
            for(int ne : neighbours(etab, k)) {
                if(etab[ne] == type) {
                    sum += 1;
                }
            }
            serpent += sum;
        }
        serpent /= r.size();
        score += score_r.gold*COEFF_GOLD + score_r.cat*COEFF_CATA + isolement*COEFF_ISOLEMENT + serpent*COEFF_SERPENT; // SCORE TODO
    }
    score -= regs.size()*COEFF_REGI;
    float trous = 0;
    for(int i = 0 ; i < 36 ; i++) {
        if(etab[i] == 0) {
            vector<int> n = neighbours(etab, i);
            int sum = 0;
            for(int k : n) {
                if(etab[k] == 0) {
                    sum++;
                }
            }
            if(sum == 0) {
                trous += 1;
            }
            if(sum == 1) {
                trous += .3;
            }
            if(sum == 2) {
                trous += .001;
            }
        }
    }
    score -= trous*COEFF_TROU;
    return score;
}


void appliquer_etabli(echantillon ech, position_echantillon pe, etabli& e) {
    e[from_position(pe.pos1)] = ech.element1;
    e[from_position(pe.pos2)] = ech.element2;
}

void appliquer_transmuter(etabli& e, int pos) {
    vector<int> cur = vector<int>();
    vector<int> next = vector<int>();
    vector<int> todel = vector<int>();
    etabli_visit vis;
    init_etabli_visit(vis);
    int type = e[pos];
    
    cur.push_back(pos);
    vis[pos] = true;
    
    while(cur.size() > 0) {
        next.clear();
        for (int elem : cur) {  
            todel.push_back(elem);
            for(int nei : neighbours(e, elem)) {
                if(!vis[nei] && e[nei] == type) {
                    next.push_back(nei);
                    vis[nei] = true;
                }
            }
        }
        cur.swap(next);
    }
    for(int i : todel) {
        e[i] = 0;
    }
}
// END USEFULL
bool est_valide(etabli e, position_echantillon pe, echantillon ech) {
    int p1 = from_position(pe.pos1);
    int p2 = from_position(pe.pos2);
    
    if(e[p1] != 0 or e[p2] != 0)
        return false;
    bool libre = true;
    for(int i = 0 ; i < 36 ; i++) {
        if(e[i] == ech.element1 or e[i] == ech.element2)
        {
            libre = false;
            break;
        }
    }
    if(libre)
        return true;
    for(int k : neighbours(e, p1))
        if(k != p2 && e[k] == ech.element1)
            return true;
    for(int k : neighbours(e, p2))
        if(k != p1 && e[k] == ech.element2)
            return true;
    return false;
}

bool transmuter_force(etabli e) {
    region g = find_best_region_gold(regions(e), e);
    if(g.size() == 0)
        return false;
    api_transmuter(to_position(g[0]));
    return true;
}
void transmuter_fin();

void placer() {
    etabli etab2;
    etabli_visit vis;
    echantillon ech = api_echantillon_tour();
    
    vector<position_echantillon> best_echs;
    float max = -1000000;
    int somme_egaux = 0;
    for(position_echantillon pe : all_pos) {
        init_etabli(etab2, api_moi());
        init_etabli_visit(vis);
        /*cout << "--" << endl;
        print_etabli(etab2);
        cout << from_position(pe.pos1) << " " << etab2[from_position(pe.pos1)] << " ";
        cout << from_position(pe.pos2) << " " << etab2[from_position(pe.pos2)] << " ";
        */
        float malus_replace = 0;
        if(etab2[from_position(pe.pos1)] > 0) {
            int size = get_region(etab2, vis, from_position(pe.pos1)).size();
            //if(size > 8)
            //    size = 8;
            size -= 5;
            size *= abs(size);
            malus_replace -= size - 5;
            appliquer_transmuter(etab2, from_position(pe.pos1));
        }
        if(etab2[from_position(pe.pos2)] > 0) {
            int size = get_region(etab2, vis, from_position(pe.pos2)).size();
            /*if(size > 8)
                size = 8;*/
            size -= 5;
            size *= abs(size);
            malus_replace -= size - 5;
            appliquer_transmuter(etab2, from_position(pe.pos2));
        }
        if(!est_valide(etab2, pe, ech))
            continue;
        appliquer_etabli(ech, pe, etab2);
        float score_ech = score_etabli(etab2) - malus_replace;
        if(score_ech == max) {
            somme_egaux += 1;
            best_echs.push_back(pe);
        }
        if(score_ech > max) {
            max = score_ech;
            best_echs.clear();
            best_echs.push_back(pe);
            somme_egaux = 1;
        }
    }
    if(max == -1000000) {
        transmuter_fin();
        return;
    }
    
    position_echantillon bestEch = best_echs[std::rand()%somme_egaux];
    /*if(somme_egaux > 1) {
        cout << somme_egaux << " egaux avec comme score " << max << " et best_pos: " << endl;
        for(position_echantillon kiwi : best_echs) {
           cout << from_position(kiwi.pos1)/6 << " " << from_position(kiwi.pos1)%6 << " " << from_position(kiwi.pos2)/6 << " " << from_position(kiwi.pos2)%6 << endl;
        }
        api_afficher_etablis();
        cout << endl;
    }*/
    if(!api_est_vide(bestEch.pos1, api_moi())) {
        api_transmuter(bestEch.pos1);
    }
    if(!api_est_vide(bestEch.pos2, api_moi())) {
        api_transmuter(bestEch.pos2);
    }
    
    api_placer_echantillon(bestEch.pos1, bestEch.pos2);
}
void transmuter() {
    etabli e;
    init_etabli(e, api_moi());
    
    region g = find_best_region_gold(regions(e), e);
    if(g.size() == 0) {
        return;
    }
    gold_cat score = score_region(e, g);
    if(score.gold > 5)
        api_transmuter(to_position(g[0]));
}

void catalyser_pour_transmuter(bool only_metaux);

void transmuter_fin() {
    etabli e;
    while(true) {
        init_etabli(e, api_moi());
        region best;
        float max = 0;
        for(region r : regions(e)) {
            if(api_propriete_case_type((case_type)e[r[0]]) == TRANSMUTABLE_CATALYSEUR) {
                float score = r.size();
                if(score > max)
                {
                    max = score;
                    best = r;
                }
            }
        }
        if(max <= 1)
        {
            break;
        }
        api_transmuter(to_position(best[0]));
    }
    for(int i = 0 ; i < api_nombre_catalyseurs() ; i++) {
        catalyser_pour_transmuter(true);
    }
    init_etabli(e, api_moi());
    for(region r : regions(e)) {
        if(r.size() >= 2) {
            api_transmuter(to_position(r[0]));
        }
    }
}

void catalyser_pour_transmuter(bool only_metaux) {
    int catalNb = api_nombre_catalyseurs();
    if(catalNb <= 0)
        return;
    cout << "J'ai " << catalNb << "catalyseurs" << endl;
    etabli etab2;
    init_etabli(etab2, api_moi());
    
    
    float max_score = score_etabli(etab2);
    int cat_pos = -1;
    int cat_typ = -1;
    
    for(int i = 0 ; i < 36 ; i++) {
        if(etab2[i] == 0)
            continue;
        for(int cat_id = 1  ; cat_id < 6 - ((only_metaux) ? 2 : 0 ); cat_id++) {
            if(cat_id == etab2[i])
                continue;
            int tmp = etab2[i];
            etab2[i] = cat_id;
            float score_ech = score_etabli(etab2);
            if(score_ech > max_score) {
                max_score = score_ech;
                cat_pos = i;
                cat_typ = cat_id;
            }
            etab2[i] = tmp;
        }
    }
    if(cat_pos != -1) {
        cout << "catalyse en " << cat_pos << " avec " << cat_typ << " score: " << max_score << endl;
        api_catalyser(to_position(cat_pos), api_moi(), (case_type)cat_typ);
    }
}

void catalyser_pour_attaquer() {
    int catalNb = api_nombre_catalyseurs();
    if(catalNb <= 0)
        return;
    cout << "J'ai " << catalNb << " catalyseurs (mode attaque) " << endl;
    etabli etab2;
    init_etabli(etab2, api_adversaire());
    
    
    float min_score = score_etabli(etab2);
    int cat_pos = -1;
    int cat_typ = -1;
    
    for(int i = 0 ; i < 36 ; i++) {
        if(etab2[i] == 0)
            continue;
        for(int cat_id = 1  ; cat_id < 6 ; cat_id++) {
            if(cat_id == etab2[i])
                continue;
            int tmp = etab2[i];
            etab2[i] = cat_id;
            float score_ech = score_etabli(etab2);
            if(score_ech < min_score) {
                min_score = score_ech;
                cat_pos = i;
                cat_typ = cat_id;
            }
            etab2[i] = tmp;
        }
    }
    if(cat_pos != -1) {
        cout << "catalyse en " << cat_pos << " avec " << cat_typ << " (attaque) score: " << min_score << endl;
        api_catalyser(to_position(cat_pos), api_adversaire(), (case_type)cat_typ);
    }
}

vector<position_echantillon> possibles_placements_enemi(echantillon e) {
    vector<position_echantillon> ret = vector<position_echantillon>();
    for(int c = 0 ; c < 6 ; c++)
        for(int l = 0 ; l < 5 ; l++) {
            if(placement_possible_echantillon(e, {l, c}, {l+1, c}, api_adversaire()))
                ret.push_back({{l, c}, {l+1, c}});
            if(placement_possible_echantillon(e, {l+1, c}, {l, c}, api_adversaire()))
                ret.push_back({{l+1, c}, {l, c}});
        }
    for(int c = 0 ; c < 5 ; c++)
        for(int l = 0 ; l < 6 ; l++) {
            if(placement_possible_echantillon(e, {l, c}, {l, c+1}, api_adversaire()))
                ret.push_back({{l, c}, {l, c+1}});
            if(placement_possible_echantillon(e, {l, c+1}, {l, c}, api_adversaire()))
                ret.push_back({{l, c+1}, {l, c}});
        }
    return ret;
}

void danger_transmut() {
    etabli e_enemi, e;
    init_etabli(e_enemi, api_adversaire());
    init_etabli(e, api_moi());
    
    int degats = 0;
    for(region r : regions(e_enemi)) {
        if(e_enemi[r[0]] >= SOUFRE) {
            degats = max(degats, api_quantite_transmutation_catalyseur(r.size()));
        }
    }
    if(degats == 0)
        return;
    vector<region> regs = regions(e);
    if(regs.size() == 0)
        return;
    region biggest;
    float max_s = 0;
    for(region r : regs) {
        gold_cat score_r = score_region(e, r);
        float score = score_r.gold*COEFF_GOLD + score_r.cat*COEFF_CATA;
        if(score > max_s) {
            biggest = r;
            max_s = score;
        }
    }
    //gold_cat score_r = score_region(e, biggest);
    cout << "Analyse de danger --" << endl;
    cout << "  region la plus grosse : " << biggest.size() << " (ok for >= 8) ";
    print_region(biggest);
    cout << endl;
    if(biggest.size() >= (unsigned int)max(6, 8 - (degats+1)/2)) {
        float score = biggest.size()*2.5;
        float diff = score - score/(0.6+0.8*degats);
        float test_diff = 7.5;
        cout << "  Danger transmut avancee: "<<endl;
        cout << "    score: " << score << endl;
        cout << "    size:  " << biggest.size() << endl;
        cout << "    diff:  " << diff << endl;
        cout << "    test:  " << test_diff << endl;
        cout << "    degat: " << degats << endl;
        if(diff >= test_diff) {
            cout << "  Transmutation!" << endl;
            api_transmuter(to_position(biggest[0]));
        }
    }
}

void donner() {
    etabli e_enemi;
    init_etabli(e_enemi, api_adversaire());
    int count[6] = {0, 0, 0, 0, 0, 0};
    for(int i = 0 ; i < 36 ; i++) {
        count[e_enemi[i]]++;
    }
    echantillon don;
    echantillon e = api_echantillon_tour();
    
    if(count[e.element1] < count[e.element2]) {
        don.element1 = e.element1;
    } else {
        don.element1 = e.element2;
    }
    int min = 100;
    int minElem = 0;
    for(int i = 1 ; i < 6 ; i++) {
        if(count[i] < min && i != don.element1) {
            min = count[i];
            minElem = i;
        }
    }
    don.element2 = (case_type)minElem;
    donner_echantillon(don);
}

void donner2() {
    echantillon e = api_echantillon_tour();
    echantillon don;
    etabli e_enemi;
    etabli_visit vis;
    init_etabli(e_enemi, api_adversaire());
    float min = 1000000;
    echantillon best_don;
    bool notok = true;
    
    for(int a = 0; a < 2 ; a++) {
        if(a == 1)
            don.element1 = e.element1;
        if(a == 0)
            don.element1 = e.element2;
        for(int k = 1 ; k < 6 ; k++) {
            don.element2 = (case_type)k;
            float max = -100000;
            position_echantillon best_pos = {-1, -1};
            
            for(position_echantillon pe : all_pos) {
                
                init_etabli(e_enemi, api_adversaire());
                init_etabli_visit(vis);
                /*cout << "--" << endl;
                print_etabli(etab2);
                cout << from_position(pe.pos1) << " " << etab2[from_position(pe.pos1)] << " ";
                cout << from_position(pe.pos2) << " " << etab2[from_position(pe.pos2)] << " ";
                */
                float malus_replace = 0;
                if(e_enemi[from_position(pe.pos1)] > 0) {
                    int size = get_region(e_enemi, vis, from_position(pe.pos1)).size();
                    if(size > 10)
                        size = 10;
                    size -= 5;
                    size *= abs(size);
                    malus_replace -= size - 5;
                    appliquer_transmuter(e_enemi, from_position(pe.pos1));
                }
                if(e_enemi[from_position(pe.pos2)] > 0) {
                    int size = get_region(e_enemi, vis, from_position(pe.pos2)).size();
                    if(size > 10)
                        size = 10;
                    size -= 5;
                    size *= abs(size);
                    malus_replace -= size - 5;
                    appliquer_transmuter(e_enemi, from_position(pe.pos2));
                }
                if(!est_valide(e_enemi, pe, don))
                    continue;
                appliquer_etabli(don, pe, e_enemi);
                float score = score_etabli(e_enemi) - malus_replace;
                if(score > max) {
                    max = score;
                    best_pos = pe;
                    notok = false;
                }
            }
            if(don.element1 >= SOUFRE)
                max -= 0.01;
            if(don.element2 >= SOUFRE)
                max -= 0.01;
            if(max < min) {
                min = max;
                best_don = don;
            }
        }
    }
    if(notok) {
        donner();
    } else {
        donner_echantillon(best_don);
    }
}

void chieur() {
    if(ech_hist.size() < 5)
        return;
    etabli e;
    init_etabli(e, api_moi());
    for(region g : regions(e)) {
        if(g.size() > 10) {
            int type = e[g[0]];
            bool inside = false;
            for(int i = 0 ; i < 5 ; i++) {
                echantillon ech = ech_hist[ech_hist.size()-1-i];
                if(ech.element1 == type or ech.element2 == type) {
                    inside = true;
                    break;
                }
            }
            if(!inside) {
                api_transmuter(to_position(g[0]));
            }
        }
    }
}

/// Fonction appelée à chaque tour.
void jouer_tour()
{   
    cout << "--- tour " << api_tour_actuel() << endl;
    echantillon ech = api_echantillon_tour();
    ech_hist.push_back(ech);
    
    std::chrono::time_point<std::chrono::system_clock> start, end;
    start = std::chrono::system_clock::now();
    
    if(!dangereux) {
        for(action_hist ah : api_historique()) {
            if(ah.atype == ACTION_CATALYSER) {
                if(ah.id_apprenti == api_moi()) {
                    dangereux = true;
                    break;
                }
            }
        }
        etabli e_enemi;
        init_etabli(e_enemi, api_adversaire());
        for(region r : regions(e_enemi)) {
            if(e_enemi[r[0]] >= SOUFRE) {
                if(r.size() >= 7) {
                    dangereux = true;
                    break;
                }
            }
        }
    }
    
    if(dangereux) {
        danger_transmut();
    }
    //std::cout << "play: " << api_moi() << std::endl;
    //afficher_etablis();
    chieur();
    
    //dangerTransmut();
    
    placer();
    if(api_nombre_catalyseurs() >= 2)
        catalyser_pour_attaquer();
    for(int i = 0 ; i < api_nombre_catalyseurs()/2 ; i++)
        catalyser_pour_attaquer();
    
    for(int i = 0 ; i < api_nombre_catalyseurs() ; i++)
        catalyser_pour_transmuter(false);
    
    if(tour_actuel() >= 149) {
        transmuter_fin();
    }
    //transmuter();
    donner2();
    
    for(int i = 0 ; i < api_nombre_catalyseurs() ; i++)
        catalyser_pour_attaquer();
    
    for(int i = 0 ; i < api_nombre_catalyseurs() ; i++)
        catalyser_pour_transmuter(false);
    end = std::chrono::system_clock::now();
 
    std::chrono::duration<double> elapsed_seconds = end-start;
    if(elapsed_seconds.count() > 0.02) {
        //std::cout << "WOW! au tour " << api_tour_actuel() << " elapsed time: " << elapsed_seconds.count() << "s\n";
    }
}

/// Fonction appelée à la fin de la partie.
void partie_fin()
{
    
}

