(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Taille du terrain (longueur et largeur).
*)
let taille_terrain = 39

(*
** Longueur de chacune de vos deux bases.
*)
let longueur_base = 13

(*
** Nombre de tours à jouer avant la fin de la partie.
*)
let nb_tours = 100

(*
** Nombre de points d'action par tour.
*)
let nb_points_action = 4

(*
** Nombre de points d'action que coûte la construction d'un tuyau.
*)
let cout_construction = 1

(*
** Nombre de points d'action que coûte l'amélioration d'un tuyau.
*)
let cout_amelioration = 1

(*
** Nombre de points d'action que coûte la destruction d'un tuyau.
*)
let cout_destruction = 3

(*
** Nombre de points d'action que coûte la destruction d'un Super Tuyau™.
*)
let cout_destruction_super_tuyau = 4

(*
** Charge en plasma nécessaire pour la destruction d'un tuyau ou d'un Super Tuyau™.
*)
let charge_destruction = 2.0

(*
** Nombre de points d'action que coûte le déblayage d'une case de débris.
*)
let cout_deblayage = 2

(*
** Nombre de points d'action que coûte le déplacement d'une unité de puissance d'aspiration de la base (la première modification de chaque tour est offerte).
*)
let cout_modification_aspiration = 1

(*
** Limite de puissance d'aspiration sur une case de base.
*)
let limite_aspiration = 5

(*
** Vitesse du plasma dans un tuyau normal, en nombre de cases par tour.
*)
let vitesse_tuyau = 1

(*
** Multiplicateur de la vitesse du plasma dans un Super Tuyau™.
*)
let multiplicateur_vitesse_super_tuyau = 2

(*
** Erreurs possibles
*)
type erreur =
| Ok (* <- L'action a été exécutée avec succès. *)
| Pa_insuffisants (* <- Vous ne possédez pas assez de points d'action pour cette action. *)
| Aucun_tuyau (* <- Il n'y a pas de tuyau à la position spécifiée. *)
| Position_invalide (* <- La position spécifiée est hors de la carte. *)
| Puissance_insuffisante (* <- Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base. *)
| Deplacement_invalide (* <- Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même. *)
| Pas_dans_base (* <- Cette case n'appartient pas à votre base. *)
| Amelioration_impossible (* <- Il y a déjà un Super Tuyau™ sur cette case. *)
| Construction_impossible (* <- Il est impossible de construire un tuyau à la position indiquée. *)
| Destruction_impossible (* <- Il n'y a pas de tuyau à la position spécifiée. *)
| Pas_de_pulsar (* <- Il n'y a pas de pulsar à la position spécifiée. *)
| Pas_de_debris (* <- Il n'y a pas de débris à la position spécifiée. *)
| Charge_insuffisante (* <- Vous ne possédez pas assez de plasma pour lancer une destruction. *)
| Limite_aspiration_atteinte (* <- Vous avez atteint la limite d'aspiration sur cette case. *)


(*
** Types de cases
*)
type case_type =
| Vide (* <- Case vide *)
| Tuyau (* <- Case contenant un tuyau *)
| Super_tuyau (* <- Case contenant un Super Tuyau™ *)
| Debris (* <- Case contenant des débris à déblayer *)
| Pulsar (* <- Case contenant un pulsar *)
| Base (* <- Case appartenant à une base d'un des joueurs *)
| Interdit (* <- Case où aucune action n'est possible *)


(*
** Position sur la carte, donnée par deux coordonnées.
*)
type position = (int * int)

(*
** Représente un pulsar existant.
*)
type pulsar_info = {
  periode : int ; (* <- Période de pulsation du pulsar *)
  puissance : float ; (* <- Quantité de plasma émise par chaque pulsation dans chaque direction *)
  pulsations_restantes : int ; (* <- Nombre de pulsations restantes *)
  pulsations_totales : int ; (* <- Nombre total de pulsations au début de la partie *)
}

(*
** Construit un tuyau sur une case donnée.
*)
external construire : position -> erreur = "ml_construire"
(*
** Améliore un tuyau en Super Tuyau™.
*)
external ameliorer : position -> erreur = "ml_ameliorer"
(*
** Détruit un tuyau sur une case donnée.
*)
external detruire : position -> erreur = "ml_detruire"
(*
** Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
*)
external deplacer_aspiration : position -> position -> erreur = "ml_deplacer_aspiration"
(*
** Déblaye une case de débris.
*)
external deblayer : position -> erreur = "ml_deblayer"
(*
** Renvoie le type d'une case donnée.
*)
external type_case : position -> case_type = "ml_type_case"
(*
** Renvoie la liste de tous les pulsars présents.
*)
external liste_pulsars : unit -> position array = "ml_liste_pulsars"
(*
** Renvoie la liste des cases contenant du plasma.
*)
external liste_plasmas : unit -> position array = "ml_liste_plasmas"
(*
** Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
*)
external liste_tuyaux : unit -> position array = "ml_liste_tuyaux"
(*
** Renvoie la liste des cases contenant un Super Tuyau™.
*)
external liste_super_tuyaux : unit -> position array = "ml_liste_super_tuyaux"
(*
** Renvoie la liste des cases contenant des débris.
*)
external liste_debris : unit -> position array = "ml_liste_debris"
(*
** Renvoie vrai si et seulement si la case contient un pulsar.
*)
external est_pulsar : position -> bool = "ml_est_pulsar"
(*
** Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
*)
external est_tuyau : position -> bool = "ml_est_tuyau"
(*
** Renvoie vrai si et seulement si la case contient un simple tuyau.
*)
external est_simple_tuyau : position -> bool = "ml_est_simple_tuyau"
(*
** Renvoie vrai si et seulement si la case contient un Super Tuyau™.
*)
external est_super_tuyau : position -> bool = "ml_est_super_tuyau"
(*
** Renvoie vrai si et seulement si la case contient un débris.
*)
external est_debris : position -> bool = "ml_est_debris"
(*
** Renvoie vrai si et seulement s'il est possible de construire sur cette case.
*)
external est_libre : position -> bool = "ml_est_libre"
(*
** Renvoie les informations propres au pulsar à la position donnée.
*)
external info_pulsar : position -> pulsar_info = "ml_info_pulsar"
(*
** Renvoie la quantité de plasma sur une case donnée.
*)
external charges_presentes : position -> float = "ml_charges_presentes"
(*
** Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
*)
external constructeur_tuyau : position -> int = "ml_constructeur_tuyau"
(*
** Renvoie le numéro du propriétaire d'une case de base.
*)
external proprietaire_base : position -> int = "ml_proprietaire_base"
(*
** Renvoie la liste des cases composant votre base.
*)
external ma_base : unit -> position array = "ml_ma_base"
(*
** Renvoie la liste des cases composant la base de votre ennemi.
*)
external base_ennemie : unit -> position array = "ml_base_ennemie"
(*
** Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
*)
external puissance_aspiration : position -> int = "ml_puissance_aspiration"
(*
** Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
*)
external directions_plasma : position -> position array = "ml_directions_plasma"
(*
** Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
*)
external cout_prochaine_modification_aspiration : unit -> int = "ml_cout_prochaine_modification_aspiration"
(*
** Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
*)
external hist_tuyaux_construits : unit -> position array = "ml_hist_tuyaux_construits"
(*
** Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
*)
external hist_tuyaux_detruits : unit -> position array = "ml_hist_tuyaux_detruits"
(*
** Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
*)
external hist_tuyaux_ameliores : unit -> position array = "ml_hist_tuyaux_ameliores"
(*
** Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
*)
external hist_debris_deblayes : unit -> position array = "ml_hist_debris_deblayes"
(*
** Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
*)
external hist_points_aspiration_ajoutes : unit -> position array = "ml_hist_points_aspiration_ajoutes"
(*
** Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
*)
external hist_points_aspiration_retires : unit -> position array = "ml_hist_points_aspiration_retires"
(*
** Renvoie votre numéro de joueur.
*)
external moi : unit -> int = "ml_moi"
(*
** Renvoie le numéro de votre adversaire.
*)
external adversaire : unit -> int = "ml_adversaire"
(*
** Indique votre nombre de points d'actions restants pour ce tour-ci.
*)
external points_action : unit -> int = "ml_points_action"
(*
** Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
*)
external score : int -> int = "ml_score"
(*
** Renvoie le numéro du tour actuel.
*)
external tour_actuel : unit -> int = "ml_tour_actuel"
(*
** Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
*)
external annuler : unit -> bool = "ml_annuler"
(*
** Affiche le contenu d'une valeur de type erreur
*)
external afficher_erreur : erreur -> unit = "ml_afficher_erreur"
(*
** Affiche le contenu d'une valeur de type case_type
*)
external afficher_case_type : case_type -> unit = "ml_afficher_case_type"
(*
** Affiche le contenu d'une valeur de type position
*)
external afficher_position : position -> unit = "ml_afficher_position"
(*
** Affiche le contenu d'une valeur de type pulsar_info
*)
external afficher_pulsar_info : pulsar_info -> unit = "ml_afficher_pulsar_info"
