/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_cs.rb

#include "interface.hh"

#include <iostream>
#include <assert.h>
#include <cstdlib>
#include <cstring>

CSharpInterface gl_csharp;

template < class Out, class Cxx >
Out cxx2lang(Cxx in)
{
  return (Out)in;
}

template <>
MonoString* cxx2lang<MonoString*, std::string>(std::string in)
{
  return mono_string_new (gl_csharp.getDomain(), in.c_str());
}

template <>
gint32 cxx2lang< gint32, int >(int in)
{
  return (gint32)in;
}

template <>
gint32 cxx2lang< gint32, bool >(bool in)
{
  return (gint32)in;
}

template < class Out, class Cxx >
Cxx lang2cxx(Out in)
{
  return (Cxx)in;
}

template <>
std::string lang2cxx< MonoString*, std::string >(MonoString* in)
{
  std::string s_out;
  MonoError error;
  char *c_out;

  if (!in)
    return std::string("(null)");
  c_out = mono_string_to_utf8_checked(in, &error);
  if (!mono_error_ok(&error)) {
    s_out = std::string(mono_error_get_message(&error));
    mono_error_cleanup(&error);
    return s_out;
  } else {
    s_out = std::string(c_out);
    mono_free(c_out);
    return s_out;
  }
}

template <>
int lang2cxx< gint32, int >(gint32 in)
{
  return (int)in;
}

template <>
bool lang2cxx< gint32, bool >(gint32 in)
{
  return (bool)in;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<int> >(std::vector<int> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_get_int32_class();
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);

  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, int >(in[i])));

  return maArray;
}

template <>
std::vector<int> lang2cxx< MonoArray*, std::vector<int> >(MonoArray* in)
{
  std::vector< int > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, int >(mono_array_get(in, gint32, i)));

  return out;
}
/// Erreurs possibles
template <>
gint32 cxx2lang< gint32, erreur >(erreur in)
{
  return (gint32)in;
}

template <>
erreur lang2cxx< gint32, erreur >(gint32 in)
{
  return (erreur)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<erreur> >(std::vector<erreur> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Erreur");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, erreur >(in[i])));
  return maArray;
}

template <>
std::vector<erreur> lang2cxx< MonoArray*, std::vector<erreur> >(MonoArray* in)
{
  std::vector< erreur > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, erreur >(mono_array_get(in , gint32, i)));
  return out;
}

/// Types de cases
template <>
gint32 cxx2lang< gint32, case_type >(case_type in)
{
  return (gint32)in;
}

template <>
case_type lang2cxx< gint32, case_type >(gint32 in)
{
  return (case_type)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<case_type> >(std::vector<case_type> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "CaseType");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, case_type >(in[i])));
  return maArray;
}

template <>
std::vector<case_type> lang2cxx< MonoArray*, std::vector<case_type> >(MonoArray* in)
{
  std::vector< case_type > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, case_type >(mono_array_get(in , gint32, i)));
  return out;
}

/// Position sur la carte, donnée par deux coordonnées.
template <>
MonoObject* cxx2lang< MonoObject*, position >(position in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_x = cxx2lang< gint32, int >(in.x);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "X"), &arg_x);
  auto arg_y = cxx2lang< gint32, int >(in.y);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Y"), &arg_y);
  return moObj;
}

template <>
position lang2cxx< MonoObject*, position >(MonoObject* in)
{
    position out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "X"), &out.x);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Y"), &out.y);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<position> >(std::vector<position> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, position >(in[i])));
  return maArray;
}

template <>
std::vector<position> lang2cxx< MonoArray*, std::vector<position> >(MonoArray* in)
{
  std::vector< position > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, position >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

/// Représente un pulsar existant.
template <>
MonoObject* cxx2lang< MonoObject*, pulsar_info >(pulsar_info in)
{
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "PulsarInfo");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  auto arg_periode = cxx2lang< gint32, int >(in.periode);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Periode"), &arg_periode);
  auto arg_puissance = cxx2lang< double, double >(in.puissance);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Puissance"), &arg_puissance);
  auto arg_pulsations_restantes = cxx2lang< gint32, int >(in.pulsations_restantes);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "PulsationsRestantes"), &arg_pulsations_restantes);
  auto arg_pulsations_totales = cxx2lang< gint32, int >(in.pulsations_totales);
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "PulsationsTotales"), &arg_pulsations_totales);
  return moObj;
}

template <>
pulsar_info lang2cxx< MonoObject*, pulsar_info >(MonoObject* in)
{
    pulsar_info out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "PulsarInfo");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Periode"), &out.periode);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Puissance"), &out.puissance);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "PulsationsRestantes"), &out.pulsations_restantes);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "PulsationsTotales"), &out.pulsations_totales);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<pulsar_info> >(std::vector<pulsar_info> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "PulsarInfo");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, pulsar_info >(in[i])));
  return maArray;
}

template <>
std::vector<pulsar_info> lang2cxx< MonoArray*, std::vector<pulsar_info> >(MonoArray* in)
{
  std::vector< pulsar_info > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, pulsar_info >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

gint32 construire(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_construire(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 ameliorer(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_ameliorer(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 detruire(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_detruire(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 deplacer_aspiration(MonoObject* source, MonoObject* destination)
{
	return cxx2lang< gint32, erreur >(api_deplacer_aspiration(lang2cxx< MonoObject*, position >(source), lang2cxx< MonoObject*, position >(destination)))
;
}

gint32 deblayer(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_deblayer(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 type_case(MonoObject* pos)
{
	return cxx2lang< gint32, case_type >(api_type_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* liste_pulsars()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_pulsars())
;
}

MonoArray* liste_plasmas()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_plasmas())
;
}

MonoArray* liste_tuyaux()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_tuyaux())
;
}

MonoArray* liste_super_tuyaux()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_super_tuyaux())
;
}

MonoArray* liste_debris()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_liste_debris())
;
}

gint32 est_pulsar(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_pulsar(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 est_tuyau(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_tuyau(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 est_simple_tuyau(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_simple_tuyau(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 est_super_tuyau(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_super_tuyau(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 est_debris(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_debris(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 est_libre(MonoObject* pos)
{
	return cxx2lang< gint32, bool >(api_est_libre(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoObject* info_pulsar(MonoObject* pos)
{
	return cxx2lang< MonoObject*, pulsar_info >(api_info_pulsar(lang2cxx< MonoObject*, position >(pos)))
;
}

double charges_presentes(MonoObject* pos)
{
	return cxx2lang< double, double >(api_charges_presentes(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 constructeur_tuyau(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_constructeur_tuyau(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 proprietaire_base(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_proprietaire_base(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* ma_base()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_ma_base())
;
}

MonoArray* base_ennemie()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_base_ennemie())
;
}

gint32 puissance_aspiration(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_puissance_aspiration(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* directions_plasma(MonoObject* pos)
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_directions_plasma(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 cout_prochaine_modification_aspiration()
{
	return cxx2lang< gint32, int >(api_cout_prochaine_modification_aspiration())
;
}

MonoArray* hist_tuyaux_construits()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_tuyaux_construits())
;
}

MonoArray* hist_tuyaux_detruits()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_tuyaux_detruits())
;
}

MonoArray* hist_tuyaux_ameliores()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_tuyaux_ameliores())
;
}

MonoArray* hist_debris_deblayes()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_debris_deblayes())
;
}

MonoArray* hist_points_aspiration_ajoutes()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_points_aspiration_ajoutes())
;
}

MonoArray* hist_points_aspiration_retires()
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_hist_points_aspiration_retires())
;
}

gint32 moi()
{
	return cxx2lang< gint32, int >(api_moi())
;
}

gint32 adversaire()
{
	return cxx2lang< gint32, int >(api_adversaire())
;
}

gint32 points_action()
{
	return cxx2lang< gint32, int >(api_points_action())
;
}

gint32 score(gint32 id_joueur)
{
	return cxx2lang< gint32, int >(api_score(lang2cxx< gint32, int >(id_joueur)))
;
}

gint32 tour_actuel()
{
	return cxx2lang< gint32, int >(api_tour_actuel())
;
}

gint32 annuler()
{
	return cxx2lang< gint32, bool >(api_annuler())
;
}

void afficher_erreur(gint32 v)
{
	api_afficher_erreur(lang2cxx< gint32, erreur >(v))
;
}

void afficher_case_type(gint32 v)
{
	api_afficher_case_type(lang2cxx< gint32, case_type >(v))
;
}

void afficher_position(MonoObject* v)
{
	api_afficher_position(lang2cxx< MonoObject*, position >(v))
;
}

void afficher_pulsar_info(MonoObject* v)
{
	api_afficher_pulsar_info(lang2cxx< MonoObject*, pulsar_info >(v))
;
}


/*
** Inititialize Mono and load the DLL file.
*/
CSharpInterface::CSharpInterface()
{
  const char* champion_path = getenv("CHAMPION_PATH");
  std::string champion;

  if (!champion_path)
    champion = "./champion-prologin.dll";
  else
  {
    champion = champion_path;
    champion += "/champion-prologin.dll";
  }

  _domain = mono_jit_init(champion.c_str());
  assert(_domain != NULL);

  _assembly = mono_domain_assembly_open(_domain, champion.c_str());
  assert(_assembly != NULL);

  _image = mono_assembly_get_image(_assembly);
  assert(_image != NULL);

  _class = mono_class_from_name(_image, "Prologin", "Prologin");
  assert(_class != NULL);

  _object = mono_object_new(_domain, _class);
  assert(_object);

  mono_runtime_object_init(_object);

  // Register API functions as internal Mono functions
  mono_add_internal_call("Prologin.Api::Construire", (const void*)construire);
  mono_add_internal_call("Prologin.Api::Ameliorer", (const void*)ameliorer);
  mono_add_internal_call("Prologin.Api::Detruire", (const void*)detruire);
  mono_add_internal_call("Prologin.Api::DeplacerAspiration", (const void*)deplacer_aspiration);
  mono_add_internal_call("Prologin.Api::Deblayer", (const void*)deblayer);
  mono_add_internal_call("Prologin.Api::TypeCase", (const void*)type_case);
  mono_add_internal_call("Prologin.Api::ListePulsars", (const void*)liste_pulsars);
  mono_add_internal_call("Prologin.Api::ListePlasmas", (const void*)liste_plasmas);
  mono_add_internal_call("Prologin.Api::ListeTuyaux", (const void*)liste_tuyaux);
  mono_add_internal_call("Prologin.Api::ListeSuperTuyaux", (const void*)liste_super_tuyaux);
  mono_add_internal_call("Prologin.Api::ListeDebris", (const void*)liste_debris);
  mono_add_internal_call("Prologin.Api::EstPulsar", (const void*)est_pulsar);
  mono_add_internal_call("Prologin.Api::EstTuyau", (const void*)est_tuyau);
  mono_add_internal_call("Prologin.Api::EstSimpleTuyau", (const void*)est_simple_tuyau);
  mono_add_internal_call("Prologin.Api::EstSuperTuyau", (const void*)est_super_tuyau);
  mono_add_internal_call("Prologin.Api::EstDebris", (const void*)est_debris);
  mono_add_internal_call("Prologin.Api::EstLibre", (const void*)est_libre);
  mono_add_internal_call("Prologin.Api::InfoPulsar", (const void*)info_pulsar);
  mono_add_internal_call("Prologin.Api::ChargesPresentes", (const void*)charges_presentes);
  mono_add_internal_call("Prologin.Api::ConstructeurTuyau", (const void*)constructeur_tuyau);
  mono_add_internal_call("Prologin.Api::ProprietaireBase", (const void*)proprietaire_base);
  mono_add_internal_call("Prologin.Api::MaBase", (const void*)ma_base);
  mono_add_internal_call("Prologin.Api::BaseEnnemie", (const void*)base_ennemie);
  mono_add_internal_call("Prologin.Api::PuissanceAspiration", (const void*)puissance_aspiration);
  mono_add_internal_call("Prologin.Api::DirectionsPlasma", (const void*)directions_plasma);
  mono_add_internal_call("Prologin.Api::CoutProchaineModificationAspiration", (const void*)cout_prochaine_modification_aspiration);
  mono_add_internal_call("Prologin.Api::HistTuyauxConstruits", (const void*)hist_tuyaux_construits);
  mono_add_internal_call("Prologin.Api::HistTuyauxDetruits", (const void*)hist_tuyaux_detruits);
  mono_add_internal_call("Prologin.Api::HistTuyauxAmeliores", (const void*)hist_tuyaux_ameliores);
  mono_add_internal_call("Prologin.Api::HistDebrisDeblayes", (const void*)hist_debris_deblayes);
  mono_add_internal_call("Prologin.Api::HistPointsAspirationAjoutes", (const void*)hist_points_aspiration_ajoutes);
  mono_add_internal_call("Prologin.Api::HistPointsAspirationRetires", (const void*)hist_points_aspiration_retires);
  mono_add_internal_call("Prologin.Api::Moi", (const void*)moi);
  mono_add_internal_call("Prologin.Api::Adversaire", (const void*)adversaire);
  mono_add_internal_call("Prologin.Api::PointsAction", (const void*)points_action);
  mono_add_internal_call("Prologin.Api::Score", (const void*)score);
  mono_add_internal_call("Prologin.Api::TourActuel", (const void*)tour_actuel);
  mono_add_internal_call("Prologin.Api::Annuler", (const void*)annuler);
  mono_add_internal_call("Prologin.Api::AfficherErreur", (const void*)afficher_erreur);
  mono_add_internal_call("Prologin.Api::AfficherCaseType", (const void*)afficher_case_type);
  mono_add_internal_call("Prologin.Api::AfficherPosition", (const void*)afficher_position);
  mono_add_internal_call("Prologin.Api::AfficherPulsarInfo", (const void*)afficher_pulsar_info);
}

MonoImage* CSharpInterface::getImage()
{
    return _image;
}

MonoDomain* CSharpInterface::getDomain()
{
    return _domain;
}

CSharpInterface::~CSharpInterface()
{
  mono_image_close(_image);
  mono_assembly_close(_assembly);
  // XXX -- mono segfaults when calling this. Seems to be a known bug
  //        appearing when mono_jit_clean() is called from a dtor. ???
  //mono_jit_cleanup(_domain);
}

/*
** Calls C# functions from C++
*/
MonoObject* CSharpInterface::callCSharpMethod(const char* name)
{
  MonoThread*   thread = mono_thread_attach(_domain);
  MonoMethod*   method = mono_class_get_method_from_name(_class, name, 0);
  MonoObject*   object = mono_runtime_invoke(method, _object, NULL, NULL);

  mono_thread_detach(thread);

  return object;
}

/*
** Functions called from stechec to C.
*/
void partie_init()
{
  gl_csharp.callCSharpMethod("PartieInit");
}
void jouer_tour()
{
  gl_csharp.callCSharpMethod("JouerTour");
}
void partie_fin()
{
  gl_csharp.callCSharpMethod("PartieFin");
}
