import java.util.ArrayList;

public class Prologin extends Interface {

	Position cible;
	boolean fromBase;

	// Fonction appelée au début de la partie.
	public void partie_init() {
		// API.moi();
		System.out.println("Player " + API.moi() + ": Begin");
		API.init();
	}

	public void printMap() {
		Position p = new Position();
		System.out.println("Printing");
		for (int y = 0; y < 39; y++) {
			for (int x = 0; x < 39; x++) {
				p.x = x;
				p.y = y;
				System.err.print(" " + (API.est_libre(p) ? 1 : 0));
			}
			System.err.println();
		}
	}

	public Position position(int x, int y) {
		Position p = new Position();
		p.x = x;
		p.y = y;
		return p;
	}

	public void printArray(int[][] array)
	{
		for(int y = 0 ; y < array.length ; y++)
		{
			for (int i = 0; i < array[y].length; i++) {
				if(array[y][i] == -3)
					System.out.print(" .");
				else
					System.out.print((array[y][i]<0?"":" ")+array[y][i]);
			}
			System.out.println();
		}
	}
	
	public int distanceToRealBase(Position p)
	{
		int minDistToBase = -1;
		for(Position base : API.ma_base())
		{
			int distance = Math.abs(p.x-base.x)+Math.abs(p.y-base.y);
			if(distance < minDistToBase || minDistToBase == -1)
			{
				minDistToBase = distance;
			}
		}
		return minDistToBase;
	}

	boolean fromBaseTmp = false;
	Position pipeNotBaseTmp;
	int[][] distanceCache;
	public float distanceToBase(Position p, int[][] pipes) {
		int minDistToBase = distanceToRealBase(p);
		
		float minDistToPipe = -1;
		for (int i = 0; i < pipes.length; i++) {
			for (int j = 0; j < pipes.length; j++) {
				if(pipes[i][j] == 1 && API.est_tuyau(position(j, i)))
				{
					float distance = Math.abs(p.x-j)+Math.abs(p.y-i);
					distance += distanceCache[i][j];
					if(distance < minDistToPipe || minDistToPipe == -1)
					{
						minDistToPipe = distance;
						pipeNotBaseTmp = position(j, i);
					}
				}
			}
		}
		
		if(Math.abs(minDistToBase-minDistToPipe) > 6)
		{
			fromBaseTmp = true;
			return minDistToBase;
		}
		fromBaseTmp = false;
		
		return minDistToPipe;
	}

	public boolean isEntoure(Position pulsar) {
		boolean toReturn = true;
		Position toChange = new Position();
		toChange.x = pulsar.x - 1;
		toChange.y = pulsar.y - 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x;
		toChange.y = pulsar.y - 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x + 1;
		toChange.y = pulsar.y - 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x - 1;
		toChange.y = pulsar.y;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x - 1;
		toChange.y = pulsar.y + 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x;
		toChange.y = pulsar.y + 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x + 1;
		toChange.y = pulsar.y + 1;
		toReturn &= !API.est_libre(toChange);

		toChange.x = pulsar.x + 1;
		toChange.y = pulsar.y;
		toReturn &= !API.est_libre(toChange);

		return toReturn;
	}

	Position pipeNotBase;
	public Position getBestPulsar(int[][] pipes) {
		double max = 0.0000001;
		Position nearestPulsar = null;
		boolean fromBaseOrNot = false;
		Position pipeNotBaseOrNot = null;
		for (Position p : API.liste_pulsars()) {
			if (isEntoure(p))
				continue;
			float distance = distanceToBase(p, pipes);
			PulsarInfo info = API.info_pulsar(p);
			int modulo = API.tour_actuel() % info.periode;
			modulo = info.periode - modulo;
			double score = info.puissance * (info.pulsations_restantes - ((modulo < 4) ? 1 : 0));
			score /= distance/3;
			
			if (score > max) {
				pipeNotBaseOrNot = pipeNotBaseTmp;
				max = score;
				fromBaseOrNot = fromBaseTmp;
				nearestPulsar = p;
			}
		}
		fromBase = fromBaseOrNot;
		pipeNotBase = pipeNotBaseOrNot;
		return nearestPulsar;
	}

	public int[][] buildInitMap()
	{
		int[][] pipes = new int[39][39];

		for (int y = 0; y < pipes.length; y++) {
			for (int x = 0; x < pipes.length; x++) {
				if (!API.est_tuyau(position(x, y)))
					pipes[y][x] = -3;
				else
					pipes[y][x] = 0;
			}
		}
		
		return pipes;
	}
	
	public int[][] getPipesArray(int[][] initMap) {
		int[][] pipes = initMap;

		for (Position p : API.ma_base()) {
			int puissance = API.puissance_aspiration(p);
			pipes[p.y][p.x] = 4;
			for(int k = puissance ; k > 0 ; k--)
			{
				for (int y = 0; y < pipes.length; y++) {
					for (int x = 0; x < pipes.length; x++) {
						if (pipes[y][x] == 4) {
							pipes[y][x] = 3;
							for (int[] direction : ways) {
								int ycor = y + direction[0];
								int xcor = x + direction[1];
								if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
									if (pipes[ycor][xcor] == 0 || pipes[ycor][xcor] == 2) {
										pipes[ycor][xcor] = 5;
									}
								}
							}
						}
					}
				}
				for (int y = 0; y < pipes.length; y++) {
					for (int x = 0; x < pipes.length; x++) {
						if (pipes[y][x] == 5) {
							pipes[y][x] = 4;
						}
					}
				}
			}
			for (int y = 0; y < pipes.length; y++) {
				for (int x = 0; x < pipes.length; x++) {
					if (pipes[y][x] == 3 || pipes[y][x] == 4) {
						pipes[y][x] = 2;
					}
				}
			}
		}

		for (Position p : API.base_ennemie()) {
			int puissance = API.puissance_aspiration(p);
			pipes[p.y][p.x] = 4;
			for(int k = puissance ; k > 0 ; k--)
			{
				for (int y = 0; y < pipes.length; y++) {
					for (int x = 0; x < pipes.length; x++) {
						if (pipes[y][x] == 4) {
							pipes[y][x] = 3;
							for (int[] direction : ways) {
								int ycor = y + direction[0];
								int xcor = x + direction[1];
								if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
									if (pipes[ycor][xcor] == 0 || pipes[ycor][xcor] == 2) {
										pipes[ycor][xcor] = 5;
									}
								}
							}
						}
					}
				}
				for (int y = 0; y < pipes.length; y++) {
					for (int x = 0; x < pipes.length; x++) {
						if (pipes[y][x] == 5) {
							pipes[y][x] = 4;
						}
					}
				}
			}
			for (int y = 0; y < pipes.length; y++) {
				for (int x = 0; x < pipes.length; x++) {
					if (pipes[y][x] == 3 || pipes[y][x] == 4) {
						pipes[y][x] = -2;
					}
				}
			}
		}

		
		boolean continuer = true;
		while (continuer)
		{
			continuer = false;
			for (int y = 0; y < pipes.length; y++) {
				for (int x = 0; x < pipes.length; x++) {
					if (pipes[y][x] == 2) {
						continuer = true;
						pipes[y][x] = 1;
						for (int[] direction : ways) {
							int ycor = y + direction[0];
							int xcor = x + direction[1];
							if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
								if (pipes[ycor][xcor] == 0) {
									pipes[ycor][xcor] = 56;
								}
								if (pipes[ycor][xcor] == -92) {
									pipes[ycor][xcor] = -10;
								}
							}
						}
					}
					if (pipes[y][x] == -2) {
						continuer = true;
						pipes[y][x] = -1;
						for (int[] direction : ways) {
							int ycor = y + direction[0];
							int xcor = x + direction[1];
							if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
								if (pipes[ycor][xcor] == 0) {
									pipes[ycor][xcor] = -92;
								}
								if (pipes[ycor][xcor] == 56) {
									pipes[ycor][xcor] = -10;
								}
							}
						}
					}
				}
			}
			
			for (int y = 0; y < pipes.length; y++) {
				for (int x = 0; x < pipes.length; x++) {
					if (pipes[y][x] == 56)
						pipes[y][x] = 2;
					if(pipes[y][x] == -92)
						pipes[y][x] = -2;
				}
			}
		}

		for (int y = 0; y < pipes.length; y++) {
			for (int x = 0; x < pipes.length; x++) {
				if (pipes[y][x] == -10) {
					pipes[y][x] = 0;
				}
			}
		}
		return pipes;
	}
	// faire un array des tuyaux qui "M'appartiennent"
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

	// faire la distance au tuyaux qui m'appartient le + proche
	// reconstruire les tuyaux qui m'appartiennent

	public int buildPipeTo(Position pulsar, int[][] pipes, int action) {
		int[][] map = new int[39][39];

		for (int y = 0; y < map.length; y++) {
			for (int x = 0; x < map.length; x++) {
				if (API.est_libre(position(x, y)) || API.est_debris(position(x, y)) || API.est_tuyau(position(x, y)))
					map[y][x] = -1;
				else
					map[y][x] = -2;
			}
		}
		if(fromBase)
		{
			for(Position p2 : API.ma_base())
			{
				map[p2.y][p2.x] = -3;
			}
		}
		else
		{
			map[pipeNotBase.y][pipeNotBase.x] = -3;
		}

		map[pulsar.y][pulsar.x] = 0;
		int k = 0;
		int startx = 0, starty = 0;
		mainloop: for (k = 0; k < 100; k++) {
			for (int y = 0; y < map.length; y++) {
				for (int x = 0; x < map.length; x++) {
					if (map[y][x] == k) {
						for (int[] direction : ways) {
							int ycor = y + direction[0];
							int xcor = x + direction[1];
							if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
								if (map[ycor][xcor] == -3) {
									startx = x;
									starty = y;
									break mainloop;
								}
								if (map[ycor][xcor] == -1) {
									map[ycor][xcor] = k + 1;
								}
							}
						}
					}
				}
			}
		}
		if (k == 100)
			return -1;

		while (k > 0 && action > 0) {
			Position actuelle = position(startx, starty);
			if (API.est_debris(actuelle)) {
				action -= 3;
				API.deblayer(actuelle);
				API.construire(actuelle);
			}
			if (API.est_libre(actuelle)) {
				action -= 1;
				API.construire(actuelle);
			}
			for (int[] direction : ways) {
				int ycor = starty + direction[0];
				int xcor = startx + direction[1];
				if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
					if (map[ycor][xcor] == k - 1) {
						startx = xcor;
						starty = ycor;
						break;
					}
				}
			}
			k -= 1;
		}
		if (action > 0) {
			for (int i = -1; i < 2; i++) {
				for (int j = -1; j < 2; j++) {
					Position decal = position(pulsar.x + i, pulsar.y + j);
					if (API.est_libre(decal)) {
						action -= 1;
						API.construire(decal);
					}
				}
			}
		}
		return action;
	}

	public void detruirePipes(int[][] pipes)
	{
		double min = 1000;
		Position maxKill = null;
		int count = 0;
		
		for (int i = 0; i < pipes.length; i++) {
			for (int j = 0; j < pipes.length; j++) {
				if(pipes[i][j] == -1)
				{
					count += 1;
				}
			}
		}
		
		for (int i = 0; i < pipes.length; i++) {
			for (int j = 0; j < pipes.length; j++) {
				if(pipes[i][j] == -1)
				{
					Position pcur = position(j, i);
					int sum = nbPipes(pcur, pipes, -1);
					
					
					if(sum == 2)
					{
						int[][] pipesMod = buildInitMap();
						
						pipesMod[i][j] = -3;
						getPipesArray(pipesMod);
						
						int score = 0;
						
						for (int k = 0; k < pipesMod.length; k++) {
							for (int j2 = 0; j2 < pipesMod.length; j2++) {
								int value = pipesMod[k][j2];
								if(value == -1)
								{
									score += 1;
								}
							}
						}
						score = score-count;
						
						if(score < min)
						{
							maxKill = pcur;
							min = score;
						}
					}
				}
			}
		}
		if(maxKill != null && min < -15)
		{
			API.detruire(maxKill);
		}
	}
	
	public void buildDistanceCache()
	{
		distanceCache = buildInitMap();
		for (int i = 0; i < distanceCache.length; i++) {
			for (int j = 0; j < distanceCache.length; j++) {
				if(distanceCache[i][j] == 0)
				{
					distanceCache[i][j] = -1;
				}
			}
		}
		for(Position p2 : API.ma_base())
		{
			distanceCache[p2.y][p2.x] = 0;
		}
		int k = 0;
		boolean continuer;
		do {
			continuer = false;
			for (int y = 0; y < distanceCache.length; y++) {
				for (int x = 0; x < distanceCache.length; x++) {
					if (distanceCache[y][x] == k) {
						for (int[] direction : ways) {
							int ycor = y + direction[0];
							int xcor = x + direction[1];
							if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
								if (distanceCache[ycor][xcor] == -1) {
									distanceCache[ycor][xcor] = k + 1;
									continuer = true;
								}
							}
						}
					}
				}
			}
			k+=1;
		}while(continuer);
	}
	
	public void aspirationPipe()
	{
		ArrayList<Position> toAspire = new ArrayList<Position>();
		int min = 1000;
		Position minP = null;
		for(Position p : API.ma_base())
		{
			int puissance = API.puissance_aspiration(p);
			if(puissance == 5)
				continue;
			
			Position tuyauNext = null;
			if(p.x == 0)
			{
				tuyauNext = position(p.x+1, p.y);
			}
			if(p.x == 38)
			{
				tuyauNext = position(p.x-1, p.y);
			}
			if(API.est_tuyau(tuyauNext))
			{
				toAspire.add(p);
			}
			else
			{
				if(puissance < min && puissance > 0)
				{
					min = puissance;
					minP = p;
				}
			}
		}
		
		if(toAspire.isEmpty() || minP == null)
			return;
		
		API.deplacer_aspiration(minP, toAspire.get(0));
	}
	
	public int ameliorerPipes(int action, int[][] pipes)
	{
		int sum = 1;
		while(action > 0 && sum > 0)
		{
			sum = 0;
			for (int i = 0; i < pipes.length; i++) {
				for (int j = 0; j < pipes.length; j++) {
					if(pipes[i][j] == 1 && API.est_tuyau(position(j, i)) && !API.est_super_tuyau(position(j ,i)))
					{
						sum += 1;
					}
				}
			}
			//System.out.println(sum);
			int random = (int)(Math.random()*sum+1);
			int count = 0;
			loop:
			for (int i = 0; i < pipes.length; i++) {
				for (int j = 0; j < pipes.length; j++) {
					if(pipes[i][j] == 1 && API.est_tuyau(position(j, i)) && !API.est_super_tuyau(position(j ,i)))
					{
						count += 1;
					}
					if(count == random)
					{
						API.ameliorer(position(j, i));
						action -= 1;
						break loop;
					}
				}
			}
		}
		return action;
	}
	int[][] ways = { { -1, 0 }, { 0, -1 }, { 1, 0 }, { 0, 1 } };
	
	public int nbPipes(Position p, int[][] pipes, int check)
	{
		int sum = 0;
		for (int[] direction : ways) {
			int ycor = p.y + direction[0];
			int xcor = p.x + direction[1];
			if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) {
				if(pipes[ycor][xcor] == check)
				{
					sum += 1;
				}
			}
		}
		return sum;
	}
	
	public int reparerPipes(int action, int[][] pipes)
	{
		for (int i = 0; i < pipes.length; i++) {
			for (int j = 0; j < pipes.length; j++) {
				if(API.est_debris(position(j, i)))
				{
					int sum = nbPipes(position(j, i), pipes, 1);
					if(sum >= 1)
					{
						API.deblayer(position(j, i));
						action -= 2;
						API.construire(position(j, i));
						action -= 1;

						while(action > 0)
						{
							int max = 0;
							Position best = null;
							for(int decaly = -1 ; decaly < 2 ; decaly++)
							{
								for(int decalx = -1 ; decalx < 2 ; decalx++)
								{
									int ycor = i + decaly;
									int xcor = j + decalx;
									Position p3 = new Position();
									p3.x = xcor;
									p3.y = ycor;	
									if (ycor >= 0 && ycor < 39 && xcor >= 0 && xcor < 39) 
									{
										if(API.est_libre(p3))
										{
											int sum2 = nbPipes(p3, pipes, 1);
											if(sum2 > max)
											{
												max = sum2;
												best = p3;
											}
										}
									}
								}
							}
							
							if(best == null)
								break;
							API.construire(best);
							action -= 1;
						}
					}
				}
			}
		}
		
		return action;
	}
	
	boolean firstTurn = true;
	// Fonction appelée à chaque tour.
	public void jouer_tour() {

		int[][] pipes = getPipesArray(buildInitMap());
		//if(API.tour_actuel()>20 && Math.random()>.2)
		//	detruirePipes(pipes);
		//System.out.println(API.moi());
		detruirePipes(pipes);
		/*if(API.moi() == 2 && API.tour_actuel() > 15 && Interface.score(API.moi()) > 10)
		{
			
		}*/
		int action = 4;
		
		aspirationPipe();

		reparerPipes(action, pipes);

		if (firstTurn || (cible != null && isEntoure(cible))) {
			firstTurn = false;
			buildDistanceCache();
			cible = getBestPulsar(pipes);
		}
		
		while(action > 0 && cible != null)
		{
			action = buildPipeTo(cible, pipes, action);
			
			if(isEntoure(cible))
			{
				buildDistanceCache();
				cible = getBestPulsar(pipes);
			}
			
			System.out.println(action);
		}
		
		//detruirePipes(pipes);
		
		ameliorerPipes(action, pipes);
		
	}

	// Fonction appelée à la fin de la partie.
	public void partie_fin() {
		// Place ton code ici
	}
}
