// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

// Erreurs possibles
enum Erreur {
  OK, // <- L'action a été exécutée avec succès.
  PA_INSUFFISANTS, // <- Vous ne possédez pas assez de points d'action pour cette action.
  AUCUN_TUYAU, // <- Il n'y a pas de tuyau à la position spécifiée.
  POSITION_INVALIDE, // <- La position spécifiée est hors de la carte.
  PUISSANCE_INSUFFISANTE, // <- Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base.
  DEPLACEMENT_INVALIDE, // <- Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même.
  PAS_DANS_BASE, // <- Cette case n'appartient pas à votre base.
  AMELIORATION_IMPOSSIBLE, // <- Il y a déjà un Super Tuyau™ sur cette case.
  CONSTRUCTION_IMPOSSIBLE, // <- Il est impossible de construire un tuyau à la position indiquée.
  DESTRUCTION_IMPOSSIBLE, // <- Il n'y a pas de tuyau à la position spécifiée.
  PAS_DE_PULSAR, // <- Il n'y a pas de pulsar à la position spécifiée.
  PAS_DE_DEBRIS, // <- Il n'y a pas de débris à la position spécifiée.
  CHARGE_INSUFFISANTE, // <- Vous ne possédez pas assez de plasma pour lancer une destruction.
  LIMITE_ASPIRATION_ATTEINTE, // <- Vous avez atteint la limite d'aspiration sur cette case.
}

// Types de cases
enum CaseType {
  VIDE, // <- Case vide
  TUYAU, // <- Case contenant un tuyau
  SUPER_TUYAU, // <- Case contenant un Super Tuyau™
  DEBRIS, // <- Case contenant des débris à déblayer
  PULSAR, // <- Case contenant un pulsar
  BASE, // <- Case appartenant à une base d'un des joueurs
  INTERDIT, // <- Case où aucune action n'est possible
}

// Position sur la carte, donnée par deux coordonnées.
class Position {
  public int x; // Coordonnée en X
  public int y; // Coordonnée en Y
}

// Représente un pulsar existant.
class PulsarInfo {
  public int periode; // Période de pulsation du pulsar
  public double puissance; // Quantité de plasma émise par chaque pulsation dans chaque direction
  public int pulsations_restantes; // Nombre de pulsations restantes
  public int pulsations_totales; // Nombre total de pulsations au début de la partie
}

public class Interface
{
  // Taille du terrain (longueur et largeur).
  public static final int TAILLE_TERRAIN = 39;

  // Longueur de chacune de vos deux bases.
  public static final int LONGUEUR_BASE = 13;

  // Nombre de tours à jouer avant la fin de la partie.
  public static final int NB_TOURS = 100;

  // Nombre de points d'action par tour.
  public static final int NB_POINTS_ACTION = 4;

  // Nombre de points d'action que coûte la construction d'un tuyau.
  public static final int COUT_CONSTRUCTION = 1;

  // Nombre de points d'action que coûte l'amélioration d'un tuyau.
  public static final int COUT_AMELIORATION = 1;

  // Nombre de points d'action que coûte la destruction d'un tuyau.
  public static final int COUT_DESTRUCTION = 3;

  // Nombre de points d'action que coûte la destruction d'un Super Tuyau™.
  public static final int COUT_DESTRUCTION_SUPER_TUYAU = 4;

  // Charge en plasma nécessaire pour la destruction d'un tuyau ou d'un Super Tuyau™.
  public static final double CHARGE_DESTRUCTION = 2.0;

  // Nombre de points d'action que coûte le déblayage d'une case de débris.
  public static final int COUT_DEBLAYAGE = 2;

  // Nombre de points d'action que coûte le déplacement d'une unité de puissance d'aspiration de la base (la première modification de chaque tour est offerte).
  public static final int COUT_MODIFICATION_ASPIRATION = 1;

  // Limite de puissance d'aspiration sur une case de base.
  public static final int LIMITE_ASPIRATION = 5;

  // Vitesse du plasma dans un tuyau normal, en nombre de cases par tour.
  public static final int VITESSE_TUYAU = 1;

  // Multiplicateur de la vitesse du plasma dans un Super Tuyau™.
  public static final int MULTIPLICATEUR_VITESSE_SUPER_TUYAU = 2;

// Construit un tuyau sur une case donnée.
  public static native Erreur construire(Position pos);

// Améliore un tuyau en Super Tuyau™.
  public static native Erreur ameliorer(Position pos);

// Détruit un tuyau sur une case donnée.
  public static native Erreur detruire(Position pos);

// Déplace une unité de puissance d'aspiration d'une case de votre base vers une autre.
  public static native Erreur deplacer_aspiration(Position source, Position destination);

// Déblaye une case de débris.
  public static native Erreur deblayer(Position pos);

// Renvoie le type d'une case donnée.
  public static native CaseType type_case(Position pos);

// Renvoie la liste de tous les pulsars présents.
  public static native Position[] liste_pulsars();

// Renvoie la liste des cases contenant du plasma.
  public static native Position[] liste_plasmas();

// Renvoie la liste des cases contenant un tuyau ou Super Tuyau™.
  public static native Position[] liste_tuyaux();

// Renvoie la liste des cases contenant un Super Tuyau™.
  public static native Position[] liste_super_tuyaux();

// Renvoie la liste des cases contenant des débris.
  public static native Position[] liste_debris();

// Renvoie vrai si et seulement si la case contient un pulsar.
  public static native boolean est_pulsar(Position pos);

// Renvoie vrai si et seulement si la case contient un tuyau ou un Super Tuyau™.
  public static native boolean est_tuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un simple tuyau.
  public static native boolean est_simple_tuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un Super Tuyau™.
  public static native boolean est_super_tuyau(Position pos);

// Renvoie vrai si et seulement si la case contient un débris.
  public static native boolean est_debris(Position pos);

// Renvoie vrai si et seulement s'il est possible de construire sur cette case.
  public static native boolean est_libre(Position pos);

// Renvoie les informations propres au pulsar à la position donnée.
  public static native PulsarInfo info_pulsar(Position pos);

// Renvoie la quantité de plasma sur une case donnée.
  public static native double charges_presentes(Position pos);

// Renvoie le numéro du joueur ayant dernièrement construit ou amélioré un tuyau sur une case.
  public static native int constructeur_tuyau(Position pos);

// Renvoie le numéro du propriétaire d'une case de base.
  public static native int proprietaire_base(Position pos);

// Renvoie la liste des cases composant votre base.
  public static native Position[] ma_base();

// Renvoie la liste des cases composant la base de votre ennemi.
  public static native Position[] base_ennemie();

// Renvoie la puissance d'aspiration d'une case de base donnée. Renvoie -1 si la position n'est pas celle d'une base.
  public static native int puissance_aspiration(Position pos);

// Renvoie pour une case donnée la liste des cases vers lesquelles le plasma se propagera. Renvoie la liste vide si la case n'est pas une case contenant un tuyau ou si elle n'est reliée à aucune base.
  public static native Position[] directions_plasma(Position pos);

// Renvoie la valeur du coût de la prochaine modification de vos puissances d'aspiration.
  public static native int cout_prochaine_modification_aspiration();

// Renvoie la liste des tuyaux construits par votre adversaire au dernier tour.
  public static native Position[] hist_tuyaux_construits();

// Renvoie la liste des tuyaux détruits par votre adversaire au dernier tour.
  public static native Position[] hist_tuyaux_detruits();

// Renvoie la liste des tuyaux améliorés par votre adversaire au dernier tour.
  public static native Position[] hist_tuyaux_ameliores();

// Renvoie la liste des débris déblayés par votre adversaire au dernier tour.
  public static native Position[] hist_debris_deblayes();

// Renvoie la liste des cases de base de votre adversaire qui ont reçu un point d'aspiration (une même case peut apparaître plusieurs fois).
  public static native Position[] hist_points_aspiration_ajoutes();

// Renvoie la liste des cases de base de votre adversaire qui ont perdu un point d'aspiration (une même case peut apparaître plusieurs fois).
  public static native Position[] hist_points_aspiration_retires();

// Renvoie votre numéro de joueur.
  public static native int moi();

// Renvoie le numéro de votre adversaire.
  public static native int adversaire();

// Indique votre nombre de points d'actions restants pour ce tour-ci.
  public static native int points_action();

// Renvoie le score du joueur désigné par le numéro ``id_joueur``. Renvoie -1 si ``id_joueur`` est invalide.
  public static native int score(int id_joueur);

// Renvoie le numéro du tour actuel.
  public static native int tour_actuel();

// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
  public static native boolean annuler();

// Affiche le contenu d'une valeur de type erreur
  public static native void afficher_erreur(Erreur v);

// Affiche le contenu d'une valeur de type case_type
  public static native void afficher_case_type(CaseType v);

// Affiche le contenu d'une valeur de type position
  public static native void afficher_position(Position v);

// Affiche le contenu d'une valeur de type pulsar_info
  public static native void afficher_pulsar_info(PulsarInfo v);

}
