/// This file has been generated, if you wish to
/// modify it in a permanent way, please refer
/// to the script file : gen/generator_haskell.rb

#include <stdbool.h>
/// Erreurs possibles
typedef enum erreur {
  OK, /* <- L'action a été exécutée avec succès. */
  PA_INSUFFISANTS, /* <- Vous ne possédez pas assez de points d'action pour cette action. */
  AUCUN_TUYAU, /* <- Il n'y a pas de tuyau à la position spécifiée. */
  POSITION_INVALIDE, /* <- La position spécifiée est hors de la carte. */
  PUISSANCE_INSUFFISANTE, /* <- Vous ne possédez pas assez de puissance d'asipration sur cette partie de la base. */
  DEPLACEMENT_INVALIDE, /* <- Vous ne pouvez pas déplacer de la puissance d'aspiration d'une case à elle-même. */
  PAS_DANS_BASE, /* <- Cette case n'appartient pas à votre base. */
  AMELIORATION_IMPOSSIBLE, /* <- Il y a déjà un Super Tuyau™ sur cette case. */
  CONSTRUCTION_IMPOSSIBLE, /* <- Il est impossible de construire un tuyau à la position indiquée. */
  DESTRUCTION_IMPOSSIBLE, /* <- Il n'y a pas de tuyau à la position spécifiée. */
  PAS_DE_PULSAR, /* <- Il n'y a pas de pulsar à la position spécifiée. */
  PAS_DE_DEBRIS, /* <- Il n'y a pas de débris à la position spécifiée. */
  CHARGE_INSUFFISANTE, /* <- Vous ne possédez pas assez de plasma pour lancer une destruction. */
  LIMITE_ASPIRATION_ATTEINTE, /* <- Vous avez atteint la limite d'aspiration sur cette case. */
} erreur;


/// Types de cases
typedef enum case_type {
  VIDE, /* <- Case vide */
  TUYAU, /* <- Case contenant un tuyau */
  SUPER_TUYAU, /* <- Case contenant un Super Tuyau™ */
  DEBRIS, /* <- Case contenant des débris à déblayer */
  PULSAR, /* <- Case contenant un pulsar */
  BASE, /* <- Case appartenant à une base d'un des joueurs */
  INTERDIT, /* <- Case où aucune action n'est possible */
} case_type;


struct position;
struct pulsar_info;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

/// Position sur la carte, donnée par deux coordonnées.
typedef struct position {
  int x;  /* <- Coordonnée en X */
  int y;  /* <- Coordonnée en Y */
} position;


/// Représente un pulsar existant.
typedef struct pulsar_info {
  int periode;  /* <- Période de pulsation du pulsar */
  double puissance;  /* <- Quantité de plasma émise par chaque pulsation dans chaque direction */
  int pulsations_restantes;  /* <- Nombre de pulsations restantes */
  int pulsations_totales;  /* <- Nombre total de pulsations au début de la partie */
} pulsar_info;


