(***********)
(* Globals *)
(***********)

module G = struct
    open Api

    let map = Array.make_matrix taille_terrain taille_terrain Interdit
    let flow_map = Array.make_matrix taille_terrain taille_terrain []
    let power_map = Array.make_matrix taille_terrain taille_terrain false

    let pulsars = Array.to_list (liste_pulsars ())

    let moi = moi ()
end


(*********)
(* Utils *)
(*********)

let sort score l = List.sort (fun a b -> score a - score b) l

let exists p arr =
    let rec loop i = i >= 0 && (p arr.(i) || loop (i - 1)) in
    loop (Array.length arr - 1)

(** Rend les positions relatives (pour hardcoder pour le joueur 1). *)
let pos : Api.position -> Api.position =
    if G.moi = 2 then
        fun (x, y) -> (x, y)
    else
        fun (x, y) -> (y, x)

(** Compute all the sinks to which plasma flows. *)
let rec sinks (x, y) =
    if G.map.(x).(y) = Api.Base then [(x, y)]
    else List.flatten (List.map sinks G.flow_map.(x).(y))

(** True iff some of the plasma flowing through [pos] goes to me. *)
let is_mine pos =
    List.exists (fun p -> Api.proprietaire_base p = G.moi) (sinks pos)

let load_matrix func mat =
    for i = 0 to Api.taille_terrain - 1 do
        for j = 0 to Api.taille_terrain - 1 do 
            mat.(i).(j) <- func (i, j);
        done;
    done

(** Score a point *)
let score_obj pos = 42

let list_available_objectives () =
    let objs = List.flatten (List.map (fun (x, y) ->
                                 [(x+1, y); (x, y+1); (x-1, y); (x, y-1)])
                        G.pulsars) in
    let l = List.filter (fun (x, y) -> G.power_map.(x).(y)) objs in
    List.fold_left (fun a)
    sort score_obj l

(**********)
(* Public *)
(**********)

(** Fonction appelée au début de la partie. *)
let partie_init () =
    flush stderr; flush stdout;;

(** Fonction appelée à chaque tour. *)
let jouer_tour () =
    load_matrix (Api.type_case) G.map;
    load_matrix (fun p -> Array.to_list (Api.directions_plasma p)) G.flow_map;
    load_matrix is_mine G.power_map;

    let objs = list_available_objectives () in


    flush stderr; flush stdout;;

(** Fonction appelée à la fin de la partie. *)
let partie_fin () =
    flush stderr; flush stdout;;

(* /!\ Ne touche pas a ce qui suit /!\ *)
Callback.register "ml_partie_init" partie_init;;
Callback.register "ml_jouer_tour" jouer_tour;;
Callback.register "ml_partie_fin" partie_fin;;
