///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_c.rb
//

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

///
// Position sur la carte, donnée par deux coordonnées.
//
typedef struct __internal__cxx__position {
  int x;
  int y;
} __internal__cxx__position;

///
// Représente un lien existant.
//
typedef struct __internal__cxx__lien {
  __internal__cxx__position extr1;
  __internal__cxx__position extr2;
  int joueur_l;
} __internal__cxx__lien;

///
// Représente un champ de contrôle existant.
//
typedef struct __internal__cxx__champ {
  __internal__cxx__position som1;
  __internal__cxx__position som2;
  __internal__cxx__position som3;
  int joueur_c;
} __internal__cxx__champ;

///
// Déplace votre agent sur la case passée en argument.
//
extern "C" erreur api_deplacer(__internal__cxx__position dest);

///
// Utilise un turbo.
//
extern "C" erreur api_utiliser_turbo(void);

///
// Capture le portail où est positionné votre agent.
//
extern "C" erreur api_capturer(void);

///
// Crée un lien entre le portail où se trouve votre agent et le portail de destination donné en argument.
//
extern "C" erreur api_lier(__internal__cxx__position portail);

///
// Neutralise le portail où se trouve votre agent.
//
extern "C" erreur api_neutraliser(void);

///
// Ajoute un bouclier au portail sur lequel se trouve votre agent.
//
extern "C" erreur api_ajouter_bouclier(void);

///
// Renvoie la liste de tous les liens présents.
//
extern "C" std::vector<__internal__cxx__lien> api_liste_liens(void);

///
// Renvoie la liste de tous les champs de contrôle.
//
extern "C" std::vector<__internal__cxx__champ> api_liste_champs(void);

///
// Renvoie la liste de tous les portails de la carte.
//
extern "C" std::vector<__internal__cxx__position> api_liste_portails(void);

///
// Renvoie la liste de tous les liens existants qui croisent un segment, entravant la création d'un lien.
//
extern "C" std::vector<__internal__cxx__lien> api_liens_bloquants(__internal__cxx__position ext1, __internal__cxx__position ext2);

///
// Prend les positions de deux portails, et renvoie un booléen indiquant s'ils sont reliés. Le résultat est `false` lorsque l'une des deux positions ne repère pas un portail.
//
extern "C" bool api_lien_existe(__internal__cxx__position ext1, __internal__cxx__position ext2);

///
// Renvoie un booléen indiquant si les 3 positions repèrent bien 3 portails tous reliés entre eux.
//
extern "C" bool api_champ_existe(__internal__cxx__position som1, __internal__cxx__position som2, __internal__cxx__position som3);

///
// Renvoie un booléen indiquant si la case ``pos`` se trouve dans un champ.
//
extern "C" bool api_case_dans_champ(__internal__cxx__position pos);

///
// Renvoie la liste des champs à l'intérieur desquels ``pos`` se trouve. Si la case est un portail, le résultat de ``case_champs`` sera disjoint de celui de ``champs_incidents_portail``.
//
extern "C" std::vector<__internal__cxx__champ> api_case_champs(__internal__cxx__position pos);

///
// Renvoie le numéro du joueur correspondant au portail donné, -1 si le portail est neutre, -2 si la case n'est pas un portail. Vous pouvez utiliser cette fonction pour vérifier qu'une case donnée est bien un portail.
//
extern "C" int api_portail_joueur(__internal__cxx__position portail);

///
// Renvoie le nombre de boucliers présents sur un portail (-2 si la case n'est pas un portail).
//
extern "C" int api_portail_boucliers(__internal__cxx__position portail);

///
// Renvoie la liste de tous les liens dont le portail donné est une extrémité.
//
extern "C" std::vector<__internal__cxx__lien> api_liens_incidents_portail(__internal__cxx__position portail);

///
// Renvoie la liste de tous les champs dont le portail donné est un sommet.
//
extern "C" std::vector<__internal__cxx__champ> api_champs_incidents_portail(__internal__cxx__position portail);

///
// Renvoie la liste de tous les champs dont le lien donné est un côté. Si le segment n'est pas un lien présent, renvoie la liste de tous les champs que la création du lien ferait apparaître.
//
extern "C" std::vector<__internal__cxx__champ> api_champs_incidents_segment(__internal__cxx__position ext1, __internal__cxx__position ext2);

///
// Renvoie la liste des portails capturés par votre adversaire au dernier tour.
//
extern "C" std::vector<__internal__cxx__position> api_hist_portails_captures(void);

///
// Renvoie la liste des portails neutralisés par votre adversaire au dernier tour.
//
extern "C" std::vector<__internal__cxx__position> api_hist_portails_neutralises(void);

///
// Renvoie la liste des liens créés par votre adversaire au dernier tour.
//
extern "C" std::vector<__internal__cxx__lien> api_hist_liens_crees(void);

///
// Renvoie la liste des champs créés par votre adversaire au dernier tour.
//
extern "C" std::vector<__internal__cxx__champ> api_hist_champs_crees(void);

///
// Renvoie la liste des positions où votre adversaire a ajouté des boucliers au dernier tour.
//
extern "C" std::vector<__internal__cxx__position> api_hist_boucliers_ajoutes(void);

///
// Renvoie la distance de Manhattan entre deux positions.
//
extern "C" int api_distance(__internal__cxx__position pos1, __internal__cxx__position pos2);

///
// Renvoie le nombre de points que rapporte(rait) chaque tour un champ existant ou hypothétique.
//
extern "C" int api_score_triangle(__internal__cxx__position som1, __internal__cxx__position som2, __internal__cxx__position som3);

///
// Indique si deux segments se croisent. Cette fonction correspond exactement à la condition d'interférence entre liens, c'est-à-dire qu'elle renvoie ``false`` si l'intersection est une extrémité des deux segments.
//
extern "C" bool api_intersection_segments(__internal__cxx__position a1, __internal__cxx__position a2, __internal__cxx__position b1, __internal__cxx__position b2);

///
// Indique si un point se trouve à l'intérieur d'un triangle. Le critère coïncide avec celui de ``case_champs``.
//
extern "C" bool api_point_dans_triangle(__internal__cxx__position p, __internal__cxx__position som1, __internal__cxx__position som2, __internal__cxx__position som3);

///
// Renvoie votre numéro de joueur.
//
extern "C" int api_moi(void);

///
// Renvoie le numéro de votre adversaire.
//
extern "C" int api_adversaire(void);

///
// Indique la position de l'agent du joueur désigné par le numéro ``id_joueur``.
//
extern "C" __internal__cxx__position api_position_agent(int id_joueur);

///
// Indique votre nombre de points d'actions restants pour ce tour-ci.
//
extern "C" int api_points_action(void);

///
// Indique votre nombre de points de déplacement restants pour ce tour-ci.
//
extern "C" int api_points_deplacement(void);

///
// Renvoie le score du joueur désigné par le numéro ``id_joueur``.
//
extern "C" int api_score(int id_joueur);

///
// Renvoie le numéro du tour actuel.
//
extern "C" int api_tour_actuel(void);

///
// Annule la dernière action. Renvoie ``false`` quand il n'y a pas d'action à annuler ce tour-ci.
//
extern "C" bool api_annuler(void);

///
// Affiche le contenu d'une valeur de type erreur
//
extern "C" void api_afficher_erreur(erreur v);

///
// Affiche le contenu d'une valeur de type position
//
extern "C" void api_afficher_position(__internal__cxx__position v);

///
// Affiche le contenu d'une valeur de type lien
//
extern "C" void api_afficher_lien(__internal__cxx__lien v);

///
// Affiche le contenu d'une valeur de type champ
//
extern "C" void api_afficher_champ(__internal__cxx__champ v);

#endif
