# -*- coding: utf-8 -*-
# This file has been generated, if you wish to
# modify it in a permanent way, please refer
# to the script file : gen/generator_python.rb

import heapq
from collections import defaultdict
from api import *


dist = lambda p: lambda q: distance(p, q)


signe = lambda x: 1 if x == 0 else int(x/abs(x))
mul = lambda a, p: (int(a[0]*p[0]), int(a[1]*p[1]))
add = lambda p, q: (p[0] + q[0], p[1] + q[1])
mini = lambda p, q: (min(p[0], q[0]), min(p[1], q[1]))


def delta(p, q):
    """Renvoie la valeur absolue du delta et son signe."""
    delt = add(q, mul((-1, -1), p))
    return (abs(delt[0]), abs(delt[1])), (signe(delt[0]), signe(delt[1]))


def bouger(p, q):
    """Se deplace jusqu'a la cible, ou s'en rapprocher le + possible."""

    delt, s = delta(p, q)
    d = points_deplacement()
    arrivee = add(p, mul(s, mini((d//2, (d+1)//2), delt)))
    print(arrivee, q)
    deplacer(arrivee)


class G:
    """classe des variables globales (pour eviter global a chaque modif)"""

    moi, lui = 0, 0  # IDs
    portails = []  # listes des portails
    adjacences = {}  # distances entre tt couple (frozenset) de portails
    # set des portails accessibles (eventuellement avec des turbos) pour tt
    # portail
    accessibles = defaultdict(set)

    importances = defaultdict(int)


def partie_init():
    G.moi = moi()
    G.lui = adversaire()

    G.portails = liste_portails()

    for i in range(len(G.portails)-1):
        for j in range(i+1, len(G.portails)):
            p, q = G.portails[i], G.portails[j]
            d = distance(p, q)

            G.adjacences[frozenset({p, q})] = d
            if d < 10:
                G.accessibles[p].add(q)
                G.accessibles[q].add(p)
    print("Initialisation OK!")


def jouer_tour():
    pos = position_agent(G.moi)
    if not pos in G.portails:
        plus_proche = min(
                (p for p in G.portails if not portail_joueur(p) == G.moi),
                 key=dist(pos))
        bouger(pos, plus_proche)
        neutraliser()
        capturer()
        for cible in G.portails:
            lier(cible)
        pos = plus_proche
    print('pos fin if: ', pos)


    while points_deplacement():
        print(G.accessibles[pos])
        p = min((p for p in G.accessibles[pos] if not portail_joueur(p) == G.moi),
                key=lambda p: G.adjacences[frozenset({pos, p})])
        bouger(pos, p)
        neutraliser()
        capturer()
        for cible in G.portails:
            lier(cible)
        pos = position_agent(G.moi)


def partie_fin():
    if score(G.moi) > score(G.lui):
        print("Lol t'as perduuuu!!! 42")
    elif score(G.moi) == score(G.lui):
        print("Pas trop mal, je voulais te tester...")
    else:
        print("Ma revenche sera terrible! >:O")

