# -*- coding: utf-8 -*-


import api

from utils import Armee

SCHEMA = ((1,0), (1,1), (1,2), (2,2), (3,1), (3,2), (3,3), (5,0), (6,0),
          (7,0), (7,1), (5,2), (5,3), (6,3), (7,3))

armee = Armee()

def partie_debut():
    global SCHEMA
    base = api.base_joueur(api.moi())
    if base[0] == api.TAILLE_TERRAIN - 1:
        SCHEMA = [(7 - c[0], c[1]) for c in SCHEMA]
    if base[1] == api.TAILLE_TERRAIN - 1:
        SCHEMA = [(c[0], 3 - c[1]) for c in SCHEMA]

def phase_construction():
    tour = api.tour_actuel()
    if tour == 1:
        for t in SCHEMA:
            armee.add(1, t)
    elif tour >= 10:
        for t in armee.bataillons:
            if tour % 4 == 2:
                t.fixe_cible((t.cible[0]+1, t.cible[1]))
            elif tour % 4 == 3:
                t.fixe_cible((t.cible[0], t.cible[1]+1))
            elif tour % 4 == 0:
                t.fixe_cible((t.cible[0]-1, t.cible[1]))
            elif tour % 4 == 1:
                t.fixe_cible((t.cible[0], t.cible[1]-1))
    armee.update_construction()

def phase_deplacement():
    armee.update_deplacement()

def phase_tirs():
    pass

def phase_siege():
    pass

def partie_fin():
    pass