///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb
//

#include "interface.hh"

#include <iostream>
#include <assert.h>
#include <cstdlib>
#include <cstring>

CSharpInterface gl_csharp;

template < class Out, class Cxx >
Out cxx2lang(Cxx in)
{
  return (Out)in;
}

template <>
MonoString* cxx2lang<MonoString*, std::string>(std::string in)
{
  return mono_string_new (gl_csharp.getDomain(), in.c_str());
}

template <>
gint32 cxx2lang< gint32, int >(int in)
{
  return (gint32)in;
}

template <>
gint32 cxx2lang< gint32, bool >(bool in)
{
  return (gint32)in;
}

template < class Out, class Cxx >
Cxx lang2cxx(Out in)
{
  return (Cxx)in;
}

template <>
std::string lang2cxx< MonoString*, std::string >(MonoString* in)
{
  std::string s_out;
  MonoError error;
  char *c_out;

  if (!in)
    return std::string("(null)");
  c_out = mono_string_to_utf8_checked(in, &error);
  if (!mono_error_ok(&error)) {
    s_out = std::string(mono_error_get_message(&error));
    mono_error_cleanup(&error);
    return s_out;
  } else {
    s_out = std::string(c_out);
    mono_free(c_out);
    return s_out;
  }
}

template <>
int lang2cxx< gint32, int >(gint32 in)
{
  return (int)in;
}

template <>
bool lang2cxx< gint32, bool >(gint32 in)
{
  return (bool)in;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<int> >(std::vector<int> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_get_int32_class();
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);

  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, int >(in[i])));

  return maArray;
}

template <>
std::vector<int> lang2cxx< MonoArray*, std::vector<int> >(MonoArray* in)
{
  std::vector< int > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, int >(mono_array_get(in, gint32, i)));

  return out;
}
///
// Information sur les cases
//
template <>
gint32 cxx2lang< gint32, case_info >(case_info in)
{
  return (gint32)in;
}

template <>
case_info lang2cxx< gint32, case_info >(gint32 in)
{
  return (case_info)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<case_info> >(std::vector<case_info> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "CaseInfo");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, case_info >(in[i])));
  return maArray;
}

template <>
std::vector<case_info> lang2cxx< MonoArray*, std::vector<case_info> >(MonoArray* in)
{
  std::vector< case_info > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, case_info >(mono_array_get(in , gint32, i)));
  return out;
}

///
// Erreurs possibles
//
template <>
gint32 cxx2lang< gint32, erreur >(erreur in)
{
  return (gint32)in;
}

template <>
erreur lang2cxx< gint32, erreur >(gint32 in)
{
  return (erreur)in;
}
template <>
MonoArray* cxx2lang< MonoArray*, std::vector<erreur> >(std::vector<erreur> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Erreur");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_set(maArray, gint32, i, (cxx2lang< gint32, erreur >(in[i])));
  return maArray;
}

template <>
std::vector<erreur> lang2cxx< MonoArray*, std::vector<erreur> >(MonoArray* in)
{
  std::vector< erreur > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< gint32, erreur >(mono_array_get(in , gint32, i)));
  return out;
}

///
// Représente la position sur la carte
//
template <>
MonoObject* cxx2lang< MonoObject*, position >(position in)
{
  void* arg;
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.x));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "X"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.y));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Y"), &arg);
  return moObj;
}

template <>
position lang2cxx< MonoObject*, position >(MonoObject* in)
{
    position out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "X"), &out.x);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Y"), &out.y);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<position> >(std::vector<position> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Position");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, position >(in[i])));
  return maArray;
}

template <>
std::vector<position> lang2cxx< MonoArray*, std::vector<position> >(MonoArray* in)
{
  std::vector< position > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, position >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

///
// Représente une tourelle
//
template <>
MonoObject* cxx2lang< MonoObject*, tourelle >(tourelle in)
{
  void* arg;
  MonoClass*  mcKlass  = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Tourelle");
  MonoObject* moObj    = mono_object_new(gl_csharp.getDomain(), mcKlass);
mono_runtime_object_init(moObj);
  arg = reinterpret_cast< void* >(cxx2lang< MonoObject*, position >(in.pos));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Pos"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.portee));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Portee"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.joueur));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Joueur"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.vie));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Vie"), &arg);
  arg = reinterpret_cast< void* >(cxx2lang< gint32, int >(in.attaque));
  mono_field_set_value(moObj, mono_class_get_field_from_name(mcKlass, "Attaque"), &arg);
  return moObj;
}

template <>
tourelle lang2cxx< MonoObject*, tourelle >(MonoObject* in)
{
    tourelle out;
  void*      field_out;
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Tourelle");
  (void)field_out;
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Pos"), &field_out);
  out.pos = lang2cxx< MonoObject*, position >(reinterpret_cast< MonoObject* >(field_out));
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Portee"), &out.portee);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Joueur"), &out.joueur);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Vie"), &out.vie);
  mono_field_get_value(in, mono_class_get_field_from_name(mcKlass, "Attaque"), &out.attaque);
  return out;
}

template <>
MonoArray* cxx2lang< MonoArray*, std::vector<tourelle> >(std::vector<tourelle> in)
{
  gint32 size = in.size();
  MonoClass* mcKlass = mono_class_from_name(gl_csharp.getImage(), "Prologin", "Tourelle");
  MonoArray * maArray = mono_array_new(gl_csharp.getDomain(), mcKlass, size);
  for (int i = 0; i < size; ++i)
    mono_array_setref(maArray, i, (cxx2lang< MonoObject*, tourelle >(in[i])));
  return maArray;
}

template <>
std::vector<tourelle> lang2cxx< MonoArray*, std::vector<tourelle> >(MonoArray* in)
{
  std::vector< tourelle > out;
  gint32 size = mono_array_length(in);

  for (int i = 0; i < size; ++i)
    out.push_back(lang2cxx< MonoObject*, tourelle >(reinterpret_cast<MonoObject*>(mono_array_get(in, MonoObject*, i))));
  return out;
}

gint32 info_case(MonoObject* pos)
{
	return cxx2lang< gint32, case_info >(api_info_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoArray* tourelles_joueur(gint32 joueur)
{
	return cxx2lang< MonoArray*, std::vector<tourelle> >(api_tourelles_joueur(lang2cxx< gint32, int >(joueur)))
;
}

gint32 magie(gint32 joueur)
{
	return cxx2lang< gint32, int >(api_magie(lang2cxx< gint32, int >(joueur)))
;
}

gint32 nb_sorciers(MonoObject* pos, gint32 joueur)
{
	return cxx2lang< gint32, int >(api_nb_sorciers(lang2cxx< MonoObject*, position >(pos), lang2cxx< gint32, int >(joueur)))
;
}

gint32 nb_sorciers_deplacables(MonoObject* pos, gint32 joueur)
{
	return cxx2lang< gint32, int >(api_nb_sorciers_deplacables(lang2cxx< MonoObject*, position >(pos), lang2cxx< gint32, int >(joueur)))
;
}

gint32 joueur_case(MonoObject* pos)
{
	return cxx2lang< gint32, int >(api_joueur_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoObject* tourelle_case(MonoObject* pos)
{
	return cxx2lang< MonoObject*, tourelle >(api_tourelle_case(lang2cxx< MonoObject*, position >(pos)))
;
}

MonoObject* base_joueur(gint32 joueur)
{
	return cxx2lang< MonoObject*, position >(api_base_joueur(lang2cxx< gint32, int >(joueur)))
;
}

gint32 constructible(MonoObject* pos, gint32 joueur)
{
	return cxx2lang< gint32, bool >(api_constructible(lang2cxx< MonoObject*, position >(pos), lang2cxx< gint32, int >(joueur)))
;
}

MonoArray* chemin(MonoObject* pos1, MonoObject* pos2)
{
	return cxx2lang< MonoArray*, std::vector<position> >(api_chemin(lang2cxx< MonoObject*, position >(pos1), lang2cxx< MonoObject*, position >(pos2)))
;
}

gint32 construire(MonoObject* pos, gint32 portee)
{
	return cxx2lang< gint32, erreur >(api_construire(lang2cxx< MonoObject*, position >(pos), lang2cxx< gint32, int >(portee)))
;
}

gint32 supprimer(MonoObject* pos)
{
	return cxx2lang< gint32, erreur >(api_supprimer(lang2cxx< MonoObject*, position >(pos)))
;
}

gint32 tirer(gint32 pts, MonoObject* tourelle, MonoObject* cible)
{
	return cxx2lang< gint32, erreur >(api_tirer(lang2cxx< gint32, int >(pts), lang2cxx< MonoObject*, position >(tourelle), lang2cxx< MonoObject*, position >(cible)))
;
}

gint32 creer(gint32 nb)
{
	return cxx2lang< gint32, erreur >(api_creer(lang2cxx< gint32, int >(nb)))
;
}

gint32 deplacer(MonoObject* depart, MonoObject* arrivee, gint32 nb)
{
	return cxx2lang< gint32, erreur >(api_deplacer(lang2cxx< MonoObject*, position >(depart), lang2cxx< MonoObject*, position >(arrivee), lang2cxx< gint32, int >(nb)))
;
}

gint32 assieger(MonoObject* pos, MonoObject* cible, gint32 nb_sorciers)
{
	return cxx2lang< gint32, erreur >(api_assieger(lang2cxx< MonoObject*, position >(pos), lang2cxx< MonoObject*, position >(cible), lang2cxx< gint32, int >(nb_sorciers)))
;
}

gint32 moi()
{
	return cxx2lang< gint32, int >(api_moi())
;
}

MonoArray* adversaires()
{
	return cxx2lang< MonoArray*, std::vector<int> >(api_adversaires())
;
}

gint32 tour_actuel()
{
	return cxx2lang< gint32, int >(api_tour_actuel())
;
}

gint32 distance(MonoObject* depart, MonoObject* arrivee)
{
	return cxx2lang< gint32, int >(api_distance(lang2cxx< MonoObject*, position >(depart), lang2cxx< MonoObject*, position >(arrivee)))
;
}

gint32 annuler()
{
	return cxx2lang< gint32, erreur >(api_annuler())
;
}

void afficher_case_info(gint32 v)
{
	api_afficher_case_info(lang2cxx< gint32, case_info >(v))
;
}

void afficher_erreur(gint32 v)
{
	api_afficher_erreur(lang2cxx< gint32, erreur >(v))
;
}

void afficher_position(MonoObject* v)
{
	api_afficher_position(lang2cxx< MonoObject*, position >(v))
;
}

void afficher_tourelle(MonoObject* v)
{
	api_afficher_tourelle(lang2cxx< MonoObject*, tourelle >(v))
;
}


/*
** Inititialize Mono and load the DLL file.
*/
CSharpInterface::CSharpInterface()
{
  const char*		champion_path = getenv("CHAMPION_PATH");
  std::string		champion;

  if (!champion_path)
    champion = "./champion-prologin.dll";
  else
  {
    champion = champion_path;
    champion += "/champion-prologin.dll";
  }

  _domain = mono_jit_init(champion.c_str());
  assert(_domain != NULL);

  _assembly = mono_domain_assembly_open(_domain, champion.c_str());
  assert(_assembly != NULL);

  _image = mono_assembly_get_image(_assembly);
  assert(_image != NULL);

  _class = mono_class_from_name(_image, "Prologin", "Prologin");
  assert(_class != NULL);

  _object = mono_object_new(_domain, _class);
  assert(_object);

  mono_runtime_object_init(_object);

  // Register API functions as internal Mono functions
  mono_add_internal_call("Prologin.Api::InfoCase", (const void*)info_case);
  mono_add_internal_call("Prologin.Api::TourellesJoueur", (const void*)tourelles_joueur);
  mono_add_internal_call("Prologin.Api::Magie", (const void*)magie);
  mono_add_internal_call("Prologin.Api::NbSorciers", (const void*)nb_sorciers);
  mono_add_internal_call("Prologin.Api::NbSorciersDeplacables", (const void*)nb_sorciers_deplacables);
  mono_add_internal_call("Prologin.Api::JoueurCase", (const void*)joueur_case);
  mono_add_internal_call("Prologin.Api::TourelleCase", (const void*)tourelle_case);
  mono_add_internal_call("Prologin.Api::BaseJoueur", (const void*)base_joueur);
  mono_add_internal_call("Prologin.Api::Constructible", (const void*)constructible);
  mono_add_internal_call("Prologin.Api::Chemin", (const void*)chemin);
  mono_add_internal_call("Prologin.Api::Construire", (const void*)construire);
  mono_add_internal_call("Prologin.Api::Supprimer", (const void*)supprimer);
  mono_add_internal_call("Prologin.Api::Tirer", (const void*)tirer);
  mono_add_internal_call("Prologin.Api::Creer", (const void*)creer);
  mono_add_internal_call("Prologin.Api::Deplacer", (const void*)deplacer);
  mono_add_internal_call("Prologin.Api::Assieger", (const void*)assieger);
  mono_add_internal_call("Prologin.Api::Moi", (const void*)moi);
  mono_add_internal_call("Prologin.Api::Adversaires", (const void*)adversaires);
  mono_add_internal_call("Prologin.Api::TourActuel", (const void*)tour_actuel);
  mono_add_internal_call("Prologin.Api::Distance", (const void*)distance);
  mono_add_internal_call("Prologin.Api::Annuler", (const void*)annuler);
  mono_add_internal_call("Prologin.Api::AfficherCaseInfo", (const void*)afficher_case_info);
  mono_add_internal_call("Prologin.Api::AfficherErreur", (const void*)afficher_erreur);
  mono_add_internal_call("Prologin.Api::AfficherPosition", (const void*)afficher_position);
  mono_add_internal_call("Prologin.Api::AfficherTourelle", (const void*)afficher_tourelle);
}

MonoImage* CSharpInterface::getImage()
{
    return _image;
}

MonoDomain* CSharpInterface::getDomain()
{
    return _domain;
}

CSharpInterface::~CSharpInterface()
{
  mono_image_close(_image);
  mono_assembly_close(_assembly);
  // XXX -- mono segfaults when calling this. Seems to be a known bug
  //        appearing when mono_jit_clean() is called from a dtor. ???
  //mono_jit_cleanup(_domain);
}

/*
** Calls C# functions from C++
*/
MonoObject* CSharpInterface::callCSharpMethod(const char* name)
{
  MonoThread*   thread = mono_thread_attach(_domain);
  MonoMethod*   method = mono_class_get_method_from_name(_class, name, 0);
  MonoObject*   object = mono_runtime_invoke(method, _object, NULL, NULL);

  mono_thread_detach(thread);

  return object;
}

/*
** Functions called from stechec to C.
*/
void partie_debut()
{
  gl_csharp.callCSharpMethod("PartieDebut");
}
void phase_construction()
{
  gl_csharp.callCSharpMethod("PhaseConstruction");
}
void phase_deplacement()
{
  gl_csharp.callCSharpMethod("PhaseDeplacement");
}
void phase_tirs()
{
  gl_csharp.callCSharpMethod("PhaseTirs");
}
void phase_siege()
{
  gl_csharp.callCSharpMethod("PhaseSiege");
}
void partie_fin()
{
  gl_csharp.callCSharpMethod("PartieFin");
}
