# -*- coding: utf-8 -*-


from heapq import heappush, heappop

import api
from api import erreur

from utils import _, moi, game, dist, chemin, prochaine_etape
from utils import ennemy_turrets, Armee



def partie_debut():
    pass

FONTAINES = {(15,0), (0,15), (15, 30), (30, 15)}
ARTEFACT = {(15,15)}

DEFENSE_OK = False
SCHEMA_DEFENSE = ((3,0), (3,1), (0,2), (2,3), (1,1))

OBJECTIFS = {(0,15):None, (15,0):None, (15, 30):None, (30, 15):None,
             (15, 15):None}
ARMEE = Armee()

def phase_construction():
    global OBJECTIFS
    global DEFENSE_OK
    for turret in SCHEMA_DEFENSE:
        if not (game.info_case(turret) == api.case_info.CASE_TOURELLE and
                game.tourelle_case(turret).joueur == moi.id_):
            DEFENSE_OK = False
            moi.construire(turret, 3)
            return
    else:
           DEFENSE_OK = True
    if DEFENSE_OK:
        moi.creer(10)
    if api.tour_actuel() == 20:
        OBJECTIFS = {(15,15):None}

    ARMEE.update_construction()

def get_sorciers():
    sorciers = {}
    for x in range(api.TAILLE_TERRAIN):
        for y in range(api.TAILLE_TERRAIN):
            n = moi.nb_sorciers((x, y))
            if n:
                sorciers[(x, y)] = n
    return sorciers

def objectif_plus_proche(c):
    dist_obj = 1000
    objectif = None
    for obj in OBJECTIFS:
        if dist(c, obj) < dist_obj:
            objectif = obj
    return objectif



def repartir(sorciers):
    """Attribuer a chaque objectif les sorciers les plus proches."""

    repartition = {a:[] for a in OBJECTIFS}
    for sorcier, n in sorciers.items():
        obj = objectif_plus_proche(sorcier)
        repartition[obj].append((sorcier, n))
    return repartition

def phase_deplacement():
    global OBJECTIFS

    # avant le reste donc pas besoin de les enlever de repartir(),
    # il va y avoir une erreure silencieuse de l'api
    ARMEE.update_deplacement()

    if DEFENSE_OK:
        #TODO enlever les sorciers geres par l'armee
        repartition = repartir(get_sorciers())

        for obj in OBJECTIFS:
            if not game.joueur_case(obj) == moi.id_:
                OBJECTIFS[obj] = []
                turrets = ennemy_turrets(obj, 5)
                if turrets:
                    OBJECTIFS[obj].extend(turrets)
                    print("objectif", OBJECTIFS[obj])
                    #ARMEE.add(min(len(OBJECTIFS[obj])*30, 120), obj)
                else:
                    for sorcier, n in repartition[obj]:
                        arrivee = prochaine_etape(sorcier, obj, tourelle=0)
                        err = moi.deplacer(sorcier, arrivee, n)
                        print(err)


def phase_tirs():
    for c in FONTAINES:
        pass


def phase_siege():
    pass

def partie_fin():
    pass