# -*- coding: utf-8 -*-


import api

from utils import _


class Joueur():
    def __init__(self, id):
        self.id_ = id_
        self.base = api.base_joueur(id_)

    def nb_sorciers(self, c):
        return api.nb_sorciers(_(*c), self.id_)

    def nb_sorciers_deplacable(self, c):
        return api.nb_sorciers_deplacable(_(*c), self.id_)

    def constructible(self, c):
        return api.constructible(_(*c), self.id_)

    def tourelles_joueur(self):
        a = api.tourelles_joueur(self.id_)
        return [_(*c.pos) for c in a]

    def base_joueur(self):
        return _(*api.base_joueur(self.id_))

    def magie(self):
        return api.magie(self.id_)

    def constructible(self, c):
        return api.constructible(_(*c), self.id_)


class Moi(Joueur):
    def __init__(self):
        super().__init__(api.moi())

    def construire(self, c, portee):
        api.construire(_(*c), portee)

    def supprimer(self, c):
        api.detruire(_(*c))

    def tirer(self, pts, a, b):
        api.tirer(pts, _(*a), _(*b))

    def creer(self, n):
        api.creer(n)

    def deplacer(self, a, b, n):
        api.deplacer(_(*a), _(*b), n)

    def assieger(self, a, b, n):
        api.assieger(_(*a), _(*b), n)

class Action():
    def __init__(self, n, cible):
        self.n = n
        self.cible = cible

    def lancer(self):
        self.n = min(self.n, api.magie(MOI)//api.COUT_SORCIER)
        api.creer(self.n)
        self.pos = (0,0)

    def deplacer(self):
        chemin = api.chemin(_(0, 0), _(*self.cible))
        self.n = min(self.n, api.nb_sorciers(_(*self.pos), MOI))

def partie_debut():
    pass


def phase_construction():
    pass


def phase_deplacement():
    pass


def phase_tirs():
    pass


def phase_siege():
    pass