# -*- coding: utf-8 -*-
from _api import *

# Taille du terrain (longueur et largeur)
TAILLE_TERRAIN = 31

# Nombre de joueurs dans la partie
NB_JOUEURS = 4

# Nombre maximum de tours à jouer avant la fin de la partie
MAX_TOUR = 100

# Magie gagnée à chaque tour
MAGIE_TOUR = 20

# Magie gagnée à chaque tour pour chaque fontaine possédée
MAGIE_FONTAINES = 15

# Magie gagnée à chaque sorcier tué
MAGIE_COMBAT = 1

# Magie récupérée à chaque tourelle supprimée
MAGIE_SUPPRESSION = 10

# Nombre de points de magie par sorcier
COUT_SORCIER = 2

# Nombre de points de magie par tourelle
COUT_TOURELLE = 20

# Coût exponentiel pour chaque case de portée supplémentaire
COUT_PORTEE = 4

# Nombre maximum de cases qu'un sorcier peut franchir à chaque tour.
PORTEE_SORCIER = 4

# Portée de base d'une tourelle
PORTEE_TOURELLE = 3

# Portée de construction des tourelles
CONSTRUCTION_TOURELLE = 3

# Points de vie d'une tourelle à sa création
VIE_TOURELLE = 10

# Points d'attaque d'une tourelle au début d'un tour
ATTAQUE_TOURELLE = 10

# Points gagnés pour avoir survécu à la fin de la partie
POINTS_SURVIVRE = 1

# Points gagnés pour avoir vaincu un adversaire
POINTS_VAINQUEUR = 1

# Points gagnés pour contrôler une fontaine à la fin de la partie
POINTS_CONTROLE_FONTAINE = 1

# Points gagnés pour contrôler un artefact à la fin de la partie
POINTS_CONTROLE_ARTEFACT = 4

# Information sur les cases
(
    CASE_SIMPLE, # <- Case simple
    CASE_TOURELLE, # <- Tourelle
    CASE_BASE, # <- Base du joueur
    CASE_FONTAINE, # <- Fontaine magique
    CASE_ARTEFACT, # <- Artefact magique
    CASE_ERREUR, # <- Erreur
) = range(6)


# Erreurs possibles
(
    OK, # <- L'action s'est effectuée avec succès
    ANNULER_IMPOSSIBLE, # <- Aucune action à annuler
    CASE_IMPOSSIBLE, # <- Cette case n'existe pas
    CASE_ADVERSE, # <- Vous ne contrôlez pas cette case
    CASE_UTILISEE, # <- Cette case n'est pas libre
    CASE_VIDE, # <- Cette case est vide
    VALEUR_INVALIDE, # <- Cette valeur est invalide
    MAGIE_INSUFFISANTE, # <- Vous n'avez pas assez de magie
    SORCIERS_INSUFFISANTS, # <- Vous n'avez pas assez de sorciers
    ATTAQUE_INSUFFISANTE, # <- Vous n'avez pas assez de points d'attaque
    PHASE_INCORRECTE, # <- Cette action ne peut pas être utilisée lors de cette phase du jeu.
    PORTEE_INSUFFISANTE, # <- Vous n'avez pas assez de portée pour effectuer cette action
    PERDANT, # <- Vous avez perdu et ne pouvez pas effectuer d'actions
) = range(13)


from collections import namedtuple

# Représente la position sur la carte

# Représente une tourelle
tourelle = namedtuple("tourelle",
    'pos ' # <- Position de la tourelle
    'portee ' # <- Portée de la tourelle
    'joueur ' # <- Joueur qui possède la tourelle
    'vie ' # <- Nombre de points de vie de la tourelle
    'attaque ' # <- Nombre de points d'attaque de la tourelle
)


