# -*- coding: utf-8 -*-

"""47

Ceci est une 47 qui joue au windosium levista
"""

import api

from utils import Armee

class Bataillon():
    def __init__(self, n, cible, armee):
        self.n = n
        self.effectif = 0
        self.cible = cible
        self.pos = None
        self.armee = armee

    def fixe_cible(self, cible):
        self.cible = cible

    def creer(self):
        n = min(self.n, moi.magie()//api.COUT_SORCIER)
        moi.creer(n)
        self.pos = (0,0)
        self.armee.bataillon_cree(self)


    def deplacer(self):
        self.n = min(self.n, api.nb_sorciers(self.pos, moi))
        arrivee = prochaine_etape(self.pos, self.cible)
        emoi.deplacer(self.pos, arrivee, self.n)
        self.pos = arrivee

class B42():
    SCHEMA = ((1,0), (1,1), (1,2), (2,2), (3,1), (3,2), (3,3), (5,0), (6,0),
              (7,0), (7,1), (5,2), (5,3), (6,3), (7,3))

    @classmethod
    def flip(cls):
        base = api.base_joueur(api.moi())
        if base[0] == api.TAILLE_TERRAIN - 1:
            cls.SCHEMA = [(7 - c[0], c[1]) for c in cls.SCHEMA]
        if base[1] == api.TAILLE_TERRAIN - 1:
            cls.SCHEMA = [(c[0], 3 - c[1]) for c in cls.SCHEMA]


    def __init__(self, cible, armee):
        self.cible = cible
        self.pos = None
        self.armee = armee
        self.constituants = []
        for t in self.SCHEMA:
            self.constituants.append(Bataillon(1, t, self))

        self.ready = False
        self.counter = 0

    def creer(self):
        for t in self.constituants:
            t.creer()

    def deplacer(self):
        if not self.ready:
            for t in self.constituants:
                t.deplacer()
        else:
            for t in self.constituants:
                if self.counter % 4 == 2:
                    t.fixe_cible((t.cible[0]+1, t.cible[1]))
                elif self.counter % 4 == 3:
                    t.fixe_cible((t.cible[0], t.cible[1]+1))
                elif self.counter % 4 == 0:
                    t.fixe_cible((t.cible[0]-1, t.cible[1]))
                elif self.counter % 4 == 1:
                    t.fixe_cible((t.cible[0], t.cible[1]-1))
        self.counter += 1



class Armee():
    def __init__(self):
        self.bataillons = []
        self.bataillons_a_creer = []
        self.bataillons_a_deplacer = []

    def update_construction(self):
        for bat in self.bataillons_a_creer:
            bat.creer()

    def update_deplacement(self):
        for bat in self.bataillons_a_deplacer:
            bat.deplacer()

    def bataillon_arrive(self, bat):
        self.bataillons_a_deplacer.remove(bat)

    def bataillon_cree(self, bat):
        self.bataillons_a_creer.remove(bat)
        self.bataillons_a_deplacer.append(bat)

    def add(self, n, cible):
        bat = Bataillon(cible, self)
        self.bataillons.append(bat)
        self.bataillons_a_creer.append(bat)

def partie_debut():
    global SCHEMA
    base = api.base_joueur(api.moi())
    if base[0] == api.TAILLE_TERRAIN - 1:
        SCHEMA = [(7 - c[0], c[1]) for c in SCHEMA]
    if base[1] == api.TAILLE_TERRAIN - 1:
        SCHEMA = [(c[0], 3 - c[1]) for c in SCHEMA]

def phase_construction():
    tour = api.tour_actuel()
    if tour == 1:
        for t in SCHEMA:
            armee.add(1, t)
    elif tour >= 10:
        for t in armee.bataillons:
            if tour % 4 == 2:
                t.fixe_cible((t.cible[0]+1, t.cible[1]))
            elif tour % 4 == 3:
                t.fixe_cible((t.cible[0], t.cible[1]+1))
            elif tour % 4 == 0:
                t.fixe_cible((t.cible[0]-1, t.cible[1]))
            elif tour % 4 == 1:
                t.fixe_cible((t.cible[0], t.cible[1]-1))
    armee.update_construction()

def phase_deplacement():
    armee.update_deplacement()

def phase_tirs():
    pass

def phase_siege():
    pass

def partie_fin():
    pass

armee = Armee()
moi = api.moi()