# -*- coding: utf-8 -*-


from api import erreur as err


class ProloginError(Exception):
    pass

class AnnulerImpossible(ProloginError):
    pass

class CaseImpossible(ProloginError):
    pass

class CaseAdverse(ProloginError):
    pass

class CaseUtilisee(ProloginError):
    pass

class CaseVide(ProloginError):
    pass

class ValeurInvalide(ProloginError):
    pass

class MagieInsuffisante(ProloginError):
    pass

class SorciersInsuffisants(ProloginError):
    pass

class AttaqueInsuffisante(ProloginError):
    pass

class PhaseIncorrecte(ProloginError):
    pass

class PorteeInsuffisante(ProloginError):
    pass

class Perdant(ProloginError):
    pass

TABLE = {err.ANNULER_IMPOSSIBLE:AnnulerImpossible,
         err.CASE_IMPOSSIBLE:CaseImpossible,
         err.CASE_ADVERSE:CaseAdverse,
         err.CASE_UTILISEE:CaseUtilisee,
         err.CASE_VIDE:CaseVide,
         err.VALEUR_INVALIDE:ValeurInvalide,
         err.MAGIE_INSUFFISANTE:MagieInsuffisante,
         err.SORCIERS_INSUFFISANTS:SorciersInsuffisants,
         err.ATTAQUE_INSUFFISANTE:AttaqueInsuffisante,
         err.PHASE_INCORRECTE:PhaseIncorrecte,
         err.PORTEE_INSUFFISANTE:PorteeInsuffisante,
         err.PERDANT:Perdant}


def handle_error(code):
    raise TABLE[code]()