# encoding: utf-8
# module pyalpm calls itself alpm
# from /usr/lib/python3.4/site-packages/pyalpm.cpython-34m.so
# by generator 1.135
""" This module wraps the libalpm library """
# no imports

# Variables with simple values

LOG_DEBUG = 4
LOG_ERROR = 1
LOG_FUNCTION = 8
LOG_WARNING = 2

PKG_REASON_DEPEND = 1
PKG_REASON_EXPLICIT = 0

SIG_DATABASE = 1024

SIG_DATABASE_MARGINAL_OK = 4096

SIG_DATABASE_OPTIONAL = 2048

SIG_DATABASE_UNKNOWN_OK = 8192

SIG_PACKAGE = 1

SIG_PACKAGE_MARGINAL_OK = 4

SIG_PACKAGE_OPTIONAL = 2

SIG_PACKAGE_UNKNOWN_OK = 8

# functions

def alpmversion(*args, **kwargs): # real signature unknown
    """ returns alpm version. """
    pass

def find_grp_pkgs(*args, **kwargs): # real signature unknown
    """
    find packages from a given group across databases
    args: a list of databases, a group name
    """
    pass

def find_satisfier(*args, **kwargs): # real signature unknown
    """
    finds a package satisfying the given dependency among a list
    args: a list of packages, a dependency string
    returns: a Package object or None
    """
    pass

def sync_newversion(*args, **kwargs): # real signature unknown
    """
    finds an available upgrade for a package in a list of databases
    args: a package, a list of databases
    returns: an upgrade candidate or None
    """
    pass

def vercmp(*args, **kwargs): # real signature unknown
    """ compares version strings """
    pass

def version(*args, **kwargs): # real signature unknown
    """ returns pyalpm version. """
    pass

# classes

from .object import object

class DB(object):
    """ libalpm DB object """
    def get_pkg(self, *args, **kwargs): # real signature unknown
        """
        get a package by name
        args: a package name (string)
        returns: a Package object or None if not found
        """
        pass

    def read_grp(self, *args, **kwargs): # real signature unknown
        """
        get contents of a group
        args: a group name (string)
        returns: a tuple (group name, list of packages)
        """
        pass

    def search(self, *args, **kwargs): # real signature unknown
        """
        search for packages matching a list of regexps
        args: a variable number of regexps (strings)
        returns: packages matching all these regexps
        """
        pass

    def update(self, *args, **kwargs): # real signature unknown
        """
        update a database from its url attribute
        args: force (update even if DB is up to date, boolean)
        returns: True if an update has been done
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    grpcache = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """(read only) list of package groups"""

    name = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """database name (e.g. "core", "extra")"""

    pkgcache = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """(read only) list of packages"""

    servers = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """a list of URLs (for sync DBs)"""



from .Exception import Exception

class error(Exception):
    """
    Exception raised when an error arises from libalpm
    The args attribute will usually contain a tuple (error message, errno from libalpm, extra data)
    """
    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    __weakref__ = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of weak references to the object (if defined)"""



from .object import object

class Handle(object):
    """ An object wrapping a libalpm handle. Arguments: root path, DB path. """
    def add_cachedir(self, *args, **kwargs): # real signature unknown
        """ adds a cachedir. """
        pass

    def add_ignoregrp(self, *args, **kwargs): # real signature unknown
        """ add an ignoregrp. """
        pass

    def add_ignorepkg(self, *args, **kwargs): # real signature unknown
        """ add an ignorepkg. """
        pass

    def add_noextract(self, *args, **kwargs): # real signature unknown
        """ add a noextract package. """
        pass

    def add_noupgrade(self, *args, **kwargs): # real signature unknown
        """ add a noupgrade package. """
        pass

    def get_localdb(self, *args, **kwargs): # real signature unknown
        """ returns an object representing the local DB """
        pass

    def get_syncdbs(self, *args, **kwargs): # real signature unknown
        """ returns a list of sync DBs """
        pass

    def init_transaction(self, *args, **kwargs): # real signature unknown
        """
        Initializes a transaction.
        Arguments:
          nodeps, force, nosave, nodepversion, cascade, recurse,
          dbonly, alldeps, downloadonly, noscriptlet, noconflicts,
          needed, allexplicit, inneeded, recurseall, nolock
            -- the transaction options (booleans)
        """
        pass

    def load_pkg(self, *args, **kwargs): # real signature unknown
        """ loads package information from a tarball """
        pass

    def register_syncdb(self, *args, **kwargs): # real signature unknown
        """
        registers the database with the given name
        returns the new database on success
        """
        pass

    def remove_cachedir(self, *args, **kwargs): # real signature unknown
        """ removes a cachedir. """
        pass

    def remove_ignoregrp(self, *args, **kwargs): # real signature unknown
        """ remove an ignoregrp. """
        pass

    def remove_ignorepkg(self, *args, **kwargs): # real signature unknown
        """ remove an ignorepkg. """
        pass

    def remove_noextract(self, *args, **kwargs): # real signature unknown
        """ remove a noextract package. """
        pass

    def remove_noupgrade(self, *args, **kwargs): # real signature unknown
        """ removes a noupgrade package. """
        pass

    def set_pkgreason(self, *args, **kwargs): # real signature unknown
        """ set install reason for a package (PKG_REASON_DEPEND, PKG_REASON_EXPLICIT) """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    @staticmethod # known case of __new__
    def __new__(*args, **kwargs): # real signature unknown
        """ Create and return a new object.  See help(type) for accurate signature. """
        pass

    arch = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """Target archichecture"""

    cachedirs = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of package cache directories"""

    checkspace = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """check disk space before transactions (an integer, 0 = False, 1 = True)"""

    dbpath = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """alpm database directory"""

    deltaratio = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """set deltaratio (a float). Deltas are enabled if this is nonzero."""

    dlcb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """download status callback (a function)
args: filename    :: str
      transferred :: int
      total       :: int
"""

    eventcb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """  a function called when an event occurs
    -- args: (event ID, event string, (object 1, object 2))
"""

    fetchcb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """download function
args: url              :: string
      destination path :: string
      overwrite        :: bool
returns: 0 on success, 1 if file exists, -1 on error"""

    gpgdir = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """alpm GnuPG home directory"""

    ignoregrps = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of ignored groups"""

    ignorepkgs = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of ignored packages"""

    lockfile = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """alpm lockfile path"""

    logcb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """logging callback, with arguments (loglevel, format string, tuple)"""

    logfile = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """alpm logfile path"""

    noextracts = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of ..."""

    noupgrades = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of ..."""

    progresscb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """  -- a function called to indicate progress
    -- args: (target name, percentage, number of targets, target number)
"""

    questioncb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """  a function called to get user input
"""

    root = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """system root directory"""

    totaldlcb = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """total download size callback: totaldlcb(total_size)"""

    usesyslog = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """use syslog (an integer, 0 = False, 1 = True)"""



from .object import object

class Package(object):
    """ Package object """
    def compute_requiredby(self, *args, **kwargs): # real signature unknown
        """ computes the list of packages requiring this package """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    def __repr__(self, *args, **kwargs): # real signature unknown
        """ Return repr(self). """
        pass

    def __str__(self, *args, **kwargs): # real signature unknown
        """ Return str(self). """
        pass

    arch = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """target architecture"""

    backup = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of tuples (filename, md5sum)"""

    base64_sig = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """GPG signature encoded as base64"""

    builddate = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """building time"""

    conflicts = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of conflicts"""

    db = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """the database from which the package comes from, or None"""

    deltas = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of available deltas"""

    depends = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of dependencies"""

    desc = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package desc"""

    download_size = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """predicted download size for this package"""

    filename = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package filename"""

    files = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of installed files"""

    groups = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of package groups"""

    has_scriptlet = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """True if the package has an install script"""

    installdate = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """install time"""

    isize = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """installed size"""

    licenses = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of licenses"""

    md5sum = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package md5sum"""

    name = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package name"""

    optdepends = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of optional dependencies"""

    packager = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """packager name"""

    provides = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of provided package names"""

    reason = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """install reason (0 = explicit, 1 = depend)"""

    replaces = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """list of replaced packages"""

    sha256sum = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package sha256sum as hexadecimal digits"""

    size = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package size"""

    url = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package URL"""

    version = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """package version"""



from .object import object

class Transaction(object):
    """ This class is the main interface to get/set libalpm options """
    def add_pkg(self, *args, **kwargs): # real signature unknown
        """ append a package addition to transaction """
        pass

    def commit(self, *args, **kwargs): # real signature unknown
        """ commit """
        pass

    def interrupt(self, *args, **kwargs): # real signature unknown
        """ Interrupt the transaction. """
        pass

    def prepare(self, *args, **kwargs): # real signature unknown
        """ prepare """
        pass

    def release(self, *args, **kwargs): # real signature unknown
        """ Release the transaction. """
        pass

    def remove_pkg(self, *args, **kwargs): # real signature unknown
        """ append a package removal to transaction """
        pass

    def sysupgrade(self, *args, **kwargs): # real signature unknown
        """
        set the transaction to perform a system upgrade
        args:
          transaction (boolean) : whether to enable downgrades
        """
        pass

    def __init__(self, *args, **kwargs): # real signature unknown
        pass

    flags = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """Transaction flags"""

    to_add = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """Packages added by the transaction"""

    to_remove = property(lambda self: object(), lambda self, v: None, lambda self: None)  # default
    """Packages added by the transaction"""



# variables with complex values

__loader__ = None # (!) real value is ''

__spec__ = None # (!) real value is ''

