/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_c.rb
*/

#include <stdlib.h>
#include <stdbool.h>

/*!
** Taille du terrain (longueur et largeur)
*/
# define TAILLE_TERRAIN            31

/*!
** Nombre de joueurs dans la partie
*/
# define NB_JOUEURS                4

/*!
** Nombre maximum de tours à jouer avant la fin de la partie
*/
# define MAX_TOUR                  100

/*!
** Magie gagnée à chaque tour
*/
# define MAGIE_TOUR                20

/*!
** Magie gagnée à chaque tour pour chaque fontaine possédée
*/
# define MAGIE_FONTAINES           15

/*!
** Magie gagnée à chaque sorcier tué
*/
# define MAGIE_COMBAT              1

/*!
** Magie récupérée à chaque tourelle supprimée
*/
# define MAGIE_SUPPRESSION         10

/*!
** Nombre de points de magie par sorcier
*/
# define COUT_SORCIER              2

/*!
** Nombre de points de magie par tourelle
*/
# define COUT_TOURELLE             20

/*!
** Coût exponentiel pour chaque case de portée supplémentaire
*/
# define COUT_PORTEE               4

/*!
** Nombre maximum de cases qu'un sorcier peut franchir à chaque tour.
*/
# define PORTEE_SORCIER            4

/*!
** Portée de base d'une tourelle
*/
# define PORTEE_TOURELLE           3

/*!
** Portée de construction des tourelles
*/
# define CONSTRUCTION_TOURELLE     3

/*!
** Points de vie d'une tourelle à sa création
*/
# define VIE_TOURELLE              10

/*!
** Points d'attaque d'une tourelle au début d'un tour
*/
# define ATTAQUE_TOURELLE          10

/*!
** Points gagnés pour avoir survécu à la fin de la partie
*/
# define POINTS_SURVIVRE           1

/*!
** Points gagnés pour avoir vaincu un adversaire
*/
# define POINTS_VAINQUEUR          1

/*!
** Points gagnés pour contrôler une fontaine à la fin de la partie
*/
# define POINTS_CONTROLE_FONTAINE  1

/*!
** Points gagnés pour contrôler un artefact à la fin de la partie
*/
# define POINTS_CONTROLE_ARTEFACT  4

/*!
** Information sur les cases
*/
typedef enum case_info {
  CASE_SIMPLE, /* <- Case simple */
  CASE_TOURELLE, /* <- Tourelle */
  CASE_BASE, /* <- Base du joueur */
  CASE_FONTAINE, /* <- Fontaine magique */
  CASE_ARTEFACT, /* <- Artefact magique */
  CASE_ERREUR, /* <- Erreur */
} case_info;


/*!
** Erreurs possibles
*/
typedef enum erreur {
  OK, /* <- L'action s'est effectuée avec succès */
  ANNULER_IMPOSSIBLE, /* <- Aucune action à annuler */
  CASE_IMPOSSIBLE, /* <- Cette case n'existe pas */
  CASE_ADVERSE, /* <- Vous ne contrôlez pas cette case */
  CASE_UTILISEE, /* <- Cette case n'est pas libre */
  CASE_VIDE, /* <- Cette case est vide */
  VALEUR_INVALIDE, /* <- Cette valeur est invalide */
  MAGIE_INSUFFISANTE, /* <- Vous n'avez pas assez de magie */
  SORCIERS_INSUFFISANTS, /* <- Vous n'avez pas assez de sorciers */
  ATTAQUE_INSUFFISANTE, /* <- Vous n'avez pas assez de points d'attaque */
  PHASE_INCORRECTE, /* <- Cette action ne peut pas être utilisée lors de cette phase du jeu. */
  PORTEE_INSUFFISANTE, /* <- Vous n'avez pas assez de portée pour effectuer cette action */
  PERDANT, /* <- Vous avez perdu et ne pouvez pas effectuer d'actions */
} erreur;


struct position;
struct tourelle;

typedef struct tourelle_array {
  struct tourelle* datas;
  size_t length;
} tourelle_array;

typedef struct position_array {
  struct position* datas;
  size_t length;
} position_array;

typedef struct int_array {
  int* datas;
  size_t length;
} int_array;

/*!
** Représente la position sur la carte
*/
typedef struct position {
  int x;  /* <- Coordonnée en X */
  int y;  /* <- Coordonnée en Y */
} position;


/*!
** Représente une tourelle
*/
typedef struct tourelle {
  position pos;  /* <- Position de la tourelle */
  int portee;  /* <- Portée de la tourelle */
  int joueur;  /* <- Joueur qui possède la tourelle */
  int vie;  /* <- Nombre de points de vie de la tourelle */
  int attaque;  /* <- Nombre de points d'attaque de la tourelle */
} tourelle;


/*!
** Retourne le type de la case à l'emplacement `pos`
*/
case_info info_case(position pos);

/*!
** Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
*/
tourelle_array tourelles_joueur(int joueur);

/*!
** Retourne la magie que possède le joueur ``joueur``
*/
int magie(int joueur);

/*!
** Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
*/
int nb_sorciers(position pos, int joueur);

/*!
** Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
*/
int nb_sorciers_deplacables(position pos, int joueur);

/*!
** Retourne le numéro du joueur qui contrôle la case ``pos``
*/
int joueur_case(position pos);

/*!
** Retourne la tourelle située sur la case ``pos``
*/
tourelle tourelle_case(position pos);

/*!
** Retourne la position de la base du joueur ``joueur``
*/
position base_joueur(int joueur);

/*!
** Retourne vrai si l'on peut construire sur la case ``pos``
*/
bool constructible(position pos, int joueur);

/*!
** Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
*/
position_array chemin(position pos1, position pos2);

/*!
** Construire une tourelle à la position ``pos``
*/
erreur construire(position pos, int portee);

/*!
** Supprimer une tourelle à la position ``pos``
*/
erreur supprimer(position pos);

/*!
** Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
*/
erreur tirer(int pts, position tourelle, position cible);

/*!
** Créer ``nb`` sorciers dans la base
*/
erreur creer(int nb);

/*!
** Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
*/
erreur deplacer(position depart, position arrivee, int nb);

/*!
** Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
*/
erreur assieger(position pos, position cible, int nb_sorciers);

/*!
** Retourne le numéro de votre joueur
*/
int moi(void);

/*!
** Retourne la liste des numéros de vos adversaires
*/
int_array adversaires(void);

/*!
** Retourne le numéro du tour actuel
*/
int tour_actuel(void);

/*!
** Retourne la distance entre deux positions
*/
int distance(position depart, position arrivee);

/*!
** Annule la dernière action
*/
erreur annuler(void);

/*!
** Affiche le contenu d'une valeur de type case_info
*/
void afficher_case_info(case_info v);

/*!
** Affiche le contenu d'une valeur de type erreur
*/
void afficher_erreur(erreur v);

/*!
** Affiche le contenu d'une valeur de type position
*/
void afficher_position(position v);

/*!
** Affiche le contenu d'une valeur de type tourelle
*/
void afficher_tourelle(tourelle v);

/*!
** Fonction appelée au début de la partie
*/
void partie_debut(void);

/*!
** Fonction appelée pendant la phase de construction
*/
void phase_construction(void);

/*!
** Fonction appelée pendant la phase de déplacement
*/
void phase_deplacement(void);

/*!
** Fonction appelée pendant la phase de tirs des tourelles
*/
void phase_tirs(void);

/*!
** Fonction appelée pendant la phase de siège des tourelles
*/
void phase_siege(void);

/*!
** Fonction appelée à la fin de la partie
*/
void partie_fin(void);

