///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_c.rb
//

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

# include <vector>
# include <string>

extern "C" {
# include "prologin.h"
}

///
// Représente la position sur la carte
//
typedef struct __internal__cxx__position {
  int x;
  int y;
} __internal__cxx__position;

///
// Représente une tourelle
//
typedef struct __internal__cxx__tourelle {
  __internal__cxx__position pos;
  int portee;
  int joueur;
  int vie;
  int attaque;
} __internal__cxx__tourelle;

///
// Retourne le type de la case à l'emplacement `pos`
//
extern "C" case_info api_info_case(__internal__cxx__position pos);

///
// Retourne la liste des tourelles qui appartiennent au joueur ``joueur``
//
extern "C" std::vector<__internal__cxx__tourelle> api_tourelles_joueur(int joueur);

///
// Retourne la magie que possède le joueur ``joueur``
//
extern "C" int api_magie(int joueur);

///
// Retourne le nombre de sorciers du joueur ``joueur`` sur la case ``pos``
//
extern "C" int api_nb_sorciers(__internal__cxx__position pos, int joueur);

///
// Retourne le nombre de sorciers du joueur ``joueur`` déplacables sur la case ``pos``
//
extern "C" int api_nb_sorciers_deplacables(__internal__cxx__position pos, int joueur);

///
// Retourne le numéro du joueur qui contrôle la case ``pos``
//
extern "C" int api_joueur_case(__internal__cxx__position pos);

///
// Retourne la tourelle située sur la case ``pos``
//
extern "C" __internal__cxx__tourelle api_tourelle_case(__internal__cxx__position pos);

///
// Retourne la position de la base du joueur ``joueur``
//
extern "C" __internal__cxx__position api_base_joueur(int joueur);

///
// Retourne vrai si l'on peut construire sur la case ``pos``
//
extern "C" bool api_constructible(__internal__cxx__position pos, int joueur);

///
// Retourne la liste des positions constituant le plus court chemin allant de la case ``pos1`` à la case ``pos2``. Attention : Cette fonction est lente.
//
extern "C" std::vector<__internal__cxx__position> api_chemin(__internal__cxx__position pos1, __internal__cxx__position pos2);

///
// Construire une tourelle à la position ``pos``
//
extern "C" erreur api_construire(__internal__cxx__position pos, int portee);

///
// Supprimer une tourelle à la position ``pos``
//
extern "C" erreur api_supprimer(__internal__cxx__position pos);

///
// Tirer avec ``pts`` points de dégats depuis la tourelles ``tourelle`` sur la position ``cible``
//
extern "C" erreur api_tirer(int pts, __internal__cxx__position tourelle, __internal__cxx__position cible);

///
// Créer ``nb`` sorciers dans la base
//
extern "C" erreur api_creer(int nb);

///
// Déplace ``nb`` sorciers de la position ``depart`` jusqu'à la position ``arrivee``.
//
extern "C" erreur api_deplacer(__internal__cxx__position depart, __internal__cxx__position arrivee, int nb);

///
// Attaquer la tourelle à la position ``cible`` depuis la position ``pos``
//
extern "C" erreur api_assieger(__internal__cxx__position pos, __internal__cxx__position cible, int nb_sorciers);

///
// Retourne le numéro de votre joueur
//
extern "C" int api_moi(void);

///
// Retourne la liste des numéros de vos adversaires
//
extern "C" std::vector<int> api_adversaires(void);

///
// Retourne le numéro du tour actuel
//
extern "C" int api_tour_actuel(void);

///
// Retourne la distance entre deux positions
//
extern "C" int api_distance(__internal__cxx__position depart, __internal__cxx__position arrivee);

///
// Annule la dernière action
//
extern "C" erreur api_annuler(void);

///
// Affiche le contenu d'une valeur de type case_info
//
extern "C" void api_afficher_case_info(case_info v);

///
// Affiche le contenu d'une valeur de type erreur
//
extern "C" void api_afficher_erreur(erreur v);

///
// Affiche le contenu d'une valeur de type position
//
extern "C" void api_afficher_position(__internal__cxx__position v);

///
// Affiche le contenu d'une valeur de type tourelle
//
extern "C" void api_afficher_tourelle(__internal__cxx__tourelle v);

#endif
