#include "prologin.hh"

#define FOREACH_DWARF for (int dwarf = 0; dwarf < NB_NAINS; dwarf++)
#define FOREACH_ORE for (position ore_pos : liste_minerais())

position target_ore_pos[NB_NAINS];
minerai target_ore_info[NB_NAINS];
std::vector<direction> target_path[NB_NAINS];

// Calcule la hauteur au-dessus du sol pour une case donnée
int height(position cell) {
    int ground = cell.ligne + 1;
    while (ground < TAILLE_MINE && type_case(position{ground, cell.colonne}) == LIBRE)
        ground++;
    return ground - cell.ligne - 1;
}

void partie_init() {}

void jouer_tour() {
    // Pour chaque nain, on cherche le minerai le plus rentable et on s'y
    // rend en utilisant la fonction chemin de l'API
    FOREACH_DWARF {
        nain dwarf_info = info_nain(moi(), dwarf);
        double min_cost = 999999999.;
        FOREACH_ORE {
            minerai ore_info = info_minerai(ore_pos);
            std::vector<direction> path = chemin(dwarf_info.pos, ore_pos);
            if (path.size()) {
                double cost = path.size() - 10*(double)ore_info.rendement;
                if (cost < min_cost) {
                    target_ore_pos[dwarf] = ore_pos;
                    target_ore_info[dwarf] = ore_info;
                    target_path[dwarf] = std::move(path);
                    min_cost = cost;
                }
            }
        }
        // Si on a pas assez de place, on rentre à la taverne
        if (dwarf_info.butin + target_ore_info[dwarf].rendement > BUTIN_MAX)
            target_path[dwarf] = chemin(dwarf_info.pos, position_taverne(moi()));
        // Algorithme de déplacement ultra simple
        for (direction d : target_path[dwarf]) {
            agripper(dwarf);
            if (cout_de_deplacement(dwarf, d) >= 0)
                deplacer(dwarf, d);
            else
                miner(dwarf, d);
            if (info_nain(moi(), dwarf).pm == 0)
                break;
        }
    }
}

void partie_fin() {}
